<%--
 * Copyright (c) 2004, 2006, Oracle. All rights reserved.  
 *
 *  NAME
 *    hostStorageDetails.jsp
 *
 *  DESCRIPTION
 *    Has the UI contents of the host storage details.
 *
 *  NOTES
 *
 *    We need to use jsp:include and buildTree to include the 
 *    pages - I tried to implement this on june 17th but it did not
 *    work for me for some reason (gave blank page.)
 * MODIFIED
 *    hmodawel 02/27/06 - fix ojsp 1013 compilation errors 
 *    ajere    07/20/05 - Fix bug# 4493757 
 *    ajere    06/30/05 - Fix bug# 4215132 
 *    ajere    06/02/05 - Fix bug#4215146 
 *    ajere    05/24/05 - Accessibility changes 
 *    rmenon   03/17/05 - 
 *    rmenon   02/23/05 - 
 *    rmenon   02/18/05 - 
 *    rmenon   02/10/05 - 
 *    rmenon   01/05/05 - 
 *    rmenon   12/17/04 - 
 *    rmenon   11/15/04 - combined all errors into one number
 *    rmenon   11/11/04 - 
 *    rmenon   11/04/04 - 
 *    rmenon   10/22/04 - 
 *    rmenon   10/09/04 - implemented, volumes, fs, database tabs
 *    djoly    10/04/04 - Fix relative paths for includes in same directory 
 *    rmenon   08/23/04 - comment cleanup
 *    rmenon   08/11/04 - 
 *    rmenon   08/02/04 - refresh/error page functionality
 *    rmenon   06/28/04 - rmenon_storage_disks_tab_ui
 *    rmenon   06/10/04 - Created
--%>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.cabo.ui.UIConstants' %>
<%@ page import='oracle.sysman.emSDK.svc.cache.CacheManager' %>
<%@ page import='oracle.sysman.emSDK.svc.ServiceUtil' %>
<%@ page import='oracle.sysman.eml.storage.common.StorageUIConstants' %>
<%@ page import='oracle.sysman.eml.ecm.ui.SimpleDataObjectList' %>
<%@ page import='oracle.sysman.eml.ecm.ui.EcmUIUtil' %>
<%@ page import='oracle.sysman.eml.storage.common.StorageUIConstants' %>
<%@ page import='oracle.sysman.eml.storage.common.StorageUITableUtil' %>
<%@ page import='oracle.sysman.eml.storage.common.StorageCommonSectionViewBean' %>
<%@ page import='oracle.sysman.eml.storage.resources.StorageResourceBundle' %>
<%@ page import='oracle.sysman.eml.storage.resources.StorageMsgID' %>
<%@ page import='oracle.sysman.eml.storage.host.HostStorageDBListViewBean' %>
<%@ page import='oracle.sysman.eml.storage.host.HostStorageVolumesViewBean' %>

<%
  StorageCommonSectionViewBean commonSectionViewBean = 
    (StorageCommonSectionViewBean)
    request.getAttribute( "commonSectionViewBean" );
  String relatedErrorsCount = commonSectionViewBean.getRelatedErrorCount();
  int relatedErrorsCountAsInt = 0;
  if( relatedErrorsCount != null || relatedErrorsCount.length() != 0 )
  {
    relatedErrorsCountAsInt = Integer.parseInt( relatedErrorsCount );
  }
%>
<%@ include file="/sdk/oemTop.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <%--
   * resource bundles used by this page.
  --%>

  <uix:bundle name="storageResource"
    class="oracle.sysman.eml.storage.resources.StorageResourceBundle"/>
  <uix:bundle name="sdkResource"
    class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="commonResource"
    class="oracle.sysman.resources.CommonResourceBundle"/>

  <uix:document>
    <uix:head titleBinding="pageTitle@commonSectionViewBean@servletRequest"/>
    <uix:body onLoadBinding="focusJavaScript@commonSectionViewBean@servletRequest">
      <uix:form name="hostStorageDetailsForm" method="GET">
        <uix:pageLayout >
          <%@ include file="/oemGlobal.jspf" %>
  
          <uix:contentFooter>
           <uix:pageButtonBar><uix:contents>
            <uix:switcher childNameBinding="showStorageDetailsPage@commonSectionViewBean@servletRequest">
             <uix:case name="false">
              <uix:flowLayout>
               <uix:switcher childNameBinding="showRefreshButtonEvenWhenError@commonSectionViewBean@servletRequest">
                <uix:case name="true">
                 <uix:submitButton name="event"
                                   value="refreshHostStorage"
                                   textBinding="REFRESH@commonResource"/>
               </uix:case>           
              </uix:switcher>        
              <uix:spacer width="10"/>
              <uix:button textBinding="OK@commonResource"
                          destinationBinding="hasErrorOKButtonDest@commonSectionViewBean@servletRequest"/>
              </uix:flowLayout>
             </uix:case>           
            </uix:switcher>        
           </uix:contents></uix:pageButtonBar>
          </uix:contentFooter>
  
          <uix:messageBox renderedBinding="messageRendered@commonSectionViewBean@servletRequest"
                          messageTypeBinding="messageType@commonSectionViewBean@servletRequest"
                          messageBinding="message@commonSectionViewBean@servletRequest">
            <uix:contents>
              <uix:link textBinding="messageLinkText@commonSectionViewBean@servletRequest"
                        destinationBinding="messageLinkDest@commonSectionViewBean@servletRequest"
                        longDescBinding="messageLongDesc@commonSectionViewBean@servletRequest"/>
            </uix:contents>
          </uix:messageBox>

          <uix:switcher childNameBinding="showStorageDetailsPage@commonSectionViewBean@servletRequest">
            <uix:case name="true">
              <uix:stackLayout>
                <uix:header textBinding="STORAGE_DETAILS@storageResource">
                  <uix:styledText styleClass="OraInstructionText"
                    textBinding="OVERHEAD_TEXT@storageResource"/>
                  <%
                    if(relatedErrorsCountAsInt > 0 )
                    {
                  %> 
                      <uix:styledText styleClass="OraInstructionText"
                        textBinding="RELATED_ERROR_INSTRUCTION_TEXT@storageResource"/>
                  <%}%>
                  <uix:tableLayout width="100%" >
                    <uix:rowLayout width="100%" hAlign="right" >
                      <uix:cellFormat width="50%" hAlign="right">
                        <uix:rowLayout hAlign="right" >
                          <uix:styledText styleClass="OraTipText" 
                            textBinding="LATEST_FROM_TARGET@sdkResource"/>
                          <uix:spacer width="5"/>
                          <uix:styledText styleClass="OraTipLabel" 
                            textBinding="collectionTimestamp@commonSectionViewBean@servletRequest"/>
                          <uix:spacer width="8"/>
                          <uix:submitButton name="event"
                             value="refreshHostStorage"
                             textBinding="REFRESH@commonResource" />
                        </uix:rowLayout>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
        
                  <uix:tableLayout width="100%" >
                    <uix:rowLayout hAlign="center" width="100%">
                    
                      <%-- Utilization Summary Chart --%>
                    
                      <oem:chart titleBinding="utilSummaryHeader@headers@commonSectionViewBean@servletRequest"
                        chartType="pieChart"
                        width="160"
                        height="190"
                        pieSlicesFromColumn="true"
                        showSlicePercentLabels="true"
                        legendVisible="true"
                        pieValuesInLegend="value"
                        hideZeroSlices="true"
                        shadowEffect="shadow"
                        legendPosition="south">
                        <uix:contents>
                          <oem:boundChartDataSource
                            chartDataSourceBinding="storageUtilizationPieChartData@commonSectionViewBean@servletRequest" />
          
                          <oem:imageMap imageMapItemsBinding="storageUtilizationPieChartImageMap@commonSectionViewBean@servletRequest" />
                          <oem:chartColumn
                            displayLabelBinding="used@storageUtilizationPieChartDisplayLabels@commonSectionViewBean@servletRequest"
                            itemColorBinding="used@storageUIColorMap@commonSectionViewBean@servletRequest"
                            sourceIndex="0"/>
                            
                          <oem:chartColumn
                            displayLabelBinding="free@storageUtilizationPieChartDisplayLabels@commonSectionViewBean@servletRequest"
                            itemColorBinding="free@storageUIColorMap@commonSectionViewBean@servletRequest"
                            sourceIndex="1" />
                          <oem:chartColumn
                            displayLabelBinding="unallocated@storageUtilizationPieChartDisplayLabels@commonSectionViewBean@servletRequest"
                            itemColorBinding="unallocated@storageUIColorMap@commonSectionViewBean@servletRequest"
                            sourceIndex="2" />
                          <oem:chartColumn
                            displayLabelBinding="overhead@storageUtilizationPieChartDisplayLabels@commonSectionViewBean@servletRequest"
                            itemColorBinding="overhead@storageUIColorMap@commonSectionViewBean@servletRequest"
                            sourceIndex="3" />
                        </uix:contents>
                      </oem:chart>
                    
                      <%-- Allocation Summary Chart --%>
                    
                      <oem:chart titleBinding="allocationSummaryHeader@headers@commonSectionViewBean@servletRequest"
                        chartType="barChart"
                        width="400"
                        barWidth="30"
                        height="190"
                        orientation="horizontal"
                        showSliceValueLabels="true"
                        stacked="true"
                        hideZeroSlices="true"
                        shadowEffect="3d"
                        legendPosition="south">
                        <uix:contents>
                          <oem:boundChartDataSource
                            chartDataSourceBinding="storageAllocationSummaryChartData@commonSectionViewBean@servletRequest" />
                          <oem:imageMap imageMapItemsBinding="storageAllocationBarImageMap@commonSectionViewBean@servletRequest" />
          
                          <oem:chartColumn
                            isKey="true"
                            sourceIndex="0" />
                          <oem:chartColumn
                            displayLabelBinding="allocated@storageAllocationSummaryDisplayLabels@commonSectionViewBean@servletRequest"
                            itemColorBinding="allocated@storageUIColorMap@commonSectionViewBean@servletRequest"
                            sourceIndex="1" />
                          <oem:chartColumn
                            displayLabelBinding="unallocated@storageAllocationSummaryDisplayLabels@commonSectionViewBean@servletRequest"
                            itemColorBinding="unallocated@storageUIColorMap@commonSectionViewBean@servletRequest"
                            sourceIndex="2" />
                          <oem:chartColumn
                            displayLabelBinding="overhead@storageAllocationSummaryDisplayLabels@commonSectionViewBean@servletRequest"
                            itemColorBinding="overhead@storageUIColorMap@commonSectionViewBean@servletRequest"
                            sourceIndex="3" />
                        </uix:contents>
                      </oem:chart>
          
                      <%-- Usage Summary Chart --%>
                      <oem:chart titleBinding="usageSummaryHeader@headers@commonSectionViewBean@servletRequest"
                        chartType="barChart"
                        width="350"
                        height="190"
                        orientation="horizontal"
                        stacked="true"
                        barWidth="30"
                        shadowEffect="3d"
                        legendPosition="south">
                        <uix:contents>
                          <oem:boundChartDataSource
                            chartDataSourceBinding="storageUsageSummaryChartData@commonSectionViewBean@servletRequest" />
          
                          <oem:imageMap imageMapItemsBinding="storageUsageBarImageMap@commonSectionViewBean@servletRequest" />
                          <oem:chartColumn
                            isKey="true"
                            sourceIndex="0" />
                          <oem:chartColumn
                            displayLabelBinding="used@storageUsageSummaryDisplayLabels@commonSectionViewBean@servletRequest"
                            itemColorBinding="used@storageUIColorMap@commonSectionViewBean@servletRequest"
                            sourceIndex="1" />
                          <oem:chartColumn
                            displayLabelBinding="free@storageUsageSummaryDisplayLabels@commonSectionViewBean@servletRequest"
                            itemColorBinding="free@storageUIColorMap@commonSectionViewBean@servletRequest"
                            sourceIndex="2" />
                        </uix:contents>
                      </oem:chart>
                    </uix:rowLayout hAlign="left">
        
                    <uix:tableLayout width="17%" >
                      <uix:rowLayout >
                        <uix:cellFormat hAlign="right">
                          <uix:styledText textBinding="RELATED_ERRORS@storageResource"
                            styleClass="OraPromptText" />
                        </uix:cellFormat>
                        <uix:spacer width="5"/>
                        <uix:cellFormat hAlign="right">
                          <uix:styledText textBinding="relatedErrorCount@commonSectionViewBean@servletRequest"
                                          shortDescBinding="RELATED_ERRORS@storageResource"
                                          destinationBinding="collectionErrorURL@commonSectionViewBean@servletRequest"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
                      <uix:spacer height="5"/>
                    </uix:tableLayout>
                    <uix:tableLayout width="17%" >
                      <uix:spacer height="5"/>
                    </uix:tableLayout>
                    <uix:subTabLayout>
                      <uix:subTabs>
                        <uix:subTabBar 
                          selectedIndexBinding="selectedTabIndex@commonSectionViewBean@servletRequest"> 
                          <uix:link textBinding="DISKS@storageResource"
                             destinationBinding="subTabUrl0@subTabUrls@commonSectionViewBean@servletRequest"/>
                          <uix:link textBinding="VOLUMES@storageResource"
                             destinationBinding="subTabUrl1@subTabUrls@commonSectionViewBean@servletRequest"/>
                          <uix:link textBinding="ASM@storageResource"
                             destinationBinding="subTabUrl2@subTabUrls@commonSectionViewBean@servletRequest"/>
                          <uix:link textBinding="FILE_SYSTEMS@storageResource"
                             destinationBinding="subTabUrl3@subTabUrls@commonSectionViewBean@servletRequest"/>
                          <uix:link textBinding="DATABASES@storageResource"
                             destinationBinding="subTabUrl4@subTabUrls@commonSectionViewBean@servletRequest"/>
                          <uix:link textBinding="VENDOR_DISTRIBUTION@storageResource"
                             destinationBinding="subTabUrl5@subTabUrls@commonSectionViewBean@servletRequest"/>
                        </uix:subTabBar>
                      </uix:subTabs>
                      <uix:contents>
                        <uix:spacer height="10"/>
                        <uix:stackLayout>
                          <uix:tableLayout cellSpacing="0" cellPadding="0" width="90%">
                          <uix:switcher childNameBinding="selectedTabIndex@commonSectionViewBean@servletRequest">
                            <uix:case name="0">
                              <%@ include file="hostDisksStorage.jspf" %>
                            </uix:case>
                            <uix:case name="1">
                              <%@ include file="hostVolumesStorage.jspf" %>
                            </uix:case>
                            <uix:case name="2">
                              <%@ include file="hostASMStorage.jspf" %>
                            </uix:case>
                            <uix:case name="3">
                              <%@ include file="hostFSStorage.jspf" %>
                            </uix:case>
                            <uix:case name="4">
                              <%@ include file="hostDBStorage.jspf" %>
                            </uix:case>
                            <uix:case name="5">
                              <%@ include file="../common/vendorDistStorage.jspf" %>
                            </uix:case>
                          </uix:switcher>
                          </uix:tableLayout>
          
                          <uix:spacer height="10"/>
                        </uix:stackLayout>
                      </uix:contents>
                    </uix:subTabLayout>
                  </uix:tableLayout>
                </uix:header>
                <uix:spacer height="5"/>
                <uix:header textBinding="RELATED_LINKS@storageResource">
                  <uix:link
                    textBinding="STORAGE_HISTORY@storageResource"
                    destinationBinding="historyRelatedLinkURL@commonSectionViewBean@servletRequest">
                  </uix:link>
                </uix:header>
              </uix:stackLayout>
            </uix:case>
          </uix:switcher>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

