<%--
 * Copyright (c) 2004, 2005, Oracle. All rights reserved.  
 *
 *  NAME
 *    hostStorageHistory.jsp
 *
 *  DESCRIPTION
 *    Has the UI contents of the host storage history details.
 *
 *  NOTES
 *
 *    We need to use jsp:include and buildTree to include the 
 *    pages - I tried to implement this on june 17th but it did not
 *    work for me for some reason (gave blank page.)
 * MODIFIED
 *    ajere    07/19/05 - Fix bug# 4493757 
 *    ajere    07/14/05 - Fix bug# 4429794 
 *    ajere    05/24/05 - Accessibility changes 
 *    rmenon   03/23/05 - 
 *    rmenon   02/16/05 - 
 *    rmenon   02/14/05 - 
 *    rmenon   12/09/04 - 
 *    rmenon   11/15/04 - 
 *    rmenon   11/11/04 - put collection timestamp back.
 *    rmenon   10/15/04 - aligning the "view" period choice to right.
 *    rmenon   10/09/04 - history code consolidation
 *    djoly    10/04/04 - Fix relative paths for includes in same directory 
 *    rmenon   08/10/04 - 
 *    rmenon   08/02/04 - converted tab to drop down
 *    rmenon   06/28/04 - rmenon_storage_disks_tab_ui
 *    rmenon   06/10/04 - Created
--%>

<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.cabo.ui.UIConstants' %>
<%@ page import='java.text.SimpleDateFormat' %>
<%@ page import='oracle.sysman.emSDK.svc.cache.CacheManager' %>
<%@ page import='oracle.sysman.emSDK.svc.ServiceUtil' %>
<%@ page import='oracle.sysman.eml.ecm.ui.SimpleDataObjectList' %>
<%@ page import='oracle.sysman.eml.storage.common.StorageUIConstants' %>
<%@ page import='oracle.sysman.eml.storage.common.StorageHistorySummaryViewBean' %>
<%@ page import='oracle.sysman.eml.storage.common.StorageHistoryMgmtLayerViewBean' %>
<%@ page import='oracle.sysman.eml.storage.common.StorageHistoryDisksViewBean' %>
<%@ page import='oracle.sysman.eml.storage.common.StorageHistoryApplicationsViewBean' %>
<%@ page import='oracle.sysman.eml.storage.common.StorageHistoryViewBean' %>

<%@ page import="oracle.cabo.ui.partial.PartialPageContext"%>
<%@ page import="oracle.cabo.ui.partial.PartialPageUtils"%>
<%@ page import="oracle.cabo.servlet.ui.partial.PartialPageEventUtils"%>


<%@ include file="/sdk/oemTop.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <%--
   * resource bundles used by this page.
  --%>
<%
  StorageHistoryViewBean historyViewBean = 
    (StorageHistoryViewBean)
    request.getAttribute( "historyViewBean" );
  String selectedHistoryType = historyViewBean.getSelectedHistoryType();
%>
  <uix:bundle name="storageResource"
    class="oracle.sysman.eml.storage.resources.StorageResourceBundle"/>
  <uix:bundle name="sdkResource"
    class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="commonResource"
    class="oracle.sysman.resources.CommonResourceBundle"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="pageTitle@historyViewBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body onLoadBinding="focusJavaScript@historyViewBean@servletRequest">

      <uix:pageLayout titleBinding="HISTORY@storageResource">
        <%@ include file="/oemGlobal.jspf" %>

        <uix:rawText textBinding="debugMessage@servletRequest"/>
        <uix:rawText textBinding="errorMessage@servletRequest"/>

        <uix:form name="hostStorageHistoryForm" method="GET">
          <uix:tableLayout>
            <uix:stackLayout>
              <uix:spacer height="10"/>
              <uix:tableLayout width="100%" >
                <uix:rowLayout width="100%" hAlign="right" >
                  <uix:cellFormat width="50%" hAlign="right">
                    <uix:rowLayout hAlign="right" >
                      <uix:styledText styleClass="OraTipText" 
                        textBinding="LATEST_FROM_TARGET@sdkResource"/>
                      <uix:spacer width="5"/>
                    <%
                      if ( StorageUIConstants.SUMMARY.equals( selectedHistoryType ) )
                      {
                    %>
                      <uix:styledText styleClass="OraTipLabel" 
                        textBinding="collectionTimestamp@historySummaryViewBean@servletRequest"/>
                    <%
                      }
                      else if ( StorageUIConstants.DB.equals( selectedHistoryType ) )
                      {
                    %>
                      <uix:styledText styleClass="OraTipLabel" 
                        textBinding="collectionTimestamp@historyApplicationsViewBean@servletRequest"/>
                    <%}
                      else if ( StorageUIConstants.LOCAL_FS.equals( selectedHistoryType ) )
                      {
                    %>
                      <uix:styledText styleClass="OraTipLabel" 
                        textBinding="collectionTimestamp@historyApplicationsViewBean@servletRequest"/>
                    <%}
                      else if ( StorageUIConstants.WRITEABLE_NFS.equals( selectedHistoryType ) )
                      {
                    %>
                      <uix:styledText styleClass="OraTipLabel" 
                        textBinding="collectionTimestamp@historyApplicationsViewBean@servletRequest"/>
                    <%}
                      else if ( StorageUIConstants.DISKS.equals( selectedHistoryType ) )
                      {
                    %>
                      <uix:styledText styleClass="OraTipLabel" 
                        textBinding="collectionTimestamp@historyDisksViewBean@servletRequest"/>
                    <%}
                      else if ( StorageUIConstants.ASM.equals( selectedHistoryType ) )
                      {
                    %>
                      <uix:styledText styleClass="OraTipLabel" 
                        textBinding="collectionTimestamp@historyMgmtLayerViewBean@servletRequest"/>
                    <%}
                      else if ( StorageUIConstants.VOLUMES.equals( selectedHistoryType ) )
                      {
                    %>
                      <uix:styledText styleClass="OraTipLabel" 
                        textBinding="collectionTimestamp@historyMgmtLayerViewBean@servletRequest"/>
                    <%}%>
                    </uix:rowLayout>
                  </uix:cellFormat>
                  <uix:cellFormat width="15%" hAlign="right" >
                    <uix:styledText textBinding="VIEW@storageResource"
                                    styleClass="OraPromptText"
                                    labeledNodeId="viewPeriodChoice"/>
                    <uix:choice name="viewPeriodChoice"
                                id="viewPeriodChoice"
                                onChange="submitForm('hostStorageHistoryForm', true, {'event':'viewHistoryByResource'})"
                                selectedValueBinding="selectedPeriod@historyViewBean@servletRequest" >
                      <uix:contents childDataBinding="periodSelector@historyViewBean@servletRequest">
                        <uix:option textBinding="text"
                                    valueBinding="value"
                                    renderedBinding="rendered"/>
                      </uix:contents>
                     </uix:choice>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
              <uix:tableLayout cellPadding="0" width="90%">
                <uix:rowLayout>
                  <uix:cellFormat width="40%" hAlign="left" >
                    <uix:styledText textBinding="HISTORY_OF@storageResource"
                                    styleClass="OraPromptText"
                                    labeledNodeId="viewStorageChoice"/>
                    <uix:choice name="viewStorageChoice"
                                id="viewStorageChoice"
                                onChange="submitForm('hostStorageHistoryForm', true, {'event':'viewHistoryOf'})"
                                selectedValueBinding="selectedHistoryTypeText@historyViewBean@servletRequest" >
                      <uix:contents childDataBinding="historyTypeSelector@historyViewBean@servletRequest">
                        <uix:option textBinding="text"
                          renderedBinding="rendered"/>
                      </uix:contents>
                     </uix:choice>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
              <%
                if ( StorageUIConstants.SUMMARY.equals( selectedHistoryType ) )
                {
              %>
                  <%@ include file="hostStorageHistorySummary.jspf" %>
              <%
                }
                else if ( StorageUIConstants.DB.equals( selectedHistoryType ) )
                {
              %>
                  <%@ include file="hostStorageHistoryDatabases.jspf" %>
              <%}
                else if ( StorageUIConstants.LOCAL_FS.equals( selectedHistoryType ) )
                {
              %>
                  <%@ include file="hostStorageHistoryLocalFS.jspf" %>
              <%}
                else if ( StorageUIConstants.WRITEABLE_NFS.equals( selectedHistoryType ) )
                {
              %>
                  <%@ include file="hostStorageHistoryNFS.jspf" %>
              <%}
                else if ( StorageUIConstants.DISKS.equals( selectedHistoryType ) )
                {
              %>
                  <%@ include file="hostStorageHistoryDisks.jspf" %>
              <%}
                else if ( StorageUIConstants.ASM.equals( selectedHistoryType ) )
                {
              %>
                  <%@ include file="hostStorageHistoryAsm.jspf" %>
              <%}
                else if ( StorageUIConstants.VOLUMES.equals( selectedHistoryType ) )
                {
              %>
                  <%@ include file="hostStorageHistoryVolumes.jspf" %>
              <%}
                else
                {
              %>
                  <uix:spacer height="10"/>
                  <uix:styledText styleClass="OraDataText"
                    text="Not implemented yet"/>
              <%}%>
              <uix:spacer height="10"/>
            </uix:stackLayout>
          </uix:tableLayout>
        </uix:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

