<%--
 * Copyright (c) 2004, 2005, Oracle. All rights reserved.  
 *
 *  NAME
 *    hostsSharingResource.jsp
 *
 *  NOTES
 *    Page for showing hosts that share a resource (disk/psrtition etc.)
 *
 * MODIFIED
 *    ajere    05/24/05 - Accessibility changes 
 *    rmenon   02/14/05 - 
 *    rmenon   12/02/04 - 
 *    rmenon   10/22/04 - changing target names to target name home page links
 *    rmenon   10/05/04 - 
 *    rmenon   08/24/04 - rmenon_storage_ui
 *    rmenon   08/18/04 - Created
--%>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.sysman.emSDK.svc.cache.CacheManager' %>
<%@ page import='oracle.sysman.emSDK.svc.ServiceUtil' %>
<%@ page import='oracle.sysman.eml.ecm.ui.SimpleDataObjectList' %>
<%@ page import='oracle.sysman.eml.storage.common.StorageUIConstants' %>

<%@ page import="oracle.cabo.ui.partial.PartialPageContext"%>
<%@ page import="oracle.cabo.ui.partial.PartialPageUtils"%>
<%@ page import="oracle.cabo.servlet.ui.partial.PartialPageEventUtils"%>

<%
  String selectedTabIndex = request.getParameter(
      StorageUIConstants.SELECTED_TAB_INDEX_KEY );
  if( selectedTabIndex == null)
     selectedTabIndex = "0";
  int selTab = Integer.parseInt( selectedTabIndex );
%>

<%@ include file="/sdk/oemTop.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <%--
   * resource bundles used by this page.
  --%>
  <uix:bundle name="storageResource"
    class="oracle.sysman.eml.storage.resources.StorageResourceBundle"/>
  <uix:bundle name="sdkResource"
    class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="commonResource"
    class="oracle.sysman.resources.CommonResourceBundle"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="pageTitle@hostsSharingResourceViewBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>

      <uix:pageLayout titleBinding="pageHeader@hostsSharingResourceViewBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>

        <uix:rawText textBinding="debugMessage@servletRequest"/>
        <uix:rawText textBinding="errorMessage@servletRequest"/>

        <uix:form name="hostsSharingResourceForm" method="GET">
          <uix:styledText styleClass="OraInstructionText"
            textBinding="HOSTS_CONFIGURED_TO_ACCESS_RESOURCE_TEXT@storageResource"/>
          <uix:tableLayout width="100%" >
            <uix:rowLayout width="100%">
              <uix:cellFormat width="50%" hAlign="right">
                <uix:rowLayout hAlign="right" >
                  <uix:styledText styleClass="OraTipText" 
                    textBinding="LATEST_FROM_TARGET@sdkResource"/>
                  <uix:spacer width="5"/>
                  <uix:styledText styleClass="OraTipLabel" 
                    textBinding="collectionTimestamp@hostsSharingResourceViewBean@servletRequest"/>
                  <uix:spacer width="5"/>
                </uix:rowLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
          <uix:tableLayout cellPadding="0" width="90%">
             <uix:rowLayout>
               <uix:spacer width="5"/>
               <uix:cellFormat hAlign="left" >
                 <uix:labeledFieldLayout fieldWidth="0" labelWidth="0" width="0">
                   <uix:styledText textBinding="RESOURCE_TYPE_HEADER@storageResource"
                                   styleClass="OraPromptText" />
                   <uix:styledText textBinding="resourceType@hostsSharingResourceViewBean@servletRequest"
                                   styleClass="OraDataText" />
                   <%
                      if( selTab == 
                         StorageUIConstants.HOST_DISKS_SELECTED_TAB_INDEX )
                      {
                   %>
                        <uix:styledText textBinding="DEVICE_TYPE_HEADER@storageResource"
                          styleClass="OraPromptText" />
                        <uix:styledText textBinding="deviceType@hostsSharingResourceViewBean@servletRequest"
                                   styleClass="OraDataText" />
                        <uix:styledText textBinding="VENDOR_HEADER@storageResource"
                                   styleClass="OraPromptText" />
                        <uix:styledText textBinding="vendor@hostsSharingResourceViewBean@servletRequest"
                                   styleClass="OraDataText" />
                    <%} 
                      else if( selTab == 
                         StorageUIConstants.HOST_FILE_SYSTEMS_SELECTED_TAB_INDEX )
                      {
                      %>
                        <uix:styledText textBinding="MOUNT_POINT@storageResource"
                          styleClass="OraPromptText" />
                        <uix:styledText textBinding="mountPoint@hostsSharingResourceViewBean@servletRequest"
                                   styleClass="OraDataText" />
                    <%}
                      else if( selTab == 
                         StorageUIConstants.HOST_VOLUMES_SELECTED_TAB_INDEX )
                      {
                      %>
                        <uix:styledText textBinding="VENDOR_HEADER@storageResource"
                          styleClass="OraPromptText" />
                        <uix:styledText textBinding="vendor@hostsSharingResourceViewBean@servletRequest"
                                   styleClass="OraDataText" />
                        <uix:styledText textBinding="PRODUCT@storageResource"
                          styleClass="OraPromptText" />
                        <uix:styledText textBinding="product@hostsSharingResourceViewBean@servletRequest"
                                   styleClass="OraDataText" />
                        <uix:styledText textBinding="DISK_GROUP@storageResource"
                          styleClass="OraPromptText" />
                        <uix:styledText textBinding="diskGroup@hostsSharingResourceViewBean@servletRequest"
                                   styleClass="OraDataText" />
                        <uix:styledText textBinding="OS_PATH@storageResource"
                          styleClass="OraPromptText" />
                        <uix:styledText textBinding="osPath@hostsSharingResourceViewBean@servletRequest"
                                   styleClass="OraDataText" />
                    <%}%>
                 </uix:labeledFieldLayout >
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
          <uix:spacer height="10"/>
          <uix:tableLayout cellPadding="0" width="50%">
            <uix:rowLayout>
              <uix:spacer width="5"/>
               <uix:cellFormat hAlign="left" >
                 <uix:table name="hostsSharingResourceTable"
                   id="hostsSharingResourceTableID"
                   tableDataBinding="rows@hostsSharingResourceTable@servletRequest"
                   columnHeaderDataBinding=
                     "hostsSharingResourceTableColumnHeaders@servletRequest"
                   blockSizeBinding="size@rows@hostsSharingResourceTable@servletRequest"
                   maxValueBinding="max@rows@hostsSharingResourceTable@servletRequest"
                   valueBinding="start@rows@hostsSharingResourceTable@servletRequest"
                   minValue="1"
                   width="80%"
                   alternateTextBinding= "NO_ITEMS_FOUND@sdkResource"
                   formSubmitted="true"
                   showAll="yes" >
                 
                   <uix:tableFormat tableBanding="rowBanding"/>
                 
                   <uix:columnHeaderStamp>
                     <uix:sortableHeader textBinding="text" 
                       sortableBinding="sortable"
                      />
           
                   </uix:columnHeaderStamp>
                   <uix:contents>
                     <uix:link textBinding="target_name"
                       destinationBinding="homePageURL" />
                   </uix:contents>
           
                 </uix:table>
               </uix:cellFormat>
             </uix:rowLayout>
           </uix:tableLayout>
        </uix:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

