<%--
 * Copyright (c) 2004, 2005, Oracle. All rights reserved.  
 *
 *  NAME
 *    storageErrors.jsp
 *
 *  NOTES
 *    shows collection errors and storage mapping issues.
 *  
 * MODIFIED
 *    ajere    05/24/05 - Accessibility changes 
 *    rmenon   12/01/04 - 
 *    rmenon   10/21/04 - removed "dummy" message
 *    rmenon   09/20/04 - 
 *    rmenon   09/08/04 - 
 *    rmenon   08/02/04 - rmenon_storage_refresh_error_page_checkin
 *    rmenon   08/02/04 - Creation
--%>

<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.cabo.ui.UIConstants' %>
<%@ page import='oracle.sysman.emSDK.svc.ServiceUtil' %>
<%@ page import='oracle.sysman.eml.storage.common.StorageUIConstants' %>
<%@ page import='oracle.sysman.eml.ecm.ui.SimpleDataObjectList' %>
<%@ page import='oracle.sysman.eml.storage.common.StorageUIConstants' %>

<%@ include file="/sdk/oemTop.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResource"
    class="oracle.sysman.resources.CommonResourceBundle"/>

  <%--
   * resource bundles used by this page.
  --%>

  <uix:bundle name="storageResource"
    class="oracle.sysman.eml.storage.resources.StorageResourceBundle"/>

  <uix:bundle name="sdkResource"
    class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="pageTitle@errorPageViewBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>

      <uix:pageLayout titleBinding="RELATED_ERRORS@storageResource">
        <%@ include file="/oemGlobal.jspf" %>

        <uix:rawText textBinding="debugMessage@servletRequest"/>
        <uix:rawText textBinding="errorMessage@servletRequest"/>

        <uix:form name="hostStorageErrorPageForm" method="GET">
          <uix:tableLayout width="100%" >
            <uix:rowLayout width="90%" hAlign="right" >
              <uix:cellFormat width="50%" hAlign="right">
                <uix:rowLayout hAlign="right" >
                  <uix:styledText styleClass="OraTipText" 
                    textBinding="COLL_FROM_TARGET@sdkResource"/>
                  <uix:spacer width="5"/>
                  <uix:styledText styleClass="OraTipLabel" 
                    textBinding="collectionTimestamp@errorPageViewBean@servletRequest"/>
                  <uix:spacer width="8"/>
                    <uix:submitButton name="event"
                       value="refreshHostStorage"
                       textBinding="REFRESH@commonResource"
                      destinationBinding="refreshSnapshotURL@commonSectionViewBean@servletRequest"/>
                </uix:rowLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
          <uix:header textBinding="METRIC_COLLECTION_ERROR_HEADER@storageResource">
            <uix:tableLayout cellPadding="0" width="90%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="center" >
                  <uix:table name="storageMetricCollectionErrorsTable"
                    id="storageMetricCollectionErrorsTableID"
                    tableDataBinding="rows@storageMetricCollectionErrorsTable@servletRequest"
                    columnHeaderDataBinding="storageMetricCollectionErrorsTableColumnHeaders@servletRequest"
                    blockSizeBinding="size@rows@storageMetricCollectionErrorsTable@servletRequest"
                    maxValueBinding="max@rows@storageMetricCollectionErrorsTable@servletRequest"
                    valueBinding="start@rows@storageMetricCollectionErrorsTable@servletRequest"
                    minValue="1"
                    width="100%"
                    alternateTextBinding= "NO_ITEMS_FOUND@sdkResource"
                    formSubmitted="true"
                    showAll="yes"
                    summaryBinding="METRIC_COLLECTION_ERROR_HEADER@storageResource">
                  
                    <uix:tableFormat tableBanding="rowBanding"/>
                  
                    <uix:columnHeaderStamp>
                      <uix:sortableHeader textBinding="text" 
                        sortableBinding="sortable"
                       />
            
                    </uix:columnHeaderStamp>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="textFormat"  />
                      <uix:styledText textBinding="target_name"/>
                    </uix:column>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="textFormat"  />
                      <uix:styledText textBinding="target_type"/>
                    </uix:column>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="textFormat"  />
                      <uix:styledText textBinding="metric_name"/>
                    </uix:column>
                    <uix:column>
                      <uix:columnFormat columnDataFormat="textFormat"
                                        cellNoWrapFormat="true"/>
                      <uix:styledText textBinding="collection_timestamp"/>
                    </uix:column>
                    <uix:contents>
                      <uix:styledText textBinding="metric_collection_error_msg"/>
                    </uix:contents>
                  </uix:table>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>
          <uix:header textBinding="STORAGE_MAPPING_ISSUES_HEADER@storageResource">
            <uix:tableLayout cellPadding="0" width="90%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="center" >
                  <uix:table name="storageMappingIssuesTable"
                    id="storageMappingIssuesTableID"
                    tableDataBinding="rows@storageMappingIssuesTable@servletRequest"
                    columnHeaderDataBinding="storageMappingIssuesTableColumnHeaders@servletRequest"
                    blockSizeBinding="size@rows@storageMappingIssuesTable@servletRequest"
                    maxValueBinding="max@rows@storageMappingIssuesTable@servletRequest"
                    valueBinding="start@rows@storageMappingIssuesTable@servletRequest"
                    minValue="1"
                    width="100%"
                    alternateTextBinding= "NO_ITEMS_FOUND@sdkResource"
                    formSubmitted="true"
                    showAll="yes"
                    summaryBinding="STORAGE_MAPPING_ISSUES_HEADER@storageResource">
                  
                    <uix:tableFormat tableBanding="rowBanding"/>
                  
                    <uix:columnHeaderStamp>
                      <uix:sortableHeader textBinding="text" 
                        sortableBinding="sortable"
                       />
            
                    </uix:columnHeaderStamp>
                    <uix:contents>
                      <uix:styledText textBinding="storageMappingMessage"/>
                      <uix:styledText textBinding="storageMappingAction"/>
                      <uix:styledText textBinding="collection_timestamp"/>
                    </uix:contents>
                  </uix:table>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>
        </uix:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

