<%--
 * Copyright (c) 2003, 2006, Oracle. All rights reserved.  
 *
 *      NAME
 *
 *      NOTES
 *
 * MODIFIED
 *    hmodawel   03/06/06 - fix compilation error 
 *    vagarwal   10/15/04 - vagarwal_groups_charts_1006
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<%@ page import="oracle.sysman.eml.mntr.Constants"%>

<oem:pageSegment>
    <uix:dataScope>
        <uix:bundle name="groupBundle"
            class="oracle.sysman.eml.rsc.target.grps.GroupMsg"/>
        <uix:bundle name="commonResourceBundle"
            class="oracle.sysman.resources.CommonResourceBundle"/>
        <uix:bundle name="mntrResourceBundle"
            class="oracle.sysman.resources.MntrResourceBundle"/>
        <uix:renderingContext id="renderingContext">
            <oem:setURLEncoder id="renderingContext"/>
            <uix:header text="Add Chart">
                <uix:tableLayout>
                        <uix:rowLayout width="100%">
                            <uix:labeledFieldLayout 
                                labelWidth="20%"
                                fieldWidth="80%"
                                width="100%" >
                                <%-- Label --%>
                                <uix:messagePrompt 
                                    promptBinding="TARGET_TYPE@sdkBundle" />

                                <%-- Field --%>
                                <uix:choice
                                    name="targetType"
                                    onChangeBinding="targetTypeChangedEvent@"
                                    selectedValueBinding="selectedTargetType@" 
                                    disabledBinding="readOnlyMode@"
                                >
                                    <uix:contents 
                                        childDataBinding="targetTypes@">
                                        <uix:option 
                                            textBinding="text" 
                                            valueBinding="value"
                                    />
                                    </uix:contents>
                                </uix:choice>

                                <%-- Label --%>
                                    <uix:messagePrompt 
                                        promptBinding="METRIC@sdkBundle" />

                                <%-- Field --%>
                                <uix:choice
                                    name="metricName"
                                    selectedValueBinding="selectedMetricName@" 
                                    disabledBinding="readOnlyMode@"
                                >
                                    <uix:contents 
                                        childDataBinding="metricNames@">
                                        <uix:option 
                                            textBinding="text" 
                                            valueBinding="value"
                                    />
                                    </uix:contents>
                                </uix:choice>
                            </uix:labeledFieldLayout>
                        </uix:rowLayout>
                        <uix:header text="Select Chart Type">
                            <uix:tableLayout width="100%">
                              <uix:rowLayout>
                                  <uix:radioButton 
                                     name="chartChoice"
                                     value="peakTargets"
                                     selectedValueBinding="selectedChartType@"/>
                                  <uix:rowLayout hAlign="left">
                                    <uix:styledText 
                                      textBinding=
                                          "PEAK_TARGETS@mntrResourceBundle"
                                          styleClass="OraTipText"/>
                                    <uix:spacer width="10"/>
                                    <uix:choice 
                                      name="numPeakTargets"
                                      selectedValueBinding="numPeakTargets@"
                                      disabledBinding="readOnlyMode@">
                                      <uix:contents 
                                        childDataBinding="numTargetsList@">
                                        <uix:option 
                                          textBinding="text" 
                                          valueBinding="value"/>
                                      </uix:contents>
                                    </uix:choice>
                                  </uix:rowLayout>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                  <uix:radioButton 
                                     name="chartChoice"
                                     value="highestAvgTargets"
                                     selectedValueBinding="selectedChartType@"/>
                                  <uix:rowLayout hAlign="left">
                                    <uix:styledText 
                                      textBinding=
                                        "TARGETS_HIGHEST_AVG@mntrResourceBundle"
                                        styleClass="OraTipText"/>
                                    <uix:spacer width="10"/>
                                    <uix:choice 
                                      name="numHighestAvgTargets"
                                      selectedValueBinding="numHighestAvgTargets@"
                                      disabledBinding="readOnlyMode@">
                                      <uix:contents 
                                        childDataBinding="numTargetsList@">
                                        <uix:option 
                                          textBinding="text" 
                                          valueBinding="value"/>
                                      </uix:contents>
                                    </uix:choice>
                                  </uix:rowLayout>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                  <uix:radioButton 
                                     name="chartChoice"
                                     value="lowestAvgTargets"
                                     selectedValueBinding="selectedChartType@"/>
                                  <uix:rowLayout hAlign="left">
                                    <uix:styledText 
                                      textBinding=
                                        "TARGETS_LOWEST_AVG@mntrResourceBundle"
                                        styleClass="OraTipText"/>
                                    <uix:spacer width="10"/>
                                    <uix:choice 
                                      name="numLowestAvgTargets"
                                      selectedValueBinding="numLowestAvgTargets@"
                                      disabledBinding="readOnlyMode@">
                                      <uix:contents 
                                        childDataBinding="numTargetsList@">
                                        <uix:option 
                                          textBinding="text" 
                                          valueBinding="value"/>
                                      </uix:contents>
                                    </uix:choice>
                                  </uix:rowLayout>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                  <uix:radioButton 
                                     name="chartChoice"
                                     value="summaryMetrics"
                                     selectedValueBinding="selectedChartType@"/>
                                  <uix:rowLayout hAlign="left">
                                    <uix:styledText 
                                      textBinding=
                                        "SUMMARY_METRICS@sdkBundle"
                                        styleClass="OraTipText"/>
                                  </uix:rowLayout>
                               </uix:rowLayout>
                               <uix:rowLayout hAlign="left">
                                    <uix:spacer width="1"/>
                                    <uix:rowLayout>
                                      <uix:contents 
                                        childDataBinding="summaryMetricList@">
                                      <uix:checkBox
                                        nameBinding="name"
                                        textBinding="text"
                                        checkedBinding="checked"
                                        disabledBinding="readOnlyMode@pageSegmentContext@servletRequest"
                                      />
                                      </uix:contents>
                                   </uix:rowLayout>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:radioButton 
                                    name="chartChoice"
                                    value="selectedTargets"
                                    selectedBinding="selectedChartType@" />
                                <uix:styledText 
                                  textBinding="SELECTED_TARGETS@mntrResourceBundle"
                                  styleClass="OraTipText"/>
                              </uix:rowLayout>
                              <uix:rowLayout width="100%">
                                <uix:spacer width="10"/>
                                <%-- todo: targets table goes here --%>
                              </uix:rowLayout>
                          </uix:tableLayout>
                        </uix:header>
                    </uix:tableLayout>
            </uix:header> 
        </uix:renderingContext>
    </uix:dataScope>
</oem:pageSegment>
