<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *
 *      NOTES
 *
 * MODIFIED
 *    dtsao      08/04/05 - Add showall 
 *    pratagar   05/30/05 - Ada voilations 
 *    dtsao      02/28/05 - Change alternate text 
 *    dtsao      02/08/05 - Change instruction text 
 *    dtsao      01/13/05 - Add instruction text 
 *    dtsao      01/05/05 - Use tableAction tag 
 *    dtsao      12/20/04 - Fix UI issue 
 *    yaofeng    11/15/04 - rename event name 
 *    vagarwal   10/20/04 - 
 *    vagarwal   10/15/04 - vagarwal_groups_charts_1006
 *    vagarwal   10/13/04 - 
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<%@ page import="oracle.sysman.eml.mntr.Constants"%>

<oem:pageSegment>
<uix:dataScope>
  <uix:bundle name="groupBundle"
              class="oracle.sysman.eml.rsc.target.grps.GroupMsg"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="groupsMsg"
              class="oracle.sysman.eml.rsc.target.grps.GroupsMsg"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
    <uix:stackLayout>
        <uix:spacer height="10" />
        <uix:styledText styleClass="OraInstructionText"
                        textBinding="instructionText"
                        />
        <uix:spacer height="10" />
        <uix:rowLayout>
            <uix:spacer width="20" />
        </uix:rowLayout>
        <uix:rowLayout width="100%">>
            <uix:table name="groupChartsTable" 
                id="groupChartsTable" 
                summaryBinding="CHART_TABLE_SUMMARY@groupsMsg"
                alternateTextBinding="alterText" 
                width="80%" 
                formSubmitted="true" 
                blockSize="25" 
                valueBinding="tableValue@" 
                minValueBinding="minValue@" 
                maxValueBinding="maxValue@" 
                tableDataBinding="tableDataKey@tableData@" 
                columnFormatsBinding="tableColumnFormats@" 
                columnHeaderDataBinding="tableColumnHeaders@"
                showAll="yes">
                
                <uix:tableActions>
                  <uix:rowLayout>
                    <uix:submitButton 
                      textBinding="ADD@commonResourceBundle" 
                      shortDescBinding="ADD@commonResourceBundle" 
                      name="event" 
                      value="addChart"/>
                    <uix:spacer width="2"/>
                    <uix:submitButton 
                      textBinding="REORDER@commonResourceBundle" 
                      shortDescBinding="REORDER@commonResourceBundle"
                      name="event" 
                      value="reorderChart"
                      renderedBinding="chartListNotEmpty@"/>
                  </uix:rowLayout>
                </uix:tableActions>                
                <uix:tableFormat tableBanding="rowBanding"/>
                <uix:columnHeaderStamp>
                    <uix:styledText textBinding="text" />
                </uix:columnHeaderStamp>
                <uix:tableSelection>
                    <uix:singleSelection selectedIndex="0" shortDescBinding="SELECT@commonResourceBundle">
                        <uix:submitButton 
                            textBinding="EDIT@commonResourceBundle" 
                            shortDescBinding="EDIT@commonResourceBundle" 
                            name="event" 
                            value="editChart"/>
                        <uix:spacer width="2"/>
                        <uix:submitButton 
                            textBinding="REMOVE@commonResourceBundle" 
                            shortDescBinding="REMOVE@commonResourceBundle" 
                            name="event" 
                            value="removeChart"/>
                    </uix:singleSelection>
                </uix:tableSelection>
                <uix:contents>
                    <uix:styledText textBinding="metricName"/>
                    <uix:styledText textBinding="chartType"/>
                </uix:contents>
            </uix:table>
        </uix:rowLayout>
        <uix:rowLayout>
            <uix:spacer width="20" />
        </uix:rowLayout>
    </uix:stackLayout>
</uix:renderingContext>
</uix:dataScope>
</oem:pageSegment>
