<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="groupBundle"
      class="oracle.sysman.eml.rsc.target.grps.GroupsMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <uix:form name="ROForm" method="POST">
        <uix:pageLayout titleBinding="header@viewBean@servletRequest">
          <%@ include file="/oemGlobal.jspf" %>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:switcher childNameBinding="nodeValue@viewBean@servletRequest">
                    <uix:case name="okNode">
                      <uix:cellFormat>
                        <uix:submitButton name="event"
                                        textBinding="CANCEL@commonResourceBundle"
                                        value="cancel"
                                        shortDescBinding="CANCEL@commonResourceBundle"/>
                        <uix:spacer width="4"/>
                        <uix:submitButton name="event"
                                        textBinding="CONTINUE@sdkUIMsg"
                                        value="Continue"
                                        shortDescBinding="CONTINUE@sdkUIMsg"  />
                      </uix:cellFormat>
                    </uix:case>
                    <uix:case name="errNode">
                      <uix:submitButton name="event"
                                        textBinding="CONTINUE@sdkUIMsg"
                                        value="Error"
                                        shortDescBinding="CONTINUE@sdkUIMsg"/>
                    </uix:case>
                  </uix:switcher>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:contents>
            <uix:switcher childNameBinding="nodeValue@viewBean@servletRequest">
              <uix:case name="okNode">
                <uix:stackLayout>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="REORDER_CHART_INSTRUCTION_TEXT@groupBundle"
                  />
                  <uix:spacer height="10" />
                  <uix:shuttle name="shuttle"
                               size="5">
                    <uix:leading>
                      <uix:list shortDescBinding="REORDER_CHART_INSTRUCTION_TEXT@groupBundle" >
                        <uix:contents childDataBinding="keyValueList@viewBean@servletRequest">
                          <uix:option textBinding="text"
                                      valueBinding="value"/>
                        </uix:contents>
                      </uix:list>
                    </uix:leading>
                  </uix:shuttle>
                </uix:stackLayout>
              </uix:case>

              <uix:case name="errNode">
                <uix:messageBox messageBinding="errorMessage@viewBean@servletRequest"
                                messageType="error"
                                shortDescBinding="ERR_OCCUR@mntrResourceBundle"
                                textBinding="ERR_OCCUR@mntrResourceBundle">
                </uix:messageBox>
              </uix:case>
            </uix:switcher>
          </uix:contents>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
