<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle"
      class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="groupBundle"
      class="oracle.sysman.eml.rsc.target.grps.GroupsMsg"/>
  <uix:bundle name="sdkBundle"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="mntrResourceBundle"
      class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="sdkBundle"
      class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:document>
      <%@ include file="/oemTitle.jspf" %>
      <%@ include file="/enablePPR.jspf" %>
      <uix:body>
          <uix:form name="manageChartForm" method="POST">
        <uix:pageLayout titleBinding="manageChartHeader@servletRequest">
          <%@ include file="/oemGlobal.jspf" %>
            <uix:messages>
              <uix:stackLayout>
                <uix:switcher 
                    childNameBinding="nodeValue@errData@servletRequest">
                  <uix:case name="errNode">
                    <uix:messageBox messageType="error"
                      messageBinding="errorMessage@errData@servletRequest"/>
                  </uix:case>
                  <uix:case name="infoNode">
                    <uix:messageBox messageType="info"
                      messageBinding="infoMessage@errData@servletRequest"/>
                  </uix:case>
                </uix:switcher>
              </uix:stackLayout>
            </uix:messages>
            <uix:pageButtons>
              <uix:pageButtonBar>
                  <uix:tableLayout id = "pageButtons">
                    <uix:rowLayout>
    <% if ( ! Boolean.TRUE.equals(request.getAttribute("metricListEmpty"))
            && ! Boolean.TRUE.equals(request.getAttribute("noTargetTypes")))
       {
    %>
                      <uix:submitButton name="event"
                                        textBinding="CANCEL@commonResourceBundle"
                                        shortDescBinding="CANCEL@commonResourceBundle"
                                        value="cancel"/>
                      <uix:spacer width="4"/>
                      <uix:submitButton name="event"
                                        textBinding="CONTINUE@sdkBundle"
                                        shortDescBinding="CONTINUE@sdkBundle"
                                        value="Continue"/>
     <%
        }
     %>
                    </uix:rowLayout>
                  </uix:tableLayout>
              </uix:pageButtonBar>
            </uix:pageButtons>
            <uix:styledText styleClass="OraInstructionText"
            textBinding="instructionText@servletRequest" />
            <uix:spacer height="10" />
            <uix:tableLayout id = "selectMetric">
            <uix:rowLayout>
    <% if ( ! Boolean.TRUE.equals(request.getAttribute("noTargetTypes")))
       {
    %>
              <uix:stackLayout>
                            <uix:labeledFieldLayout 
                                labelWidth="4%"
                                fieldWidth="96%"
                                width="100%" 
                                >
                                <%-- Label --%>
                                <uix:messagePrompt 
                                    promptBinding="TYPE@sdkBundle" />

                                <%-- Field --%>
                                <% if (Boolean.TRUE.equals(
                                       request.getAttribute("editMode")))
                                   {
                                %>
                                    <uix:styledText 
                                        textBinding=
                                            "selectedTargetTypeDisplayName@servletRequest"
                                        styleClass="OraDataText" />
                                <%
                                   }
                                   else
                                   {
                                %>
                                    <uix:choice
                                      name="targetType" shortDescBinding="TYPE@sdkBundle"
                                      primaryClientActionBinding="onChangeDroplist@servletRequest" selectedValueBinding="selectedTargetType@servletRequest" 
                                    >
                                    <uix:contents 
                                        childDataBinding="targetTypes@servletRequest">
                                        <uix:option 
                                            textBinding="text" 
                                            valueBinding="value"
                                    />
                                    </uix:contents>
                                    </uix:choice>
                                <%
                                    }
                                %>

                                <%-- add some spacing --%>
                                <uix:spacer width="5"/>
                                <uix:spacer width="5"/>

                                <%-- Label --%>
                                    <uix:messagePrompt 
                                        promptBinding="METRIC@sdkBundle" />

                                <%-- Field --%>
                                <% if (Boolean.TRUE.equals(
                                       request.getAttribute("editMode")))
                                   {
                                %>
                                    <uix:styledText 
                                        textBinding=
                                            "selectedMetricDisplayName@servletRequest"
                                        styleClass="OraDataText" />
                                <%
                                   }
                                   else
                                   {
                                %>
                                     <% if (Boolean.TRUE.equals(
                                       request.getAttribute("metricListEmpty")))
                                     {
                                     %>
                                        <uix:styledText
                                          textBinding=
                                            "ADD_CHART_NO_METRIC@groupBundle"
                                          styleClass="OraDataText" />
                                     <%
                                     }
                                     else
                                     {
                                     %>
                                       <uix:choice 
                                        name="metricName" shortDescBinding="METRIC@sdkBundle"
                                        selectedValueBinding="selectedMetric@servletRequest" 
                                       >
                                       <uix:contents 
                                        childDataBinding="metricNames@servletRequest">
                                        <uix:option 
                                            textBinding="text" 
                                            valueBinding="value"
                                       />
                                       </uix:contents>
                                      </uix:choice>
                                    <%
                                     }
                                    %>
                                <%
                                    }
                                %>
                            </uix:labeledFieldLayout>
                            <uix:spacer width="10" />
                      </uix:stackLayout>
     <%
        }
     %>
     </uix:rowLayout>
     </uix:tableLayout>
     <uix:tableLayout id ="chartTypeHdr" width="100%">
     <uix:rowLayout>
    <% if ( ! Boolean.TRUE.equals(request.getAttribute("metricListEmpty"))
            && !Boolean.TRUE.equals(request.getAttribute("noTargetTypes")))
       {
    %>
                        <uix:header textBinding="SELECT_CHART_TYPE@groupBundle">
                            <uix:tableLayout width="100%">
                              <uix:rowLayout>
                                <uix:spacer width="5"/>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:cellFormat vAlign="top" hAlign="center">
                                  <uix:radioButton 
                                     name="chartChoice"
                                     value="highestAvgTargets"
                                     selectedValueBinding="selectedChartType@servletRequest"
                                     primaryClientActionBinding="hideTableAction@servletRequest"
                                     shortDescBinding="TARGETS_HIGHEST_AVG@mntrResourceBundle"
                                     />
                                </uix:cellFormat>
                                <uix:messageChoice promptBinding="TARGETS_HIGHEST_AVG@mntrResourceBundle"
                                                   shortDescBinding="TARGETS_HIGHEST_AVG@mntrResourceBundle"
                                                   name="numHighestAvgTargets"
                                                   selectedValueBinding="numHighestAvgTargets@servletRequest">
                                  <uix:contents 
                                    childDataBinding="numTargetsList@servletRequest">
                                    <uix:option 
                                      textBinding="text" 
                                      valueBinding="value"/>
                                  </uix:contents>
                                </uix:messageChoice>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:spacer width="5" />
                                <uix:messageText tipBinding="CHART_HIGH_AVG@groupBundle" />
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:spacer height="10"/>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:cellFormat vAlign="top" hAlign="center">
                                  <uix:radioButton 
                                     name="chartChoice"
                                     value="lowestAvgTargets"
                                     selectedValueBinding="selectedChartType@servletRequest"
                                     primaryClientActionBinding="hideTableAction@servletRequest"
                                     shortDescBinding="TARGETS_LOWEST_AVG@mntrResourceBundle"
                                     />
                                </uix:cellFormat>
                                <uix:messageChoice  promptBinding="TARGETS_LOWEST_AVG@mntrResourceBundle"
                                                    shortDescBinding="TARGETS_LOWEST_AVG@mntrResourceBundle"
                                                    name="numLowestAvgTargets"
                                                    selectedValueBinding="numLowestAvgTargets@servletRequest">
                                  <uix:contents 
                                    childDataBinding="numTargetsList@servletRequest">
                                    <uix:option 
                                      textBinding="text" 
                                      valueBinding="value"/>
                                  </uix:contents>
                                </uix:messageChoice>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:spacer width="5" />
                                <uix:messageText tipBinding="CHART_LOW_AVG@groupBundle" />
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:spacer height="10" />
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:cellFormat vAlign="top" hAlign="center">
                                  <uix:radioButton 
                                     name="chartChoice"
                                     value="summaryMetrics"
                                     selectedValueBinding="selectedChartType@servletRequest"
                                     primaryClientActionBinding="hideTableAction@servletRequest"
                                     shortDescBinding="GROUP_STATISTICS@groupBundle"
                                     />
                                  </uix:cellFormat>
                                  <uix:rowLayout hAlign="left">
                                    <uix:styledText 
                                        textBinding="GROUP_STATISTICS@groupBundle"
                                        styleClass="OraPromptText"/>
                                  </uix:rowLayout>
                               </uix:rowLayout>
                               <uix:rowLayout hAlign="left">
                                 <uix:spacer width="5"/>
                                 <uix:cellFormat >
                                   <uix:contents 
                                      childDataBinding="summaryMetricList@servletRequest">
                                     <uix:checkBox
                                       nameBinding="name"
                                       textBinding="text"
                                       shortDescBinding="text"
                                       checkedBinding="checked"
                                     />
                                   </uix:contents>
                                 </uix:cellFormat>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:spacer />
                                <uix:messageText tipBinding="CHART_SUMMERY_METRIC@groupBundle" />
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:spacer height="10" />
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:cellFormat vAlign="top" hAlign="center">
                                  <uix:radioButton 
                                     name="chartChoice"
                                     value="peakTargets"
                                     selectedValueBinding="selectedChartType@servletRequest"
                                     primaryClientActionBinding="hideTableAction@servletRequest"
                                     shortDescBinding="PEAK_TARGETS@mntrResourceBundle"
                                     />
                                </uix:cellFormat>
                                  <uix:messageChoice promptBinding="PEAK_TARGETS@mntrResourceBundle"
                                                     name="numPeakTargets"
                                                     shortDescBinding="PEAK_TARGETS@mntrResourceBundle"
                                                     selectedValueBinding="numPeakTargets@servletRequest">
                                    <uix:contents 
                                      childDataBinding="numTargetsList@servletRequest">
                                      <uix:option 
                                         textBinding="text" 
                                         valueBinding="value"/>
                                    </uix:contents>
                                  </uix:messageChoice>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:spacer />
                                <uix:messageText tipBinding="CHART_PEAK_TARGET@groupBundle" />
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:spacer height="10"/>
                              </uix:rowLayout>

                              <uix:rowLayout>
                                <uix:cellFormat vAlign="top" hAlign="center">
                                  <uix:radioButton
                                    name="chartChoice"
                                    value="selectedTargets"
                                    selectedValueBinding="selectedChartType@servletRequest"
                                    primaryClientActionBinding="showTableAction@servletRequest"
                                    shortDescBinding="SELECTED_TARGETS@mntrResourceBundle"
                                    />
                                </uix:cellFormat>
                                <uix:styledText 
                                  textBinding="SELECTED_TARGETS@mntrResourceBundle"
                                  styleClass="OraPromptText"/>
                              </uix:rowLayout>
                              <uix:rowLayout width="100%" renderedBinding="showTable@servletRequest">
                                <uix:spacer width="10"/>
                                <uix:table name="chartMembersTable"
                                  id="chartMembersTable"
                                  alternateTextBinding="NO_DATA_STR@mntrResourceBundle"
                                  width="100%"
                                  formSubmitted="true"
                                  blockSize="10"
                                  valueBinding="tableValue@servletRequest"
                                  minValueBinding="minValue@servletRequest"
                                  maxValueBinding="maxValue@servletRequest"
                                  tableDataBinding="tableDataKey@tableData@servletRequest"
                                  columnFormatsBinding="tableColumnFormats@servletRequest"
                                  showAll="yes"
                                  >
                                  <uix:tableFormat tableBanding="rowBanding"/>
                                  <uix:column>
                                    <uix:columnHeader>
                                      <uix:sortableHeader textBinding="NAME@sdkBundle" 
                                                          sortableBinding="nameSortable@servletRequest" />
                                    </uix:columnHeader>
                                        <uix:styledText textBinding="targetName" />
                                  </uix:column>
                                  <uix:column>
                                    <uix:columnHeader>
                                        <uix:sortableHeader textBinding="TYPE@sdkBundle" 
                                                            sortable="no" />
                                    </uix:columnHeader>
                                        <uix:styledText textBinding="dispType" />
                                    </uix:column>
                                  <uix:tableSelection>
                                    <uix:multipleSelection 
                                      selectionBinding="selection@servletRequest"
                                      shortDescBinding="SELECT@commonResourceBundle"
                                      selectedBinding="selected">
                                    </uix:multipleSelection>
                                  </uix:tableSelection>
                                </uix:table>
                              </uix:rowLayout>
                          </uix:tableLayout>
                        </uix:header>
            <%
               }
            %>
            </uix:rowLayout>
            </uix:tableLayout>
         </uix:pageLayout>
        </uix:form>
      </uix:body>
    </uix:document>
</uix:renderingContext>
