<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<%@ page import="oracle.sysman.eml.mntr.Constants"%>

<oem:pageSegment>
<uix:dataScope>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="groupBundle"
              class="oracle.sysman.eml.rsc.target.grps.GroupsMsg"/>              

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
    <uix:stackLayout>
        <uix:spacer height="10" />
        <uix:styledText styleClass="OraInstructionText"
                        textBinding="instructionText"
                        />
        <uix:spacer height="20" />
        <uix:rowLayout width="100%">
            <uix:table name="groupColumnsTable" 
                id="groupColumnsTable" 
                alternateTextBinding="NO_DATA_STR@mntrResourceBundle" 
                width="80%" 
                formSubmitted="true" 
                tableDataBinding="tableDataKey@tableData@" 
                columnFormatsBinding="tableColumnFormats@" 
                columnHeaderDataBinding="tableColumnHeaders@"
                summaryBinding="COLUMN_TABLE_SUMMARY@groupBundle"
                blockSize="25"
                maxValueBinding="maxValue@"
                valueBinding="startValue@">
                <uix:tableFormat tableBanding="rowBanding"/>
                <uix:tableActions >
                  <uix:submitButton 
                    textBinding="MODIFY@mntrResourceBundle"
                    shortDescBinding="MODIFY@mntrResourceBundle"
                    name="event" 
                    value="modifyColumn"/>
                </uix:tableActions>                
                <uix:columnHeaderStamp>
                    <uix:styledText textBinding="text" />
                </uix:columnHeaderStamp>
                <uix:contents>
                    <uix:styledText textBinding="columnName"/>
                    <uix:textInput name="abbr" textBinding="columnAbbr" shortDescBinding="columnAbbr"/>
                    <uix:formValue name="columnKey" valueBinding="value" />
                </uix:contents>
            </uix:table>
        </uix:rowLayout>
        <uix:rowLayout>
            <uix:spacer width="20" />
        </uix:rowLayout>
    </uix:stackLayout>
</uix:renderingContext>
</uix:dataScope>
</oem:pageSegment>
