<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="groupsMsg"
              class="oracle.sysman.eml.rsc.target.grps.GroupsMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <uix:form name="manageColumnForm" method="POST">
        <uix:pageLayout titleBinding="manageColumnHeader@servletRequest">
          <%@ include file="/enablePPR.jspf" %>        
          <%@ include file="/oemGlobal.jspf" %>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:switcher childNameBinding="nodeValue@servletRequest">
                    <uix:case name="okNode">
                      <uix:cellFormat>
                        <uix:submitButton name="event"
                                        textBinding="CANCEL@commonResourceBundle"
                                        shortDescBinding="CANCEL@commonResourceBundle"
                                        value="cancel"/>
                        <uix:spacer width="4"/>
                        <uix:submitButton name="event"
                                        textBinding="CONTINUE@sdkUIMsg"
                                        shortDescBinding="CONTINUE@sdkUIMsg"
                                        value="Continue"/>
                      </uix:cellFormat>
                    </uix:case>
                    <uix:case name="errNode">
                      <uix:submitButton name="event"
                                        textBinding="CONTINUE@sdkUIMsg"
                                        shortDescBinding="CONTINUE@sdkUIMsg"
                                        value="Error"/>
                    </uix:case>
                  </uix:switcher>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:contents>
            <uix:switcher childNameBinding="nodeValue@servletRequest">
              <uix:case name="okNode">
                <uix:stackLayout>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="instructionText@servletRequest"
                                  />
                  <uix:spacer height="10" />                                
                  <uix:shuttle name="shuttle"
                               size="5"
                               leadingHeaderBinding="AVAILABLE_COLUMNS@groupsMsg"
                               trailingHeaderBinding="SELECTED_COLUMNS@groupsMsg" >
                    <uix:filter>
                      <uix:rowLayout>
                        <uix:inlineMessage promptBinding="TYPE@mntrResourceBundle" >
                          <uix:choice name="typeChoice"
                                      id="typeChoice"
                                      selectedValueBinding="selectedTargetType@servletRequest"
                                      shortDescBinding="TYPE@mntrResourceBundle"
                                      primaryClientActionBinding="onChangeTargetTypeDropBox@servletRequest">
                            <uix:contents childDataBinding="targetTypes@servletRequest" >
                              <uix:option textBinding="text"
                                          valueBinding="value" />
                            </uix:contents>
                          </uix:choice>
                        </uix:inlineMessage>
                      </uix:rowLayout>
                    </uix:filter>

                    <uix:leading  >
                      <uix:list shortDescBinding="AVAILABLE_COLUMNS@groupsMsg" id="available" multiple="true"
                                >
                        <uix:contents childDataBinding="metricNames@servletRequest">
                          <uix:option textBinding="text"
                                      valueBinding="value"/>
                        </uix:contents>
                      </uix:list>
                    </uix:leading>
                    <uix:trailing>
                      <uix:list shortDescBinding="SELECTED_COLUMNS@groupsMsg" id="selected" multiple="true">
                        <uix:contents childDataBinding="selectedList@servletRequest">
                          <uix:option textBinding="text"
                                      valueBinding="value"/>
                        </uix:contents>
                      </uix:list>
                    </uix:trailing>
                  </uix:shuttle>
                </uix:stackLayout>
              </uix:case>

              <uix:case name="errNode">
                <uix:messageBox messageBinding="errorMessage@servletRequest"
                                messageType="error"
                                shortDescBinding="ERR_OCCUR@mntrResourceBundle"
                                textBinding="ERR_OCCUR@mntrResourceBundle">
                </uix:messageBox>
              </uix:case>
            </uix:switcher>
          </uix:contents>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
