<%@ include file = "/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="sdkUIBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg" />
  <uix:bundle name="GroupsMsg"  class="oracle.sysman.eml.rsc.target.grps.GroupsMsg" />

  <uix:document>
    <%@ include file ="/oemTitle.jspf"  %>
    <uix:body>
      <uix:form name="createAssoc" method="POST">
        <uix:pageLayout>
          <%@ include file ="/oemGlobal.jspf"%>
          <%@ include file="/enablePPR.jspf" %>
          <uix:contents>
            
            <uix:switcher childNameBinding="SourceDestinationEqual@servletRequest">
              <uix:case name="true">
                <uix:messageBox messageBinding="errorMsg@servletRequest" 
                  messageType="error"/>
              </uix:case>
            </uix:switcher>  
            
            <uix:header textBinding="title@CreateAssociationDataList@servletRequest" >
              <uix:formValue name="isDateInvalid"/>
              <uix:formValue name="type" 
                valueBinding="targetType@CreateAssociationDataList@servletRequest"/>
              
              <uix:rowLayout hAlign = "right">
                <uix:pageButtonBar>
                  <uix:submitButton textBinding="CANCEL@sdkUIBundle"
                    name="event" value="cancelCreateAssoc"
                    shortDescBinding="CANCEL@sdkUIBundle"/>
                  <uix:submitButton textBinding="CONTINUE@sdkUIBundle"
                    name="event" value="continueCreateAssoc"
                    shortDescBinding="CONTINUE@sdkUIBundle"/>
                </uix:pageButtonBar>
              </uix:rowLayout>
              
              <uix:rowLayout hAlign="left">
                  <uix:styledText textBinding="CREATE_ASSOCIATION_INSTR_TEXT@GroupsMsg"
                     styleClass="OraInstructionText"/>
              </uix:rowLayout>
              
              <uix:spacer height = "20"/>
              
              <uix:tableLayout>
                
                <uix:rowLayout vAlign="middle">
                  <uix:spacer width="50"/>
                  <uix:cellFormat hAlign="right">
                    <uix:messageChoice name="Source" id="Source"
                      promptBinding="SOURCE@GroupsMsg" required="yes"
                      selectedValueBinding="sourceAssocSelected@CreateAssociationDataList@servletRequest" >
                      <uix:contents childDataBinding="assocs@CreateAssociationDataList@servletRequest" >
                        <uix:option textBinding="Members" valueBinding="MembersValue" />
                      </uix:contents>
                    </uix:messageChoice>
                  </uix:cellFormat>
                </uix:rowLayout>               
                
                <uix:rowLayout vAlign="middle">
                  <uix:spacer width="50"/>
                  <uix:cellFormat hAlign="right">
                    <uix:messageChoice name="Destination" id="Destination"
                      promptBinding="DESTINATION@GroupsMsg" required="yes"
                      selectedValueBinding="destAssocSelected@CreateAssociationDataList@servletRequest" >
                      <uix:contents childDataBinding="assocs@CreateAssociationDataList@servletRequest" >
                        <uix:option textBinding="Members" valueBinding="MembersValue" />
                      </uix:contents>
                    </uix:messageChoice>
                  </uix:cellFormat>
                  <uix:spacer width="20"/>
                </uix:rowLayout>
              
              </uix:tableLayout>
            </uix:header>
          </uix:contents>
          
          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@sdkUIBundle" name="event"
                value="cancelCreateAssoc"
                shortDescBinding="CANCEL@sdkUIBundle"/>
              <uix:submitButton textBinding="CONTINUE@sdkUIBundle" name="event"
                value="continueCreateAssoc"
                shortDescBinding="CONTINUE@sdkUIBundle"/>
            </uix:pageButtonBar>
          </uix:contentFooter>
        
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
