<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<%@ page import="oracle.sysman.eml.mntr.Constants"%>

<oem:pageSegment>
<uix:dataScope>
  <uix:bundle name="groupBundle"
              class="oracle.sysman.eml.rsc.target.grps.GroupsMsg"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="rcaResourceBundle"
              class="oracle.sysman.resources.RCAResourceBundle"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

        <uix:stackLayout>
          <uix:spacer height="10" />
          <uix:styledText styleClass="OraInstructionText" 
                          textBinding="instructionText"
          />
          <uix:spacer height="20"/> 
          <uix:tableLayout width="100%"> 
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="left" vAlign="top">
                <uix:styledText styleClass="OraPromptText" 
                                textBinding="DASHBD_REFRESH_TIME@groupBundle"/>
              </uix:cellFormat>
              <uix:spacer width="30" />
              <uix:cellFormat>
                <uix:textInput name="refreshTime"
                               id="refreshTime"
                               maximumLength="10"
                               columns="2"
                               required ="yes"
                               shortDescBinding="DASHBD_REFRESH_TIME@groupBundle"
                               textBinding ="refreshTime@servletRequest">
                  <uix:onSubmitValidater>
                    <uix:decimal /> 
                  </uix:onSubmitValidater>
                </uix:textInput>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat columnSpan="3">
                <uix:spacer />
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat hAlign="middle" vAlign="top">
                <uix:styledText styleClass="OraPromptText" 
                              textBinding="DASHBD_TGT_VIEW_TYPE@groupBundle"
                              />
                 <uix:spacer width="12" />  
              </uix:cellFormat>
              <uix:spacer width="10" />  
              <uix:messageRadioButton name="targetViewType"
                                 textBinding="DASHBD_FULL_VIEW_TEXT@groupBundle"
                                 shortDescBinding="DASHBD_FULL_VIEW_TEXT@groupBundle"
                                 selectedValueBinding = "viewType@servletRequest"
                                 value="Full"
                                 tipBinding="DASHBOARD_SHOW_BY_TARGET@groupBundle"
                                 vAlign="top">
               </uix:messageRadioButton>
               <uix:messageRadioButton name="targetViewType"
                                 textBinding="DASHBD_ROLLUP_VIEW_TEXT@groupBundle"
                                 shortDescBinding="DASHBD_ROLLUP_VIEW_TEXT@groupBundle"
                                 selectedValueBinding = "viewType@servletRequest"
                                 value="Rollup"
                                 tipBinding="DASHBOARD_SHOW_BY_GROUP@groupBundle"
                                 >
                </uix:messageRadioButton>
             </uix:rowLayout>
			 <uix:rowLayout>
				<uix:spacer width="1" />
				<uix:spacer width="10" />
				<uix:messageCheckBox name="alertTableAllowed"
                                                     value="On"
                                                     selectedValueBinding="alertTableAllowed@servletRequest"
                                                     shortDescBinding="ALERT_DETAILS@rcaResourceBundle"
                                                     textBinding="ALERT_DETAILS@rcaResourceBundle"/>
             </uix:rowLayout>
            </uix:tableLayout>
          <uix:spacer height="10"/>
          <uix:tip textBinding= "DASHBD_HINT_TEXT@groupBundle" />
          <uix:spacer height="10"/>
        </uix:stackLayout>
</uix:renderingContext>
</uix:dataScope>
</oem:pageSegment>
