<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<oem:pageSegment>
  <uix:dataScope>
    <uix:bundle name="sdkUIBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg" />
    <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle" /> 
    <uix:bundle name="GroupsMsg" class="oracle.sysman.eml.rsc.target.grps.GroupsMsg"/>
    <uix:stackLayout>
      <uix:ref refID="oracle_sysman_eml_target_grps_adm_EditAssociationsSegmentHandler_message_node_ref_ID" /> 
      <uix:spacer height="15" />
      <uix:rowLayout width="100%" >
        <uix:cellFormat hAlign="left" >
          <uix:rowLayout >
  
            <uix:inlineMessage prompt="Search" >
              <uix:choice name="searchType" id="searchType"
                selectedValueBinding="searchType@selectAssocsMap@" 
                shortDescBinding="SEARCH@sdkUIBundle">
                <uix:contents>
                  <uix:option textBinding="ALL@GroupsMsg" value="All" />
                  <uix:option textBinding="SOURCE@GroupsMsg" value="Source" />
                  <uix:option textBinding="DESTINATION@GroupsMsg" value="Destination" />
                </uix:contents>
              </uix:choice>
            </uix:inlineMessage>
  
            <uix:spacer width="10"/>
            <uix:textInput name="searchName" columns="30"
              textBinding="searchName@selectAssocsMap@" 
              shortDescBinding="SEARCH@sdkUIBundle"
              onKeyPress="getKey()"/>
  
            <uix:spacer width="15"/>
            <uix:submitButton textBinding="GO@sdkUIBundle" name="event" 
              value="Go" shortDescBinding="GO@sdkUIBundle" />
          </uix:rowLayout >
        </uix:cellFormat >
      </uix:rowLayout >
      
      <uix:spacer height="10" />

      <uix:tableLayout width="100%" cellSpacing="5">
        <uix:table id="AssocTable" name="AssocTable"
          width="100%" blockSize="25" 
          valueBinding="value@selectAssocsMap@" 
          minValue="1" 
          maxValueBinding="max@selectAssocsMap@" 
          formSubmitted="true" 
          tableDataBinding="list@selectAssocsMap@"                       
          columnHeaderDataBinding="columnHeader@selectAssocsMap@"
          showAll="yes"
	  summaryBinding="TOPOLOGY_TABLE_SUMMARY@GroupsMsg"
          alternateTextBinding="NO_ASSOCIATIONS@GroupsMsg">
          <uix:tableFormat tableBanding="rowBanding"/>
          <uix:tableActions>
            <uix:rowLayout>  
              <uix:submitButton name="event" value="add" 
                renderedBinding="addButton@selectAssocsMap@"
                textBinding="ADD@sdkUIBundle" shortDescBinding="ADD@sdkUIBundle"/>
            </uix:rowLayout>  
          </uix:tableActions>
          <uix:tableSelection>
            <uix:singleSelection 
              selectedIndex="0"
              shortDescBinding="SELECT@commonResourceBundle">
              <uix:submitButton name="event" value="remove" 
                renderedBinding="removeButton@selectAssocsMap@"
                textBinding="REMOVE@sdkUIBundle" shortDescBinding="REMOVE@sdkUIBundle"/>
            </uix:singleSelection>
          </uix:tableSelection>
          <uix:contents>
            <uix:column>
              <uix:columnHeader>
                <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
              </uix:columnHeader>
              <uix:columnFormat columnDataFormat="textFormat"/>
              <uix:styledText id="SourceTargetName" textBinding="SourceTargetName" />
              <uix:formValue name="SourceTargetName" valueBinding="SourceTargetName"/> 
            </uix:column>
            <uix:column>
              <uix:columnHeader>
                <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
              </uix:columnHeader>
              <uix:columnFormat columnDataFormat="textFormat"/>
              <uix:styledText id="SourceTargetType" textBinding="SourceTargetType" />
              <uix:formValue name="SourceTargetType" valueBinding="SourceTargetType"/> 
            </uix:column>
            <uix:column>
              <uix:columnHeader>
                <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
              </uix:columnHeader>
              <uix:columnFormat columnDataFormat="textFormat"/>
                <uix:styledText id="AssociatedTargetName" textBinding="AssociatedTargetName" />
              <uix:formValue name="AssociatedTargetName" valueBinding="AssociatedTargetName"/> 
            </uix:column>
            <uix:column>
              <uix:columnHeader>
                <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
              </uix:columnHeader>
              <uix:columnFormat columnDataFormat="textFormat"/>
                <uix:styledText id="AssociatedTargetType" textBinding="AssociatedTargetType" />
              <uix:formValue name="AssociatedTargetType" valueBinding="AssociatedTargetType"/> 
            </uix:column>
          </uix:contents>
        </uix:table>
      </uix:tableLayout>
      <uix:spacer height="20" />
    </uix:stackLayout>
  </uix:dataScope>
</oem:pageSegment>
