<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext" />
  <uix:bundle name="sdkUIBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg" />
  <uix:bundle name="grpsMsg" class="oracle.sysman.eml.rsc.target.grps.GroupsMsg" />
  <uix:document>
    <uix:body />
    <%@include file="/oemTitle.jspf" %>
    <uix:form method="POST" name="SheetForm" 
         usesUploadBinding="webapps.em.target.groups.admin.usesUpload@servletRequest">
      <uix:pageLayout titleBinding="header@sheetData@servletRequest">
        <%@include file="/enablePPR.jspf" %>
        <%@include file="/oemGlobal.jspf" %>
        <%-- Ok & Cancel button --%>
        <uix:pageButtons> 
          <uix:pageButtonBar>
            <uix:submitButton textBinding="CANCEL@sdkUIBundle"
                              shortDescBinding="CANCEL@sdkUIBundle"
                              name="event"
                              value="Cancel"/>
            <uix:submitButton textBinding="OK@sdkUIBundle"
                              shortDescBinding="OK@sdkUIBundle"
                              name="event"
                              value="OK"/>
          </uix:pageButtonBar>
        </uix:pageButtons>
        <uix:messages>
          <uix:messageBox 
            messageTypeBinding="messageType@sheetData@servletRequest"
            messageBinding="message@sheetData@servletRequest"
            renderedBinding="displayMessage@sheetData@servletRequest">
            <uix:contents childDataBinding="errors@sheetData@servletRequest">
              <uix:link textBinding="text" 
                        longDescBinding="longdesc"
                        destinationBinding="destination"/>
            </uix:contents>
          </uix:messageBox>
        </uix:messages>
          
        <uix:stackLayout>
          <uix:subTabBar orientation="top" 
                         selectedIndexBinding="pageIndex@sheetData@servletRequest">
            <uix:contents childDataBinding="faintTabs@sheetData@servletRequest">
              <uix:link textBinding="text"
                        destinationBinding="destination"
                        primaryClientActionBinding="primaryClientAction"
                        />
            </uix:contents>
          </uix:subTabBar>
      
          <%-- include property page --%>
          <uix:ref refID="<%=request.getAttribute(oracle.sysman.eml.target.grps.GroupConstants.GROUP_PAGE_SEGMENTS_UINODE)%>" />
          <uix:subTabBar orientation="bottom" 
                         selectedIndexBinding="pageIndex@sheetData@servletRequest">
            <uix:contents childDataBinding="faintTabs@sheetData@servletRequest">
              <uix:link textBinding="text"
                        destinationBinding="destination"
                        primaryClientActionBinding="primaryClientAction"
                        />
           </uix:contents>
         </uix:subTabBar>
       </uix:stackLayout>
     </uix:pageLayout>
    </uix:form>
  </uix:document>
  <uix:script text= "
  function getKey(keyStroke)
  {
    var isNav = (navigator.appName.indexOf('Netscape') != -1);
    if (isNav)
    {
      document.captureEvents(Event.KEYPRESS);
      document.onkeypress = getKey;
    }
    key = (isNav) ? keyStroke.which : event.keyCode;
    if(key == '13')
    {
      submitForm('SheetForm',1,{'event':'Go'});
      return false;
    }
  }" />

</uix:renderingContext>
