<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/sdk/oemTop.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext" />
  <uix:bundle name="sdkUIBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg" />
  <uix:bundle name="grpsMsg" class="oracle.sysman.eml.rsc.target.grps.GroupsMsg" />
  <uix:bundle name="mntrMsg" class="oracle.sysman.resources.MntrResourceBundle" />  
  <uix:document>
    <uix:body />
    <%@include file="/oemTitle.jspf" %>
    <uix:form method="POST" name="TargetTypeForm">
      <uix:pageLayout titleBinding="header@servletRequest">
      <%@include file="/enablePPR.jspf" %>
      <%@include file="/oemGlobal.jspf" %>
              <%-- Continue & Cancel button --%>
        <uix:pageButtons> 
          <uix:pageButtonBar>
            <uix:submitButton textBinding="CANCEL@sdkUIBundle"
                              name="event"
                              value="Cancel"
                              shortDescBinding="CANCEL@sdkUIBundle" />
            <uix:submitButton textBinding="CONTINUE@sdkUIBundle" 
                              name="event"
                              value="Continue" 
                              shortDescBinding="CONTINUE@sdkUIBundle" />
          </uix:pageButtonBar>
        </uix:pageButtons>
        <uix:stackLayout >
          <uix:styledText styleClass="OraInstructionText"
                          textBinding="instructionText@servletRequest"
                          />
          <uix:spacer height="10" />
          <uix:rowLayout >
            <uix:cellFormat hAlign="left" vAlign="top" width="35%">
              <uix:labeledFieldLayout labelWidth="25%">
                <uix:styledText textBinding="MEMBER_TYPE@grpsMsg" />
                <uix:choice required="yes" name="mbrType">
                  <uix:contents childDataBinding="types@servletRequest">
                    <uix:option textBinding="text" valueBinding="value" />
                  </uix:contents>
                </uix:choice>
              </uix:labeledFieldLayout>
            </uix:cellFormat>
            <uix:cellFormat hAlign="right">
              <uix:contentContainer textBinding="GROUP_OVERVIEW@mntrMsg" width="65%">
                <uix:styledText textBinding="CREATE_REDUNDANCY_GROUP_DESCRIPTION_TEXT@grpsMsg"
                        styleClass="OraInstructionText"/>
              </uix:contentContainer>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:stackLayout>
      </uix:pageLayout>
    </uix:form>
  </uix:document>
</uix:renderingContext>
