<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<oem:pageSegment>
  <uix:dataScope>
    <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle" /> 
  <uix:stackLayout>
    <uix:spacer height="20" />
    <uix:tableLayout>
      <uix:rowLayout renderedBinding="creating@">
        <uix:spacer width="10" />
        <uix:cellFormat hAlign="right">
          <uix:messagePrompt styleClass="OraInstructionText" anchor="tgtName" 
            promptBinding="NAME@sdkUIBundle" required="uiOnly" />
        </uix:cellFormat>
        <uix:spacer width="10" />
        <uix:textInput textBinding="name@adminObject@servletRequest" 
            shortDescBinding="NAME@sdkUIBundle"
            name="tgtName"/>
      </uix:rowLayout>
      <uix:rowLayout renderedBinding="renderMemberType">
        <uix:spacer height="10" />
      </uix:rowLayout>
      <uix:rowLayout renderedBinding="renderMemberType">
        <uix:spacer width="10" />
        <uix:cellFormat hAlign="right">
          <uix:styledText textBinding="MEMBER_TYPE@grpsMsg" 
            styleClass="OraInstructionText"/>
        </uix:cellFormat>
        <uix:spacer width="10" />
        <uix:styledText textBinding="memberType" styleClass="OraDataText"/>
      </uix:rowLayout>   
    </uix:tableLayout>
    <uix:spacer height="20" />
    <uix:header textBinding="childrenType">
      <uix:spacer height="10" />
      <uix:table tableDataBinding="members@" width="80%" valueBinding="startValue@"
          name="memberTable" alternateTextBinding="NO_TARGETS_SELECTED@sdkUIBundle"
          blockSizeBinding="blockSize@" maxValueBinding="maxValue@"
          showAll="yes" summaryBinding="MEMBER_TYPE@grpsMsg">
      
        <uix:tableActions>
          <uix:cellFormat  rendered="true" renderedBinding="ALLOW_MEMBER_EDIT">
          <oem:targetSelection  textBinding="ADD@sdkUIBundle"/> 
          </uix:cellFormat>                    
        </uix:tableActions>
        <uix:tableSelection>
          <uix:multipleSelection rendered="true" renderedBinding="ALLOW_MEMBER_EDIT" shortDescBinding="SELECT@commonResourceBundle">
            <uix:submitButton name="event" value="delete" 
                  textBinding="REMOVE@sdkUIBundle" 
                  shortDescBinding="REMOVE@sdkUIBundle"/>
          </uix:multipleSelection>
        </uix:tableSelection>
      
        <uix:column>
          <uix:columnHeader>
            <uix:sortableHeader textBinding="NAME@sdkUIBundle" 
                          sortableBinding="nameSortable@" />
          </uix:columnHeader>
          <uix:styledText textBinding="DisplayName" />
        </uix:column>
      
        <uix:column>
          <uix:columnHeader>
            <uix:sortableHeader textBinding="TYPE@sdkUIBundle" 
                        sortableBinding="typeSortable@" />
          </uix:columnHeader>
          <uix:styledText textBinding="TypeDisplayName" />
        </uix:column>
      </uix:table>
    </uix:header>
    <uix:spacer height="20" />
    <uix:header textBinding="TIME_ZONE@sdkUIBundle">
    <uix:tableLayout>
      <uix:rowLayout renderedBinding="creating@" >
        <uix:spacer height="10" />
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:cellFormat hAlign="right">
          <uix:styledText textBinding="TIME_ZONE@sdkUIBundle" styleClass="OraInstructionText"/>
        </uix:cellFormat>
        <uix:spacer width="10" />
        <uix:choice name="timeZone" renderedBinding="creating@" shortDescBinding="TIME_ZONE@sdkUIBundle"
         styleClass="OraInstructionText">
          <uix:contents childDataBinding="timezone@">
            <uix:option textBinding="text" valueBinding="value"
              selectedBinding="selected"/>
          </uix:contents>
        </uix:choice>
        <uix:styledText styleClass="OraDataText" textBinding="timezone@" renderedBinding="editing@" />
      </uix:rowLayout>
    </uix:tableLayout>
    </uix:header>
    <uix:spacer height="25" />
   </uix:stackLayout>
</uix:dataScope>
</oem:pageSegment>
