<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<oem:pageSegment>
  <uix:dataScope>
    <uix:bundle name="grpsMsg"
                class="oracle.sysman.eml.rsc.target.grps.GroupsMsg"/> 
    <uix:bundle name="sdkMsg"
                class="oracle.sysman.emSDK.eml.SDKUIMsg" 
    />
   
    <uix:stackLayout>
      <uix:styledText styleClass="OraInstructionText"
                      textBinding="EDIT_ASSOCIATION_TIP@grpsMsg"
                      />
      <uix:spacer width="5" />
      <oem:topology topoPageType="sysAdminTopoPageType"
                    keyParameters="type, target"
                    hideSearch="yes"
                    hideSummary="yes"
                    width="100%"
      />
      <uix:spacer height="10" />
      
      <uix:tableLayout hAlign="center" cellSpacing="10">
        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
            <uix:styledText styleClass="OraInstructionText"
                            textBinding="LAYOUT_MODE@grpsMsg"
            />
          </uix:cellFormat>
          <uix:cellFormat hAlign="left">
            <uix:radioSet name="layout"
                          selectedValueBinding="oracle_sysman_eml_target_grps_sys_layout_value@servletRequest">
              <uix:option textBinding="AUTOMATIC_LAYOUT@grpsMsg"
                          value="automatic" />
              <uix:option textBinding="MANUAL_LAYOUT@grpsMsg"
                          value="manual" />
            </uix:radioSet>              
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
            <uix:styledText styleClass="OraInstructionText"
                            textBinding="BACKGROUND_IMAGE@grpsMsg"
            />
          </uix:cellFormat>
          <uix:cellFormat hAlign="left">
          <uix:switcher childNameBinding="oracle_sysman_eml_target_grps_sys_file_uploaded_key@servletRequest">
            <uix:case name="false">
              <uix:stackLayout>
                <uix:fileUpload name="bgImageFile"
                                columns="30"/>
                <uix:tip>
                  <uix:text textBinding="BACKGROUND_IMAGE_TIP@sdkMsg"/>
                </uix:tip>
              </uix:stackLayout>
            </uix:case>
            <uix:case name="true">
              <uix:rowLayout>
                <uix:styledText textBinding="oracle_sysman_eml_target_grps_sys_file_name_key@servletRequest"
                                styleClass="OraInstructionText"
                />
                <uix:spacer width="10" />
                <uix:submitButton textBinding="REMOVE_TEXT@grpsMsg"
                                  name="event"
                                  value="remove" />
              </uix:rowLayout>
            </uix:case>
          </uix:switcher>
          </uix:cellFormat>
        </uix:rowLayout>
        <%--
        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
            <uix:styledText styleClass="OraInstructionText"
                            textBinding="ICON_SIZE@grpsMsg"
            />
          </uix:cellFormat>
          <uix:cellFormat hAlign="left">
            <uix:text text="-" />
            <uix:radioButton name="iconSize" value="0"
                             selectedValueBinding="oracle_sysman_eml_target_grps_sys_icon_size_value@servletRequest" />
            <uix:radioButton name="iconSize" value="1" 
                             selectedValueBinding="oracle_sysman_eml_target_grps_sys_icon_size_value@servletRequest" />
            <uix:radioButton name="iconSize" value="2" 
                             selectedValueBinding="oracle_sysman_eml_target_grps_sys_icon_size_value@servletRequest" />
            <uix:radioButton name="iconSize" value="3" 
                             selectedValueBinding="oracle_sysman_eml_target_grps_sys_icon_size_value@servletRequest" />
            <uix:radioButton name="iconSize" value="4" 
                             selectedValueBinding="oracle_sysman_eml_target_grps_sys_icon_size_value@servletRequest" />
            <uix:radioButton name="iconSize" value="5"
                             selectedValueBinding="oracle_sysman_eml_target_grps_sys_icon_size_value@servletRequest" />
            <uix:radioButton name="iconSize" value="6" 
                             selectedValueBinding="oracle_sysman_eml_target_grps_sys_icon_size_value@servletRequest" />
            <uix:radioButton name="iconSize" value="7" 
                             selectedValueBinding="oracle_sysman_eml_target_grps_sys_icon_size_value@servletRequest" />
            <uix:radioButton name="iconSize" value="8" 
                             selectedValueBinding="oracle_sysman_eml_target_grps_sys_icon_size_value@servletRequest" />
            <uix:text text="+" />
          </uix:cellFormat>
        </uix:rowLayout>
        --%>
        <uix:rowLayout>
          <uix:cellFormat>
          </uix:cellFormat>
          <uix:cellFormat hAlign="left">
            <uix:submitButton textBinding="PREVIEW_TEXT@grpsMsg"
                              name="event"
                              value="preview" />
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>
      <uix:spacer height="5" />
    </uix:stackLayout>
  </uix:dataScope>
</oem:pageSegment>
