<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='java.util.Map' %>
<%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext' %>
<oem:pageSegment>
 <uix:dataScope>
  <uix:bundle name="sdkBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="mntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="groupsMsg" class="oracle.sysman.eml.rsc.target.grps.GroupsMsg"/>
   <uix:tableLayout width="100%" rendered="true">
    <uix:rowLayout><uix:cellFormat>
     <uix:rowLayout hAlign="right"><uix:cellFormat renderedBinding="hasChart@">
      <uix:styledText textBinding="VIEW_DATA@mntrResourceBundle" styleClass="OraPromptText"/>
      <uix:spacer width="5"/>
      <uix:choice name="refOptionChoice" onChangeBinding="handleOnChange@" shortDescBinding="VIEW_DATA@mntrResourceBundle">
      <uix:contents childDataBinding="refOptionList@">
       <uix:option textBinding="name" selectedBinding="selected" valueBinding="value"/>
      </uix:contents>
     </uix:choice>
     <uix:formValue name="event" value="refToOpt"/></uix:cellFormat><uix:cellFormat>
     <uix:spacer width="5" />
     <uix:button textBinding="GROUP_CUSTOMIZE_CHARTS@groupsMsg" destinationBinding="customizeChartsDestination@" shortDescBinding="GROUP_CUSTOMIZE_CHARTS@groupsMsg"/></uix:cellFormat>
    </uix:rowLayout></uix:cellFormat>
   </uix:rowLayout>
  </uix:tableLayout> 
  <uix:stackLayout>
<%
  int numCharts=0;
  String sNumCharts = (String) (((PageSegmentContext) request.getAttribute("pageSegmentContext")).getAttribute("numCharts"));
  if (sNumCharts != null)
  {
      numCharts = Integer.parseInt(sNumCharts);
  }
  else { numCharts = 0; }
  if (numCharts ==0) {
%>
  <uix:styledText styleClass="OraInstructionText" textBinding="NO_CHARTS_DEFINED@groupsMsg" />
<% }
  int numRows = 0;
  if ((numCharts%3) == 0)
  { numRows = numCharts/3; }
  else { numRows = numCharts/3+1; }
  for (int i=0; i<numRows; i++) {
%>
  <uix:rowLayout vAlign="top">
<%
   for (int j=0; j<3; j++) {
    int chartIndex = i*3+j;
    String chartKey = "chart"+chartIndex;
    Object chartObj = (((PageSegmentContext) request.getAttribute("pageSegmentContext")).getAttribute(chartKey));
    if (chartObj != null){
%>
   <uix:cellFormat vAlign="top">
   <uix:dataScope currentDataBinding='<%= chartKey+"@pageSegmentContext@servletRequest" %>'>
    <uix:header textBinding="imageName">
     <oem:chart titleBinding="imageTitle" titleVisible="false" chartType="timeSeriesChart" widthBinding="width" heightBinding="height" timeGranularityBinding="timeGranularity" orientation="vertical" seriesColorsAutomatic="true" legendPosition="south" destinationBinding="compareMetDest" shortDescBinding="imageName" legendVisible="external" externalLegendOrientation="vertical" axisMinBinding="axisMin" axisMaxBinding="axisMax"> <uix:contents>
      <oem:boundChartDataSource chartDataSourceBinding= "chartDataSource"/>
      <oem:imageMap imageMapDataSourceBinding="imapDataSource" />
      <oem:chartColumn isKey="true" displayLabel=""sourceIndex="0"/>
      <oem:chartColumn isTimeColumn="true" displayLabel="" sourceIndex="1"/>
      <oem:chartColumn displayLabel="" sourceIndex="2"/></uix:contents>
     </oem:chart>
    </uix:header>
   </uix:dataScope>
  </uix:cellFormat>
<% } //end if
 } //end inner for
%>
 </uix:rowLayout>
<% } //end outer for
%>
</uix:stackLayout>
</uix:dataScope>
</oem:pageSegment>
