<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import='oracle.sysman.eml.target.grps.GroupsAvailHistorySegmentBean' %>
<%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext' %>
<oem:pageSegment>
  <uix:dataScope>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="gensvcBundle" 
              class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
  <uix:bundle name="sdkMsg" 
              class="oracle.sysman.emSDK.eml.SDKUIMsg" />              


<uix:tableLayout>
  <%
      PageSegmentContext psc = (PageSegmentContext)request.getAttribute("pageSegmentContext"); 
      GroupsAvailHistorySegmentBean bean = (GroupsAvailHistorySegmentBean)psc.getPageSegmentBean();
      String psName = bean.getName();
  %> 
 <uix:rowLayout>
  <uix:hGrid id="<%= psName %>"
             width="950" 
             destinationBinding="destination@pageSegmentBean@" 
             summaryBinding="ALL_METRICS_SUMMARY@mntrResourceBundle" 
             columnFormatsBinding="columnFormats@pageSegmentBean@" 
             columnHeaderDataBinding="subservicesColumnHeaderData@pageSegmentBean@" 
             treeDataBinding="treeData@pageSegmentBean@" 
             proxied="true"
             formSubmitted="true"
             proxyBinding="proxy@pageSegmentBean@"
             childBlockSizeBinding="showNumRows@pageSegmentBean@">
    <uix:nodeStamp>
      <uix:column>
      <uix:columnFormat width="250"/>
        <uix:columnHeader>
          <uix:styledText textBinding="NAME@mntrResourceBundle"/>
        </uix:columnHeader>
        <uix:styledText textBinding="text" destinationBinding="targetDest"/>
      </uix:column>
    </uix:nodeStamp>
      <uix:column>
      <uix:columnFormat width="200"/>
        <uix:columnHeader>
          <uix:styledText textBinding="TYPE@mntrResourceBundle"/>
        </uix:columnHeader>
        <uix:styledText textBinding="typeDisplay" />
      </uix:column>
    <uix:column>
      <uix:columnFormat width="50"/>
      <uix:columnHeader>
        <uix:styledText textBinding="STATUS@mntrResourceBundle"/>
      </uix:columnHeader>
      <uix:columnFormat columnDataFormat="iconButtonFormat" />
      <uix:image sourceBinding="currentStatusSrc"
                 destinationBinding="availDest"
                 shortDescBinding="statusShortDesc"
                 textBinding="statusText"/>
    </uix:column>
    <uix:column>
      <uix:columnFormat width="450"/>
      <uix:columnHeader>
       <uix:styledText textBinding="HISTORY@mntrResourceBundle"/>
      </uix:columnHeader>
      <uix:include nodeBinding="availBarKey" />
    </uix:column>
  </uix:hGrid>
  </uix:rowLayout>
  <uix:rowLayout hAlign="right">
    <uix:cellFormat hAlign="right">
      <uix:include nodeBinding="timeLine@pageSegmentBean@" />
    </uix:cellFormat>
  </uix:rowLayout>
  <uix:rowLayout hAlign="right">
    <uix:cellFormat hAlign="right">
      <uix:image sourceBinding="STATUS_UP" 
                 shortDescBinding="AVAIL_UP@sdkMsg"/>
      <uix:spacer width="2" />
      <uix:styledText textBinding="AVAIL_UP@sdkMsg" 
                 styleClass="OraInstructionText" />            
      <uix:spacer width="10" />
      <uix:image sourceBinding="STATUS_DOWN" 
                 shortDescBinding="AVAIL_DOWN@sdkMsg"/>
      <uix:spacer width="2" />
      <uix:styledText textBinding="AVAIL_DOWN@sdkMsg"
                      styleClass="OraInstructionText"/>
      <uix:spacer width="10" />
      <uix:image sourceBinding="STATUS_BLACKOUT" 
                 shortDescBinding="AVAIL_BLACKOUT@sdkMsg"/>
      <uix:spacer width="2" />
      <uix:styledText textBinding="AVAIL_BLACKOUT@sdkMsg"
                 styleClass="OraInstructionText" />
      <uix:spacer width="10" />
      <uix:image sourceBinding="STATUS_AGENT_DOWN" 
                 shortDescBinding="AVAIL_AGENT_DOWN@sdkMsg"/>
      <uix:spacer width="2" />
      <uix:styledText textBinding="AVAIL_AGENT_DOWN@sdkMsg"
                      styleClass="OraInstructionText"/>
      <uix:spacer width="10" />
      <uix:image sourceBinding="STATUS_ERROR" 
                 shortDescBinding="AVAIL_ERROR@sdkMsg"/>
      <uix:spacer width="2" />
      <uix:styledText textBinding="AVAIL_ERROR@sdkMsg"
                      styleClass="OraInstructionText"/>
      <uix:spacer width="10" />
      <uix:image sourceBinding="STATUS_UNKNOWN"
                 shortDescBinding="AVAIL_UNKNOWN@sdkMsg"/>
      <uix:spacer width="2" />
      <uix:styledText textBinding="AVAIL_UNKNOWN@sdkMsg"
                      styleClass="OraInstructionText" />
    </uix:cellFormat>
  </uix:rowLayout>
  </uix:tableLayout>
 </uix:dataScope>
</oem:pageSegment>
