<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext' %>

<oem:pageSegment>
  <uix:dataScope>
    <uix:bundle name="groupsMsg"
                  class="oracle.sysman.eml.rsc.target.grps.GroupsMsg"/>
    <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
    <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>

    <uix:renderingContext id="renderingContext">
        <oem:setURLEncoder id="renderingContext" />
        <uix:messageBox
            messageBinding="membersTableMessage@servletRequest"
            messageTypeBinding="membersTableMessageType@servletRequest" 
            renderedBinding = "renderMessage@servletRequest"
        />
        <uix:rowLayout width="100%" >
            <uix:cellFormat hAlign="left" >
             <uix:rowLayout >
              <uix:inlineMessage promptBinding="SEARCH@commonResourceBundle" >
                <uix:choice name="searchType"
                            id="searchType"
                            selectedValueBinding="searchType@searchData@servletRequest"
                            shortDescBinding="SEARCH@commonResourceBundle">
                  <uix:contents childDataBinding="targetTypes@searchData@servletRequest" >
                    <uix:option textBinding="text"
                                valueBinding="value" />
                  </uix:contents>
                </uix:choice>
              </uix:inlineMessage>

              <uix:spacer width="20"/>
              <uix:textInput name="searchName"
                             columns="30"
                             textBinding="searchName@searchData@servletRequest" 
                             shortDescBinding="SEARCH@commonResourceBundle"/>

              <uix:spacer width="20"/>
              <uix:submitButton textBinding="GO_BUTTON@mntrResourceBundle" 
                                name="event" 
                                value="searchTargets"
                                shortDescBinding="GO_BUTTON@mntrResourceBundle" />
             </uix:rowLayout >
            </uix:cellFormat >
            <uix:cellFormat hAlign="right" >
              <uix:button 
                textBinding="GROUP_CUSTOMIZE_COLUMNS@groupsMsg"
                destinationBinding="customizeColumnsDestination@"
                shortDescBinding="GROUP_CUSTOMIZE_COLUMNS@groupsMsg"
              />
            </uix:cellFormat >
          </uix:rowLayout >

            <uix:spacer height="10"/>

            <uix:ref refID="GROUP_MEMBERS_TABLE" />
    </uix:renderingContext>
  </uix:dataScope>
</oem:pageSegment>
