<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<oem:pageSegment>

<uix:dataScope>
  <uix:bundle name="mntrMsg"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="sdkMsg"
                  class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="grpMsg"
              class="oracle.sysman.eml.rsc.target.grps.GroupsMsg"/>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>


  <uix:header textBinding="STATUS@mntrMsg">
    <uix:tableLayout width="100%"> 
     <uix:rowLayout hAlign="right">
          <uix:button  styleClass="OraInstructionText"
                   textBinding="statusHistoryText@"  
                   destinationBinding="statusHistoryDest@" 
                   shortDescBinding="statusHistoryText@" />
     </uix:rowLayout>
     <uix:rowLayout  renderedBinding="isRedGroup@grpStatusBean@servletRequest">
       <uix:borderLayout>
          <uix:tableLayout>
            <uix:contents>
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:styledText 
                     textBinding="STATUS@sdkMsg"
                     styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText 
                     textBinding="currentStatus@grpStatusBean@servletRequest"
                     styleClass="OraDataText"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout width="100%" >
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:styledText textBinding="GROUP_MEMBERS@grpMsg"
                      styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat width="2%" />
                <uix:cellFormat hAlign="left">
                  <uix:link textBinding="totalMembers"
                            destinationBinding="memberPage" />
                  <uix:text text=" ( " />
                  <uix:image sourceBinding="STATUS_DOWN" 
                            shortDescBinding="DOWN_STATUS@mntrMsg"
                            renderedBinding="showDown"/>
                  <uix:spacer width="2" renderedBinding="showDown"/>
                  <uix:link textBinding="numberOfDown"
                        destinationBinding="downLink"
                        renderedBinding="showDown"
                        />
                  <uix:spacer width="10" renderedBinding="showDown"/>
                  <uix:image sourceBinding="STATUS_UNKNOWN"
                            shortDescBinding="UNKNOWN_STATUS@mntrMsg"
                            renderedBinding="showUnknown" />
                  <uix:spacer width="2" renderedBinding="showUnknown" />
                  <uix:link textBinding="numberOfUnknown"
                        destinationBinding="unknownLink"
                        renderedBinding="showUnknown"
                        />
                  <uix:spacer width="10" renderedBinding="showUnknown"/>
                  <uix:image sourceBinding="STATUS_BLACKOUT" 
                            shortDescBinding="BLACKOUT_STATUS@mntrMsg"
                            renderedBinding="showBlackout" />
                  <uix:spacer width="2" renderedBinding="showBlackout" />
                  <uix:link textBinding="numberOfBlackout"
                        destinationBinding="blackoutLink"
                        renderedBinding="showBlackout"
                        />
                  <uix:spacer width="10" renderedBinding="showBlackout" />
                  <uix:image sourceBinding="STATUS_UP" 
                            shortDescBinding="UP_STATUS@mntrMsg"
                            renderedBinding="showUp" />
                  <uix:spacer width="2" renderedBinding="showUp" />
                  <uix:link textBinding="numberOfUp"
                        destinationBinding="upLink"
                        renderedBinding="showUp"
                        />            
                  <uix:text text=" )" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:styledText 
                     textBinding="sinceText@grpStatusBean@servletRequest"
                     styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText 
                     textBinding="statusSince@grpStatusBean@servletRequest"
                     styleClass="OraDataText"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:spacer height="3"/>
              </uix:rowLayout>
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:styledText 
                     textBinding="AVAILABILITY_PCT@sdkMsg"
                     styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left" >
                  <uix:styledText 
                     textBinding="availPct@grpStatusBean@servletRequest"
                     styleClassBinding="availPctStyle@grpStatusBean@servletRequest"
                     destinationBinding="availPctDestination@grpStatusBean@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout width="100%">
                <uix:spacer width="1" />
                <uix:spacer width="1" />
                <uix:cellFormat hAlign="left">
                  <uix:messageText tipBinding="LAST_24_HINT@sdkMsg" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:styledText 
                     textBinding="MEMBER_TYPE@grpMsg"
                     styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText 
                     textBinding="memberType@grpStatusBean@servletRequest"
                     styleClass="OraDataText"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:contents>
          </uix:tableLayout>
          <uix:left>
            <uix:image sourceBinding="trafficIconSource@grpStatusBean@servletRequest" 
                       destinationBinding="statusHistoryDest"
                       shortDescBinding="currentStatus@grpStatusBean@servletRequest"/>
         </uix:left>
      </uix:borderLayout>
      </uix:rowLayout>
      <uix:rowLayout >
        <uix:spacer width="10"/>
      </uix:rowLayout>
       <uix:rowLayout >
        <uix:spacer width="10"/>
      </uix:rowLayout>
      <uix:rowLayout renderedBinding="isGroup@grpStatusBean@servletRequest">
        <uix:stackLayout>
        <oem:chart chartType="pieChart"
                    width="360"
                    height="160"
                    shortDescBinding="AVAILABILITY@mntrMsg"
                    pieValuesInLegend="value"
                    showSlicePercentLabels="true"
                    pieSliceColorsBinding="pieChartColors@"
                    backgroundColorBinding="pieChartBackgroundColor@"
                    hideZeroSlices="true">
          <oem:boundChartDataSource chartDataSourceBinding="pieChartData@"/>
          <oem:imageMap imageMapItemsBinding="pieChartImageMap@"/>
          <oem:chartColumn isKey="true"
                    displayLabelBinding="AVAILABILITY@mntrMsg"
                    sourceIndex="0"/>
          <oem:chartColumn displayLabelBinding="TARGETS@mntrMsg"
                    sourceIndex="1"/>
        </oem:chart>
        </uix:stackLayout>
      </uix:rowLayout>
    </uix:tableLayout>
    </uix:header>
  </uix:renderingContext>
  </uix:dataScope>
</oem:pageSegment>

