<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
     <uix:bundle name="mntrResourceBundle"
                 class="oracle.sysman.resources.MntrResourceBundle"/>
     <uix:bundle name="sdkMsg"
                 class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
     <uix:bundle name="groupsMsg"
                 class="oracle.sysman.eml.rsc.target.grps.GroupsMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:rawText>
        <script>
            function setFocus()
            {
                document.getElementsByName("pageType")[0].focus();
            }
        </script>
    </uix:rawText>
    <uix:body onLoad="setFocus();">
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
        <uix:header textBinding="STATUS_HISTORY@mntrResourceBundle">
          <uix:tableLayout width="100%" >
            <uix:rowLayout hAlign="right">
              <uix:cellFormat>
                <uix:form name="statHistForm" method="GET">
                  <uix:rowLayout>
                    <oem:pageRefreshed />
                    <uix:spacer width="4"/>
                    <uix:button styleClass="OraInstructionText" textBinding="REFRESH@sdkMsg"
                          destinationBinding="refreshDestination@servletRequest"
                          shortDescBinding="REFRESH@sdkMsg"/>
                    <uix:spacer width="4"/>
                    <uix:styledText styleClass="OraPromptText" textBinding="VIEWDATA_TEXT@sdkMsg"/>
                    <uix:spacer width="4"/>
                    <uix:choice name="pageType"
                         shortDescBinding="VIEWDATA_TEXT@sdkMsg" selectedValueBinding="selectedViewData@servletRequest" onChange="submitForm(document.forms[0]); return false;">
                      <uix:option textBinding="LAST_DAY@sdkMsg" value="byDay"/>
                      <uix:option textBinding="LAST_WEEK@sdkMsg" value="byWeek"/>
                      <uix:option textBinding="LAST_MONTH@sdkMsg" value="byMonth"/>
                    </uix:choice>
                  </uix:rowLayout>
                </uix:form>
              </uix:cellFormat>
            </uix:rowLayout>
           </uix:tableLayout>
           <uix:form name="availHistoryHGridSegForm" method ="POST">
             <uix:ref refID="GROUPS_AVAIL_HISTORY_SEGMENT"/> 
           </uix:form> 
        </uix:header>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
