<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<% ((com.evermind.server.http.EvermindJSPWriter) out).setCharSet("utf8") ; %> 

<oem:pageSegment>
    <uix:dataScope>
    <uix:bundle name="sdkUIBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg" />
    <uix:bundle name="GroupsMsg" class="oracle.sysman.eml.rsc.target.grps.GroupsMsg"/>
    <uix:stackLayout>
        <uix:ref refID="oracle_sysman_eml_target_grps_GroupsTopoTextViewSegHandler_message_node_ref_ID" />
        <uix:spacer height="15" />
        <uix:rowLayout >
            <uix:inlineMessage promptBinding="SEARCH@sdkUIBundle" >
                <uix:choice name="searchType"
                    id="searchType"
                    selectedValueBinding="searchType@groupsTopoViewSegBean@" shortDescBinding="SEARCH@sdkUIBundle" >
                     <uix:contents>
                        <uix:option textBinding="ALL@GroupsMsg" value="All" />
                        <uix:option textBinding="SOURCE@GroupsMsg" value="Source" />
                        <uix:option textBinding="DESTINATION@GroupsMsg" value="Destination" />
                    </uix:contents>
                </uix:choice>
            </uix:inlineMessage>

            <uix:spacer width="15"/>
            <uix:textInput name="searchName"
                columns="30" onKeyPress="getKey()"
                textBinding="searchName@groupsTopoViewSegBean@" shortDescBinding="SEARCH@sdkUIBundle"/>

            <uix:spacer width="15"/>
            <uix:submitButton textBinding="GO@sdkUIBundle" 
                name="event" value="Go" shortDescBinding="Go" />
        </uix:rowLayout >
        <uix:spacer height="15" />
        <uix:rowLayout hAlign="right" vAlign="top">
            <uix:styledText textBinding="refreshLabel@"
                styleClass="OraPromptText" />
            <uix:spacer width="5" />
        </uix:rowLayout>
        <uix:table name="availableTargetsTable" id="availableTargetsTable" partialRenderMode="self" 
            alternateTextBinding="SEARCH_NAME_NOT_FOUND@mntrResourceBundle" 
            width="100%" blockSize="25" valueBinding="value@groupsTopoViewSegBean@" 
            minValueBinding="minValue@groupsTopoViewSegBean@" 
            maxValueBinding="maxValue@groupsTopoViewSegBean@" 
            formSubmitted="true" 
            showAll="yes"
            summaryBinding="TOPOLOGY_TABLE_SUMMARY@GroupsMsg"	     
            tableDataBinding="tableDataKey@tableData@groupsTopoViewSegBean@" 
            columnFormatsBinding="columnFormats@groupsTopoViewSegBean@" 
            columnHeaderDataBinding="columnHeaderData@groupsTopoViewSegBean@">
            <uix:tableFormat tableBanding="rowBanding"/>
            <uix:columnHeaderStamp>
                <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
            </uix:columnHeaderStamp>
            <uix:contents>
                <uix:styledText textBinding="SourceTargetName" destinationBinding="SourceTargetDestination"/>
                <uix:styledText textBinding= "SourceTargetType" />
                <uix:column>
                    <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                    <uix:contents>
                        <uix:styledText textBinding= "sourceAvailText" shortDescBinding="sourceAvailShortDescText" renderedBinding="showSourceText"/>
                        <uix:image  sourceBinding="sourceAvail"  destinationBinding="sourceAvailDest" shortDescBinding="sourceAvailShortDesc" renderedBinding="showSourceImage"/>
                    </uix:contents>
                </uix:column>
                <uix:styledText textBinding="AssociatedTargetName" destinationBinding="AssociatedTargetDestination"/>
                <uix:styledText textBinding="AssociatedTargetType"/>
                <uix:column>
                    <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                    <uix:contents>
                        <uix:styledText textBinding= "DestinationAvailText" shortDescBinding="destAvailShortDescText" renderedBinding="showDestText"/>
                        <uix:image  sourceBinding="DestinationAvail" shortDescBinding="destAvailShortDesc" destinationBinding="destinationAvailDest" renderedBinding="showDestImage"/>
                    </uix:contents>
                </uix:column>   
            </uix:contents>
        </uix:table>
        <uix:spacer height="20" />
        </uix:stackLayout>
    </uix:dataScope>
</oem:pageSegment>
