<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       multiTarget.jsp 
 *
 *      NOTES
 *       Execute Host Command/Execute SQL main page.
 *
 * MODIFIED
 *    yaofeng    08/22/05 - set auto complete off 
 *    kmckeen    08/30/05 - Bug 4534055 - support cluster targets 
 *    kmckeen    08/25/05 - Support execution confirmation 
 *    kmckeen    05/07/05 - Ada fixes 
 *    kmckeen    05/03/05 - Bug 4332543 - move save checkbox text to message 
 *                          file 
 *    kmckeen    04/08/05 - Handle loading job credentials 
 *    kmckeen    03/08/05 - Handle ppr on return from processing page 
 *    kmckeen    02/14/05 - Make target selector bypass popup blocker 
 *    kmckeen    02/01/05 - Support keeping job persistent across sessions 
 *    kmckeen    01/26/05 - Handle return key in Command field.
 *                          Mark Command and credentails fields as required.
 *                          Add link for switch to single target mode.
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>

<%@ page import="oracle.sysman.eml.PageNames" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>
<%@ page import="oracle.cabo.ui.partial.PartialPageUtils"%>

<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>

<jsp:useBean
    id="multiTargetBean"
    scope="request"
    type="oracle.sysman.eml.target.MultiTargetBean"/>

<script>
 function preLoad()
 {
   document.multiTarget.hostCommandText.focus();

   var isNav = (navigator.appName.indexOf("Netscape") != -1);
   if(isNav)
   {
     document.captureEvents(Event.KEYPRESS);
     document.multiTarget.hostCommandText.onkeypress = getNetscapeKey;
   } 
 }
 function getNetscapeKey(keyStroke)
 {
   key = keyStroke.which;
   if(key == "13")
   {
     submitForm('multiTarget', 0, {'event':'confirmExecute'});
   }
 }            
 function doExecute(isFocus)
 {
   if(isFocus == "1")  
   { 
     if ((window.event.which == 13) ||  
         (window.event.keyCode == 13))
     {
       submitForm('multiTarget', 0, {'event':'confirmExecute'});
     }
   }
 }
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="SDKUIResourceBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="JobsResourceBundle" class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:bundle name="MntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="MultiTargetResourceBundle" class="oracle.sysman.eml.rsc.target.MultiTargetMsg"/>

  <%
  String dest = (String)request.getSession().getAttribute("processingDoneDestination");
  if (dest != null)
  {
    PartialPageUtils.forceRedirectURL(renderingContext, dest);
    request.getSession().removeAttribute("processingDoneDestination");
  }
  %>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body onLoad="preLoad();">

      <uix:contents>
        <uix:form name="multiTarget" method="post">

          <uix:formValue
              name="<%= EmlConstants.PAGE_NAME_PAGE_PROPERTY %>"
              value="<%= PageNames.MULTI_TARGET_PAGE %>"/>

          <uix:pageLayout titleBinding="title@multiTargetBean@servletRequest">

            <%@ include file="/enablePPR.jspf" %>
            <%@ include file="/oemGlobal.jspf" %>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <%--
            <uix:labeledFieldLayout 
                labelWidth="11%"
                renderedBinding="targetTypeRendered@multiTargetBean@servletRequest">
            </uix:labeledFieldLayout>
            --%>
            <uix:messageChoice
                renderedBinding="targetTypeRendered@multiTargetBean@servletRequest"
                name="targetTypeSelectedChoice"
                promptBinding="TARGET_TYPE@SDKUIResourceBundle"
                tipBinding="CHANGE_TARGET_TYPE_TIP@MultiTargetResourceBundle"
                selectedValueBinding="targetTypeSelectedValue@multiTargetBean@servletRequest"
                onChange="submitForm('multiTarget', true, {'event':'changeTargetTypeOK'})"> 
              <uix:contents
                  childDataBinding="targetTypeList@multiTargetBean@servletRequest">
                <uix:option
                    textBinding="targetTypeText"
                    valueBinding="targetTypeValue"/>
              </uix:contents>
            </uix:messageChoice>

            <uix:tableLayout>
              <uix:rowLayout vAlign="top">
<%--
  BEGINNING OF COMMAND/SQL INPUT FIELDS
--%>
                <uix:header textBinding="executeTextHeader@multiTargetBean@servletRequest">

                  <uix:tableLayout width="66%" renderedBinding="sqlControlsRendered@multiTargetBean@servletRequest">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="left">
                      <uix:styledText
                          renderedBinding="sqlControlsRendered@multiTargetBean@servletRequest"
                          styleClass="OraInstructionText"
                          textBinding="INSTRUCTION_TEXT_DB@MultiTargetResourceBundle"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right">
                        <uix:pageButtonBar>
                          <uix:submitButton
                              textBinding="loadButtonText@multiTargetBean@servletRequest"
                              name="event"
                              value="loadFromFile"/>
                        </uix:pageButtonBar>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat vAlign="top" hAlign="left">
                        <uix:stackLayout>
                          <uix:messageTextInput
                              id="SQL"
                              name="sqlText"
                              columns="85"
                              rows="5"
                              shortDescBinding="SQL@MultiTargetResourceBundle"
                              textBinding="sqlText@multiTargetBean@servletRequest"
                              messageBinding="(SQL@MultiTargetResourceBundle)@messages@servletRequest"
                              messageTypeBinding="(SQL@MultiTargetResourceBundle)@messageTypes@servletRequest"/>
                          <uix:checkBox
                              name="resultsPersistentOption"
                              checkedBinding="resultsPersistentOption@multiTargetBean@servletRequest"
                              textBinding="KEEP_HISTORY@MultiTargetResourceBundle"/>
                          <uix:submitButton
                              textBinding="EXECUTE@MultiTargetResourceBundle"
                              name="event"
                              value="confirmExecute"/>
                        </uix:stackLayout>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>

                  <uix:tableLayout width="66%" renderedBinding="hostControlsRendered@multiTargetBean@servletRequest">
                    <uix:rowLayout>
                      <uix:labeledFieldLayout labelWidth="10%">
                        <uix:messageTextInput
                            id="Command"
                            name="hostCommandText"
                            required="uiOnly"
                            columns="71"
                            onKeyPress="doExecute('1');"
                            textBinding="hostCommandText@multiTargetBean@servletRequest"
                            promptBinding="CREATE_JOB_OS_COMMAND@JobsResourceBundle"
                            tipBinding="CREATE_JOB_OS_COMMAND_TIP@JobsResourceBundle"
                            messageBinding="(CREATE_JOB_OS_COMMAND@JobsResourceBundle)@messages@servletRequest"
                            messageTypeBinding="(CREATE_JOB_OS_COMMAND@JobsResourceBundle)@messageTypes@servletRequest"/>
                        <uix:messagePrompt/>
                        <uix:tableLayout width="100%">
                          <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                              <uix:pageButtonBar>
                                <uix:submitButton
                                    textBinding="loadButtonText@multiTargetBean@servletRequest"
                                    name="event"
                                    value="loadFromFile"/>
                              </uix:pageButtonBar>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:tableLayout>
                        <uix:messageTextInput
                            name="hostScriptText"
                            columns="73"
                            rows="5"
                            textBinding="hostScriptText@multiTargetBean@servletRequest"
                            promptBinding="CREATE_JOB_OS_SCRIPT@JobsResourceBundle"
                            tipBinding="OS_SCRIPT_TIP@MultiTargetResourceBundle"
                            messageBinding="(CREATE_JOB_OS_SCRIPT@JobsResourceBundle)@messages@servletRequest"
                            messageTypeBinding="(CREATE_JOB_OS_SCRIPT@JobsResourceBundle)@messageTypes@servletRequest"/>
                        <uix:messagePrompt/>
                        <uix:checkBox
                            name="resultsPersistentOption"
                            checkedBinding="resultsPersistentOption@multiTargetBean@servletRequest"
                            textBinding="KEEP_HISTORY@MultiTargetResourceBundle"/>
                        <uix:messagePrompt/>
                        <uix:submitButton
                            textBinding="EXECUTE@MultiTargetResourceBundle"
                            name="event"
                            value="confirmExecute"/>
                      </uix:labeledFieldLayout>
                    </uix:rowLayout>
                  </uix:tableLayout>

                </uix:header>
<%--
  END OF COMMAND/SQL INPUT FIELDS
--%>

<%--
  BEGINNING OF CREDENTIALS INPUT FIELDS
--%>
                <uix:header
                    textBinding="credHeader@multiTargetBean@servletRequest">
                <%--
                <uix:hideShowHeader 
                    id="credentialsHeader"
                    textBinding="credHeader@multiTargetBean@servletRequest"
                    disclosedBinding="showCredentials@multiTargetBean@servletRequest"
                    formSubmitted="true">
                --%>
                  <uix:tableLayout width="100%" cellSpacing="1">
                    <uix:rowLayout>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:radioButton
                            id="prefCredOptionUsePrefCred"
                            name="prefCredOption"
                            textBinding="USE_PREF_CRED@JobsResourceBundle"
                            selectedValueBinding="prefCredOption@multiTargetBean@servletRequest"
                            onClick="submitForm('multiTarget', true, {'event':'usePrefCredsClicked'})"
                            value="USE_PREF_CRED"/>
                        <uix:radioButton
                            id="prefCredOptionOverridePrefCred"
                            name="prefCredOption"
                            textBinding="OVERRIDE_PREF_CRED@JobsResourceBundle"
                            selectedValueBinding="prefCredOption@multiTargetBean@servletRequest"
                            onClick="submitForm('multiTarget', true, {'event':'overridePrefCredsClicked'})"
                            value="OVERRIDE_PREF_CRED"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:labeledFieldLayout labelWidth="30%">
                        <uix:messageChoice
                            name="prefCredType"
                            renderedBinding="renderPrefCredType@multiTargetBean@servletRequest"
                            promptBinding="PREF_CRED_TYPE@JobsResourceBundle"
                            selectedValueBinding="prefCredType@multiTargetBean@servletRequest">
                          <uix:option
                              value="NORMAL"
                              textBinding="PREF_CRED_LEVEL_NORMAL@JobsResourceBundle"/>
                          <uix:option
                              value="PRIV"
                              textBinding="prefCredPrivText@multiTargetBean@servletRequest"/>
                        </uix:messageChoice>
                        <uix:messageTextInput
                            name="hostUsername"
                            required="uiOnly"
                            renderedBinding="overrideCredClicked@multiTargetBean@servletRequest"
                            columns="20"
                            noAutoComplete="true"           
                            textBinding="hostUsername@multiTargetBean@servletRequest"
                            promptBinding="HOST_USERNAME@JobsResourceBundle"
                            messageBinding="(HOST_USERNAME@JobsResourceBundle)@messages@servletRequest"
                            messageTypeBinding="(HOST_USERNAME@JobsResourceBundle)@messageTypes@servletRequest"/>
                        <uix:messageTextInput
                            name="hostPasswordSecret"
                            required="uiOnly"
                            renderedBinding="overrideCredClicked@multiTargetBean@servletRequest"
                            columns="20"
                            secret="true"
                            noAutoComplete="true"           
                            textBinding="hostPasswordSecret@multiTargetBean@servletRequest"
                            promptBinding="HOST_PASSWORD@JobsResourceBundle"
                            messageBinding="(HOST_PASSWORD@JobsResourceBundle)@messages@servletRequest"
                            messageTypeBinding="(HOST_PASSWORD@JobsResourceBundle)@messageTypes@servletRequest"/>
                        <uix:messageTextInput
                            name="databaseUsername"
                            required="uiOnly"
                            columns="20"
                            noAutoComplete="true"           
                            renderedBinding="databaseCredsRendered@multiTargetBean@servletRequest"
                            textBinding="databaseUsername@multiTargetBean@servletRequest"
                            promptBinding="DATABASE_USERNAME@JobsResourceBundle"
                            messageBinding="(DATABASE_USERNAME@JobsResourceBundle)@messages@servletRequest"
                            messageTypeBinding="(DATABASE_USERNAME@JobsResourceBundle)@messageTypes@servletRequest"/>
                        <uix:messageTextInput
                            name="databasePasswordSecret"
                            required="uiOnly"
                            columns="20"
                            secret="true"
                            noAutoComplete="true"           
                            renderedBinding="databaseCredsRendered@multiTargetBean@servletRequest"
                            textBinding="databasePasswordSecret@multiTargetBean@servletRequest"
                            promptBinding="DATABASE_PASSWORD@JobsResourceBundle"
                            messageBinding="(DATABASE_PASSWORD@JobsResourceBundle)@messages@servletRequest"
                            messageTypeBinding="(DATABASE_PASSWORD@JobsResourceBundle)@messageTypes@servletRequest"/>
                        <uix:messageChoice
                            name="databaseRole"
                            renderedBinding="databaseCredsRendered@multiTargetBean@servletRequest"
                            promptBinding="DATABASE_ROLE@JobsResourceBundle"
                            selectedValueBinding="databaseRole@multiTargetBean@servletRequest">
                          <uix:option
                              value="NORMAL"
                              textBinding="PREF_CRED_LEVEL_NORMAL@JobsResourceBundle"/>
                          <uix:option
                              value="PRIV"
                              text="SYSDBA"/>
                        </uix:messageChoice>
                      </uix:labeledFieldLayout>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:header>

<%--
  END OF CREDENTIALS INPUT FIELDS
--%>

              </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout width="100%">

              <uix:rowLayout>
              <uix:cellFormat hAlign="left">
              <uix:tableLayout width="100%">

              <uix:rowLayout>
                <uix:spacer width="12"/>
                <uix:separator/>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:spacer width="12"/>
                <uix:stackLayout>
                  <uix:borderLayout id="Targets_Table">
                    <uix:left>
                      <uix:switcher 
                          childNameBinding="executionResultsAvailable@multiTargetBean@servletRequest">
                        <uix:case name="false">
                          <uix:styledText
                              styleClass="OraInstructionText"
                              textBinding="willBeExecutedInfo@multiTargetBean@servletRequest"/>
                        </uix:case>
                        <uix:case name="true">
                          <uix:borderLayout>
                            <uix:left>
                              <uix:labeledFieldLayout 
                                  renderedBinding="executionResultsAvailable@multiTargetBean@servletRequest"
                                  labelWidth="10%" columns="2">
                                <uix:messageStyledText
                                    contentStyleClass="OraDataText"
                                    promptBinding="SUCCEEDED@MultiTargetResourceBundle"
                                    textBinding="numSucceeded@multiTargetBean@servletRequest"/>
                                <uix:messageStyledText
                                    contentStyleClass="OraDataText"
                                    promptBinding="FAILED@MultiTargetResourceBundle"
                                    textBinding="numFailed@multiTargetBean@servletRequest"/>
                              </uix:labeledFieldLayout>
                            </uix:left>
                            <uix:right>
                              <uix:labeledFieldLayout 
                                  renderedBinding="executionResultsAvailable@multiTargetBean@servletRequest"
                                  labelWidth="10%" columns="1">
                                <uix:messageStyledText
                                    contentStyleClass="OraDataText"
                                    promptBinding="EXECUTED@MultiTargetResourceBundle"
                                    textBinding="formattedExecuteDate@multiTargetBean@servletRequest"/>
                              </uix:labeledFieldLayout>
                            </uix:right>
                          </uix:borderLayout>
                        </uix:case>
                      </uix:switcher>
                    </uix:left>
                    <uix:right>
                      <uix:tableLayout width="100%">
                        <uix:rowLayout hAlign="right">
                          <uix:cellFormat wrappingDisabled="true">
                            <uix:pageButtonBar>
                              <uix:submitButton
                                  renderedBinding="executionResultsAvailable@multiTargetBean@servletRequest"
                                  textBinding="SAVE_RESULTS@MultiTargetResourceBundle"
                                  name="event"
                                  value="saveResults"/>
                              <oem:targetSelection
                                  textBinding="ADD@SDKUIResourceBundle"/>
                            </uix:pageButtonBar>
                          </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:tableLayout>
                    </uix:right>
                  </uix:borderLayout>

                  <uix:dataScope
                      currentDataBinding="multiTargetTable@multiTargetBean@servletRequest">

                    <uix:table
                        id="Targets"
                        name="multiTargetTable" 
                        formSubmitted="true"
                        partialRenderMode="multiple"
                        partialTargets="SwitchToSimpleBlock"
                        minValue="1"
                        showAll="yes"
                        width="100%"
                        summaryBinding="EXECUTION_RESULTS@MultiTargetResourceBundle"
                        allDetailsEnabledBinding="renderShowAllHideAllDetailsLinks"
                        detailDisclosureBinding="detailDisclosureList"
                        tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                        valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                        maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                        blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                        alternateTextBinding="NO_TARGETS_FOUND@MultiTargetResourceBundle">

                      <uix:detail>
                        <uix:tableLayout width="100%">
                          <uix:rowLayout>
                            <uix:cellFormat hAlign="left">
                              <uix:rawText text="<pre>"/>
                                <uix:text
                                    textBinding="results"/>
                              <uix:rawText text="</pre>"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout renderedBinding="renderDetailsColumnShowMore">
                            <uix:cellFormat hAlign="left">
                              <uix:styledText
                                  text=". . ."
                                  shortDescBinding="RESULTS_TRUNCATED@MultiTargetResourceBundle"
                                  styleClass="OraInstructionTextStrong"/>
                              <uix:spacer width="20"/>
                              <uix:link
                                  textBinding="COMPLETE_EXECUTION_RESULTS@MultiTargetResourceBundle"
                                  destinationBinding="detailsColumnShowMoreDestination"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:detail>

                      <%-- Database column - only displayed with Execute SQL --%>
                      <uix:column renderedBinding="renderDatabaseColumn">
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="NAME@SDKUIResourceBundle"
                              sortableBinding="databaseColumnSortable"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:messageStyledText
                            textBinding="databaseColumn"
                            destinationBinding="databaseColumnDestination"
                            messageBinding="databaseColumnMessage"
                            messageTypeBinding="databaseColumnMessageType">
                        </uix:messageStyledText>
                      </uix:column>

                      <%-- Target Type column - only displayed with Execute SQL --%>
                      <uix:column renderedBinding="renderDatabaseColumn">
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="TYPE@MultiTargetResourceBundle"
                              sortableBinding="targetTypeColumnSortable"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:messageStyledText
                            textBinding="targetTypeColumn">
                        </uix:messageStyledText>
                      </uix:column>

                      <%-- Host column - always displayed --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="HOST@MultiTargetResourceBundle"
                              sortableBinding="hostColumnSortable"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:messageStyledText
                            textBinding="hostColumn"
                            destinationBinding="hostColumnDestination"
                            messageBinding="hostColumnMessage"
                            messageTypeBinding="hostColumnMessageType">
                        </uix:messageStyledText>
                      </uix:column>

                      <%-- Execution Status column - always displayed --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="EXECUTION_STATUS@MultiTargetResourceBundle"
                              sortableBinding="executionStatusColumnSortable"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                        <uix:image
                            shortDescBinding="executionStatusColumn"
                            sourceBinding="executionStatusColumnIcon"
                            destinationBinding="executionStatusColumnDestination"
                            textBinding="NO_EXECUTION_CONDUCTED@MultiTargetResourceBundle"/>
                      </uix:column>

                      <%-- Elapsed Time column - always displayed --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="EXEC_TABLE_RUNNING_TIME_COLUMN@JobsResourceBundle"
                              sortableBinding="elapsedTimeColumnSortable"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="numberFormat"/>
                        <uix:messageStyledText
                            textBinding="elapsedTimeColumn">
                        </uix:messageStyledText>
                      </uix:column>

                      <%-- Remove column - always displayed --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="REMOVE@SDKUIResourceBundle"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                        <uix:image
                            shortDescBinding="REMOVE@SDKUIResourceBundle"
                            sourceBinding="removeColumnIcon"
                            onClickBinding="removeColumnDestination"/>
                      </uix:column>

                    </uix:table>
                  </uix:dataScope>

                  <uix:messageText
                      messageBinding="(TARGETS_TABLE@MultiTargetResourceBundle)@messages@servletRequest"
                      messageTypeBinding="(TARGETS_TABLE@MultiTargetResourceBundle)@messageTypes@servletRequest"/>

                </uix:stackLayout>
              </uix:rowLayout>

              </uix:tableLayout>
              </uix:cellFormat>
              </uix:rowLayout>

              <%--
                For partial page refresh to include both the targets table above
                and the Switch To Simple Mode link here, each must be within the
                same <tableLayout> tag.  We need partial page refresh to include
                the link here, because it is rendered or not based on the target
                type (host or cluster) of the first target in the table.
                
                Search for SwitchToSimpleBlock to see it used with the <table>
                tag above.  This how we tell UIX to refresh the link here when
                the targets table is refreshed (sorted for example).
                
                We had to add <cellFormat> and additional <tableLayout> tags in
                order to properly layout and indent the target table and the
                link here.
              --%>
              <uix:rowLayout id="SwitchToSimpleBlock">
                <uix:cellFormat hAlign="left">
                  <uix:tableLayout width="100%"
                      renderedBinding="switchToSimpleRendered@multiTargetBean@servletRequest">
                    <uix:rowLayout> 
                      <uix:spacer width="12"/>
                      <uix:link
                          textBinding="SWITCH_TO_SIMPLE_LINK@MultiTargetResourceBundle"
                          destinationBinding="switchToSimpleURL@multiTargetBean@servletRequest"/>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:spacer width="12"/>
                      <uix:tip>
                        <uix:styledText
                            styleClass="OraTipText"
                            textBinding="SWITCH_TO_SIMPLE_TIP@MultiTargetResourceBundle"/>
                      </uix:tip>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
              </uix:rowLayout>

            </uix:tableLayout>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    textBinding="EXECUTION_HISTORY@MultiTargetResourceBundle"
                    name="event"
                    value="history"/>
                <uix:submitButton 
                    textBinding="LOAD_FROM_JOB_LIBRARY@MultiTargetResourceBundle"
                    name="event"
                    value="loadFromJobLibrary"/>
                <%--
                <uix:submitButton
                    textBinding="JOBS_TABLE_CREATE@JobsResourceBundle"
                    name="event"
                    value="createJob"/>
                --%>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
