<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       multiTargetConfirm.jsp 
 *
 *      NOTES
 *       Execute Host Command/Execute SQL confirm execution page.
 *
 * MODIFIED
 *    kmckeen    08/25/05 - kmckeen_bug-4574522
 *    kmckeen    08/25/05 - Initial creation of module 
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>

<jsp:useBean
    id="multiTargetBean"
    scope="request"
    type="oracle.sysman.eml.target.MultiTargetBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="SDKUIResourceBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="JobsResourceBundle" class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:bundle name="MntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="MultiTargetResourceBundle" class="oracle.sysman.eml.rsc.target.MultiTargetMsg"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:contents>
        <uix:form name="multiTargetConfirm" method="post">

          <uix:formValue
              name="<%= EmlConstants.PAGE_NAME_PAGE_PROPERTY %>"
              value="target/multiTargetConfirm"/>

          <uix:pageLayout 
              titleBinding="CONFIRMATION@SDKUIResourceBundle"
              messageType="confirmation">

            <%@ include file="/oemGlobal.jspf" %>

            <uix:labeledFieldLayout labelWidth="20%" width="100%">
              <uix:messageStyledText
                  renderedBinding="sqlControlsRendered@multiTargetBean@servletRequest"
                  contentStyleClass="OraDataText"
                  promptBinding="mainPageTitle@multiTargetBean@servletRequest"
                  textBinding="sqlText@multiTargetBean@servletRequest"/>
              <uix:messageStyledText
                  renderedBinding="hostControlsRendered@multiTargetBean@servletRequest"
                  contentStyleClass="OraDataText"
                  promptBinding="mainPageTitle@multiTargetBean@servletRequest"
                  textBinding="hostCommandText@multiTargetBean@servletRequest"/>
              <uix:messageStyledText
                  renderedBinding="hostControlsRendered@multiTargetBean@servletRequest"
                  contentStyleClass="OraDataText"
                  promptBinding="CREATE_JOB_OS_SCRIPT@JobsResourceBundle"
                  textBinding="hostScriptText@multiTargetBean@servletRequest"/>
              <uix:messageStyledText
                  contentStyleClass="OraDataText"
                  promptBinding="CREATE_JOB_CREDENTIALS_LINK@JobsResourceBundle"
                  textBinding="confirmPageCredentialsText@multiTargetBean@servletRequest"/>
              <uix:messageStyledText
                  contentStyleClass="OraDataText"
                  promptBinding="TARGETS@MultiTargetResourceBundle"
                  textBinding="confirmPageTargetsList@multiTargetBean@servletRequest"/>
            </uix:labeledFieldLayout>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    textBinding="NO@SDKUIResourceBundle"
                    name="event"
                    value="return"/>
                <uix:submitButton
                    textBinding="YES@SDKUIResourceBundle"
                    name="event"
                    value="execute"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
