<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       multiTargetHistory.jsp 
 *
 *      NOTES
 *       Execute Host Command/Execute SQL Execution History page.
 *
 * MODIFIED
 *    kmckeen    05/13/05 - Bug 4332549 - Add Keep column 
 *    kmckeen    05/07/05 - Ada fixes 
 *    kmckeen    05/02/05 - Work with column widths 
 *    kmckeen    02/01/05 - Support keeping job persistent across sessions 
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>

<%@ page import="oracle.sysman.eml.PageNames" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>

<jsp:useBean
    id="multiTargetBean"
    scope="request"
    type="oracle.sysman.eml.target.MultiTargetBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="SDKUIResourceBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="JobsResourceBundle" class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:bundle name="MntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="MultiTargetResourceBundle" class="oracle.sysman.eml.rsc.target.MultiTargetMsg"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:contents>
        <uix:form name="multiTargetHistory" method="post">

          <uix:formValue
              name="<%= EmlConstants.PAGE_NAME_PAGE_PROPERTY %>"
              value="<%= PageNames.MULTI_TARGET_HISTORY_PAGE %>"/>

          <uix:pageLayout titleBinding="EXECUTION_HISTORY@MultiTargetResourceBundle">

            <%@ include file="/enablePPR.jspf" %>
            <%@ include file="/oemGlobal.jspf" %>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:pageStatus>
              <uix:styledText
                  styleClass="OraInstructionText"
                  textBinding="historyTip@multiTargetBean@servletRequest"/>
            </uix:pageStatus>

            <uix:dataScope
                currentDataBinding="multiTargetHistoryTable@multiTargetBean@servletRequest">

              <uix:table
                  id="multiTargetHistoryTable"
                  name="multiTargetHistoryTable" 
                  formSubmitted="true"
                  minValue="1"
                  showAll="yes"
                  width="100%"
                  summaryBinding="COMMANDS_EXECUTED@MultiTargetResourceBundle"
                  tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                  valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                  maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                  blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                  alternateTextBinding="NO_HISTORY@MultiTargetResourceBundle">

                <uix:tableFormat tableBanding="rowBanding"/>

                <%-- Command column --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader 
                        textBinding="commandColumnHeader"
                        sortableBinding="commandColumnSortable"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="commandColumnData" truncateAt="300"/>
                </uix:column>

                <%-- OS Script column --%>
                <uix:column renderedBinding="osScriptColumnRendered">
                  <uix:columnHeader>
                    <uix:sortableHeader 
                        textBinding="CREATE_JOB_OS_SCRIPT@JobsResourceBundle"
                        sortableBinding="osScriptColumnSortable"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="osScriptColumnData" truncateAt="300"/>
                </uix:column>

                <%-- Executed column --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader 
                        textBinding="EXECUTED@MultiTargetResourceBundle"
                        sortableBinding="executedColumnSortable"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="executedColumnData"/>
                </uix:column>

                <%-- Keep column --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader 
                        textBinding="KEEP@MultiTargetResourceBundle"
                        sortableBinding="keepColumnSortable"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="keepColumnData"/>
                </uix:column>

                <%-- Load column - always displayed --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader 
                        textBinding="LOAD@MultiTargetResourceBundle"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                  <uix:image
                      shortDescBinding="LOAD_HOVER_TEXT@MultiTargetResourceBundle"
                      sourceBinding="loadColumnIcon"
                      onClickBinding="loadColumnDestination"/>
                </uix:column>

                <%-- Load Command Only column - always displayed --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader 
                        textBinding="loadCommandOnlyColumnHeader"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                  <uix:image
                      shortDescBinding="loadCommandOnlyColumnHeader"
                      sourceBinding="loadCommandOnlyColumnIcon"
                      onClickBinding="loadCommandOnlyColumnDestination"/>
                </uix:column>

                <%-- Remove column - always displayed --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader 
                        textBinding="REMOVE@SDKUIResourceBundle"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                  <uix:image
                      shortDescBinding="REMOVE@SDKUIResourceBundle"
                      sourceBinding="removeColumnIcon"
                      onClickBinding="removeColumnDestination"/>
                </uix:column>

              </uix:table>

              <uix:switcher childNameBinding="osScriptColumnRendered">
                <uix:case name="true">
                  <uix:tip>
                    <uix:styledText
                        styleClass="OraTipText"
                        textBinding="KEEP_TIP_CMD@MultiTargetResourceBundle"/>
                  </uix:tip>
                </uix:case>
                <uix:case name="false">
                  <uix:tip>
                    <uix:styledText
                        styleClass="OraTipText"
                        textBinding="KEEP_TIP_SQL@MultiTargetResourceBundle"/>
                  </uix:tip>
                </uix:case>
              </uix:switcher>

            </uix:dataScope>

            <uix:pageButtons>
              <uix:dataScope
                  currentDataBinding="multiTargetHistoryTable@multiTargetBean@servletRequest">
                <uix:pageButtonBar>
                  <uix:submitButton
                      renderedBinding="renderRemoveAllButton"
                      textBinding="REMOVE_ALL@JobsResourceBundle"
                      name="event"
                      value="removeHistoryAll"/>
                  <uix:submitButton
                      textBinding="RETURN_BUTTON@MntrResourceBundle"
                      name="event"
                      value="return"/>
                </uix:pageButtonBar>
              </uix:dataScope>
            </uix:pageButtons>

          </uix:pageLayout>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
