<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       multiTargetLoadFromFile.jsp 
 *
 *      NOTES
 *       Execute Host Command/Execute SQL, Load From File page.
 *
 * MODIFIED
 *    kmckeen    05/07/05 - Ada fixes 
 *    kmckeen    02/14/05 - Change rfs alert to submitForm 
 *    kmckeen    01/26/05 - Support load from remote file.
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>

<%@ page import="oracle.sysman.eml.PageNames" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>

<jsp:useBean
    id="multiTargetBean"
    scope="request"
    type="oracle.sysman.eml.target.MultiTargetBean"/>

<script language="JavaScript">
  <%@ include file="/cabo/jsLibs/TableProxy.js" %>
</script>

<script>
 function myCallBack(lovWindow, event)
 {
   return true;
 }
 function launchRfs()
 {
   var host = document.multiTargetLoadFromFile.loadFromFileHost.value;
   host = ";" + trim(host) + ";";
   var hostsArray = document.multiTargetLoadFromFile.hostsTable.value;
   var hostInArray = false;

   if (host != ";;")
   {
     if (hostsArray.indexOf(host) != -1)
     {
       hostInArray = true;
     }
   }

   var remoteFileSelectorURL = document.multiTargetLoadFromFile.remoteFileSelectorURL.value;
   if (hostInArray == true && remoteFileSelectorURL != "")
   {
     openWindow(window, '../page/rfs/postBackWithEvent', 'lovWindow', {width:750, height:550}, true, 'dialog', myCallBack);
   }
   else
   {
     //alert(document.multiTargetLoadFromFile.unknownHostErrorMsg.value);
     submitForm('multiTargetLoadFromFile', false, {event:'unknownHostError'});
   }
 }

 function trim(value)
 {
   value = value.replace( /^\s+/g, "" );// trim leading
   return value.replace( /\s+$/g, "" );// trim trailing
 }
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="SDKUIResourceBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="JobsResourceBundle" class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:bundle name="MntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="MultiTargetResourceBundle" class="oracle.sysman.eml.rsc.target.MultiTargetMsg"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:contents>
        <uix:form 
            name="multiTargetLoadFromFile" 
            usesUpload="true"
            method="post">

          <uix:formValue
              name="<%= EmlConstants.PAGE_NAME_PAGE_PROPERTY %>"
              value="<%= PageNames.MULTI_TARGET_LOAD_FROM_FILE_PAGE %>"/>

          <uix:formValue 
              name="remoteFileSelectorURL" 
              valueBinding="remoteFileSelectorURL@multiTargetBean@servletRequest"/>

          <uix:formValue 
              name="hostsTable" 
              valueBinding="hostsTable@multiTargetBean@servletRequest"/>

          <uix:formValue 
              name="unknownHostErrorMsg" 
              valueBinding="unknownHostErrorMsg@multiTargetBean@servletRequest"/>

          <uix:pageLayout titleBinding="loadTitle@multiTargetBean@servletRequest">

            <%@ include file="/enablePPR.jspf" %>
            <%@ include file="/oemGlobal.jspf" %>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <%-- cannot save browser file name --%>
            <uix:radioButton
                name="loadFromFileOption"
                value="LOAD_FROM_BROWSER"
                textBinding="FILE_ON_BROWSER@MultiTargetResourceBundle"
                selectedValueBinding="loadFromFileOption@multiTargetBean@servletRequest"
                onClick="submitForm('multiTarget', true, {'event':'loadFromBrowserClicked'})"/>
            <uix:labeledFieldLayout labelWidth="10%">
              <uix:messageFileUpload
                  id="fileOnBrowser"
                  name="fileOnBrowser"
                  columns="80"
                  promptBinding="BROWSER_FILE@MultiTargetResourceBundle"
                  messageBinding="(BROWSER_FILE@MultiTargetResourceBundle)@messages@servletRequest"
                  messageTypeBinding="(BROWSER_FILE@MultiTargetResourceBundle)@messageTypes@servletRequest"/>
            </uix:labeledFieldLayout>

            <uix:radioButton
                name="loadFromFileOption"
                value="LOAD_FROM_HOST"
                textBinding="FILE_ON_HOST@MultiTargetResourceBundle"
                disabledBinding="disableLoadFromHostControls@multiTargetBean@servletRequest"
                selectedValueBinding="loadFromFileOption@multiTargetBean@servletRequest"
                onClick="submitForm('multiTarget', true, {'event':'loadFromHostClicked'})"/>
            <uix:labeledFieldLayout labelWidth="10%">
              <uix:messageLovInput
                  id="loadFromFileHost"
                  name="loadFromFileHost"
                  columns="80"
                  searchDescBinding="CLICK_TO_SELECT_HOST@MultiTargetResourceBundle"
                  disabledBinding="disableLoadFromHostControls@multiTargetBean@servletRequest"
                  promptBinding="HOST@MultiTargetResourceBundle"
                  textBinding="loadFromFileHost@multiTargetBean@servletRequest"
                  destinationBinding="loadFromFileHostLOVDest@multiTargetBean@servletRequest"
                  messageBinding="(HOST@MultiTargetResourceBundle)@messages@servletRequest"
                  messageTypeBinding="(HOST@MultiTargetResourceBundle)@messageTypes@servletRequest"/>
              <uix:messageLovField
                  id="fileOnHost"
                  name="fileOnHost"
                  columns="80"
                  onClick="launchRfs();"
                  searchDescBinding="CLICK_TO_SELECT_FILE@MultiTargetResourceBundle"
                  disabledBinding="disableLoadFromHostControls@multiTargetBean@servletRequest"
                  promptBinding="HOST_FILE@MultiTargetResourceBundle"
                  textBinding="fileOnHost@multiTargetBean@servletRequest"
                  messageBinding="(HOST_FILE@MultiTargetResourceBundle)@messages@servletRequest"
                  messageTypeBinding="(HOST_FILE@MultiTargetResourceBundle)@messageTypes@servletRequest"/>
            </uix:labeledFieldLayout>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    textBinding="CANCEL@SDKUIResourceBundle"
                    name="event"
                    value="return"/>
                <uix:submitButton
                    textBinding="LOAD@MultiTargetResourceBundle"
                    name="event"
                    value="loadFromFileOK"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
