<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       multiTargetLoadFromJobLibrary.jsp 
 *
 *      NOTES
 *       Execute Host Command/Execute SQL, Load From Job Library page.
 *
 * MODIFIED
 *    kmckeen    05/07/05 - Ada fixes 
 *    kmckeen    05/03/05 - Bug 4332579 - move search component outside of 
 *                          table 
 *    kmckeen    01/27/05 - Change search label.
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>

<%@ page import="oracle.sysman.eml.PageNames" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>

<jsp:useBean
    id="multiTargetBean"
    scope="request"
    type="oracle.sysman.eml.target.MultiTargetBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="SDKUIResourceBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="JobsResourceBundle" class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:bundle name="MntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="MultiTargetResourceBundle" class="oracle.sysman.eml.rsc.target.MultiTargetMsg"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:contents>
        <uix:form name="multiTargetLoadFromJobLibrary" method="post">

          <uix:formValue
              name="<%= EmlConstants.PAGE_NAME_PAGE_PROPERTY %>"
              value="<%= PageNames.MULTI_TARGET_LOAD_FROM_JOB_LIBRARY_PAGE %>"/>

          <uix:pageLayout titleBinding="LOAD_FROM_JOB_LIBRARY@MultiTargetResourceBundle">

            <%@ include file="/enablePPR.jspf" %>
            <%@ include file="/oemGlobal.jspf" %>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:pageStatus>
              <uix:styledText
                  styleClass="OraInstructionText"
                  textBinding="loadFromJobLibraryTip@multiTargetBean@servletRequest"/>
            </uix:pageStatus>

            <%--<%@ include file="/jobs/libraryTable.jspf" %>--%>

            <%--
            <uix:header textBinding="JOBS_ADV_SEARCH_HEADER@JobsResourceBundle">
              <uix:labeledFieldLayout labelWidth="0%" fieldWidth="0%">
                <uix:messageTextInput 
                    name="filterName"
                    promptBinding="JOBS_TABLE_FILTER_NAME@JobsResourceBundle"
                    columns="20"
                    textBinding="filterName@servletRequest"/>
                <uix:messagePrompt/>
                <uix:submitButton 
                    name="event" 
                    value="doJobFilter" 
                    textBinding="JOBS_TABLE_GO_BUTTON@JobsResourceBundle"/>
              </uix:labeledFieldLayout>

            <uix:separator/>
            --%>

            <uix:rowLayout width="100%">  
              <uix:cellFormat 
                  hAlign="left" 
                  vAlign="middle"
                  wrappingDisabled="true">
                <uix:rowLayout>
                  <uix:messageTextInput 
                      name="filterName"
                      promptBinding="SEARCH@JobsResourceBundle"
                      columns="50"
                      textBinding="filterName@multiTargetBean@servletRequest">
                  </uix:messageTextInput>
                  <uix:spacer width="3"/>
                  <uix:submitButton 
                      name="event" 
                      value="filterJobsUsingName" 
                      textBinding="JOBS_TABLE_GO_BUTTON@JobsResourceBundle"/>
                </uix:rowLayout>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:spacer height="2"/>
            </uix:rowLayout>

            <uix:dataScope
                currentDataBinding="multiTargetJobsTable@multiTargetBean@servletRequest">

              <uix:table
                  id="multiTargetJobsTable"
                  name="multiTargetJobsTable" 
                  formSubmitted="true"
                  minValue="1"
                  showAll="yes"
                  width="100%"
                  summaryBinding="LIBRARY_JOBS@MultiTargetResourceBundle"
                  tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                  valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                  maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                  blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                  alternateTextBinding="NO_JOBS_IN_JOB_LIBRARY@MultiTargetResourceBundle">

                <uix:tableFormat tableBanding="rowBanding"/>

                <%--
                <uix:tableFilter>
                  <uix:labeledFieldLayout labelWidth="0%" fieldWidth="0%">
                    <uix:messageTextInput 
                        name="filterName"
                        promptBinding="SEARCH@JobsResourceBundle"
                        columns="50"
                        textBinding="filterName">
                      <uix:end>
                        <uix:submitButton 
                            name="event" 
                            value="filterJobsUsingName" 
                            textBinding="JOBS_TABLE_GO_BUTTON@JobsResourceBundle"/>
                      </uix:end>
                    </uix:messageTextInput>
                  </uix:labeledFieldLayout>
                </uix:tableFilter>
                --%>

                <%-- job name column --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader 
                        textBinding="JOBS_TABLE_HEADER_NAME@JobsResourceBundle"
                        sortableBinding="jobNameColumnSortable"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText
                      textBinding="jobNameColumnData"
                      destinationBinding="jobNameColumnDestination"/>
                </uix:column>

                <%-- job type column --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader 
                        textBinding="JOBS_TABLE_HEADER_JOB_TYPE@JobsResourceBundle"
                        sortableBinding="jobTypeColumnSortable"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="jobTypeColumnData"/>
                </uix:column>

                <%-- num targets column --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader 
                        textBinding="JOBS_TABLE_HEADER_TARGET@JobsResourceBundle"
                        sortableBinding="numTargetsColumnSortable"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="numberFormat"/>
                  <uix:styledText textBinding="numTargetsColumnData"/>
                </uix:column>

                <%-- target type column --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader 
                        textBinding="JOBS_TABLE_HEADER_TARGET_TYPE@JobsResourceBundle"
                        sortableBinding="targetTypeColumnSortable"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="targetTypeColumnData"/>
                </uix:column>

                <%-- Load column - always displayed --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader 
                        textBinding="LOAD@MultiTargetResourceBundle"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                  <uix:image
                      shortDescBinding="LOAD@MultiTargetResourceBundle"
                      sourceBinding="loadColumnIcon"
                      onClickBinding="loadColumnDestination"/>
                </uix:column>

                <%-- job id column --%>
                <%--
                <uix:column renderedBinding="renderJobIDColumn">
                  <uix:columnHeader>
                    <uix:sortableHeader 
                        textBinding="jobIDColumnHeader"
                        sortableBinding="jobIDColumnSortable"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="jobIDColumnData"/>
                </uix:column>
                --%>

              </uix:table>
            </uix:dataScope>

            <uix:pageButtons>
              <uix:dataScope
                  currentDataBinding="multiTargetJobsTable@multiTargetBean@servletRequest">
                <uix:pageButtonBar>
                  <uix:submitButton
                      textBinding="RETURN_BUTTON@MntrResourceBundle"
                      name="event"
                      value="return"/>
                </uix:pageButtonBar>
              </uix:dataScope>
            </uix:pageButtons>

          </uix:pageLayout>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
