<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       multiTargetProcessing.jsp 
 *
 *      NOTES
 *       Execute Host Command/Execute SQL process-in-progress page.
 *
 * MODIFIED
 *    kmckeen    04/07/05 - Considered removing cancel msg, did not
 *    kmckeen    03/26/05 - Continue work on partial page refresh 
 *    kmckeen    03/08/05 - Add id and remove formValue to fix ppr 
 *                          Get refresh rate from bean
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.PageNames" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>

<jsp:useBean
    id="multiTargetBean"
    scope="request"
    type="oracle.sysman.eml.target.MultiTargetBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="MultiTargetResourceBundle" class="oracle.sysman.eml.rsc.target.MultiTargetMsg"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:contents>
        <uix:form name="multiTargetProcessing" method="post">

          <uix:formValue
              name="<%= EmlConstants.PAGE_NAME_PAGE_PROPERTY %>"
              value="<%= PageNames.MULTI_TARGET_PROC_PAGE %>"/>

          <uix:pageLayout>
            <%@ include file="/enablePPR.jspf" %>
            <%@ include file="/oemGlobal.jspf" %>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:header
                textBinding="procPageHeader@multiTargetBean@servletRequest"
                icon="/em/images/processl.gif">

              <uix:borderLayout>
                <uix:left>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="procPageInstrWait@multiTargetBean@servletRequest"/>
                </uix:left>
                <uix:right>
                  <uix:tableLayout width="100%">
                    <uix:rowLayout hAlign="right">
                      <uix:submitButton
                          name="event"
                          value="cancelProcessing"
                          textBinding="CANCEL@MultiTargetResourceBundle"/>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:right>
              </uix:borderLayout>

              <uix:tableLayout width="100%" hAlign="center">

                <uix:rowLayout>
                  <uix:borderLayout>
                  <uix:left>
                    <uix:styledText
                        styleClass="OraInstructionText"
                        textBinding="procPageInstrCancel@multiTargetBean@servletRequest"/>
                  </uix:left>
                  </uix:borderLayout>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:spacer height="20"/>
                </uix:rowLayout>

                <uix:rowLayout hAlign="center">
                  <uix:cellFormat hAlign="center">
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:processing
                            id="executeProcessingControl"
                            timeIntervalBinding="refreshRate@multiTargetBean@servletRequest">
                          <uix:contents>
                            <uix:labeledFieldLayout labelWidth="25%">
                              <uix:contents>
                                <uix:messageStyledText
                                    promptBinding="SUCCEEDED@MultiTargetResourceBundle"
                                    styleClass="OraDataText"
                                    textBinding="numSucceeded@multiTargetBean@servletRequest"/>
                                <uix:messageStyledText
                                    promptBinding="FAILED@MultiTargetResourceBundle"
                                    styleClass="OraDataText"
                                    textBinding="numFailed@multiTargetBean@servletRequest"/>
                                <uix:messageStyledText
                                    promptBinding="REMAINING@MultiTargetResourceBundle"
                                    styleClass="OraDataText"
                                    textBinding="numRemainingForDisplay@multiTargetBean@servletRequest"/>
                              </uix:contents>
                            </uix:labeledFieldLayout>
                          </uix:contents>
                        </uix:processing>
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:rowLayout>

              </uix:tableLayout>
            </uix:header>

            <uix:contentFooter>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="cancelProcessing"
                    textBinding="CANCEL@MultiTargetResourceBundle"/>
              </uix:pageButtonBar>
            </uix:contentFooter>

          </uix:pageLayout>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
