<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       multiTargetSelectHost.jsp 
 *
 *      NOTES
 *       Execute Host Command/Execute SQL, Load From File, remote
 *       file option, select host LOV page.
 *
 * MODIFIED
 *    kmckeen    05/07/05 - Ada fixes 
 *    kmckeen    03/07/05 - Fix select host bugs 
 *    kmckeen    01/28/05 - kmckeen_multi-target19
 *    kmckeen    01/26/05 - Initial creation of module.
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>

<%@ page import="oracle.sysman.eml.PageNames" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>

<jsp:useBean
    id="multiTargetBean"
    scope="request"
    type="oracle.sysman.eml.target.MultiTargetBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="MultiTargetResourceBundle" class="oracle.sysman.eml.rsc.target.MultiTargetMsg"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="selectHostTitle@multiTargetBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <%-- Cannot use the form tag with the listOfValues tag (though
          -- it is ok to use the formValue tag).  The error encountered
          -- when using the form tag with the listOfValues tag is:
          -- "cannot nest form elements"
        <uix:form name="foo" method="post" destinationBinding="destination@selectSchemaBean@servletRequest">
        --%>
        <uix:listOfValues
            titleBinding="HOST@MultiTargetResourceBundle"
            shortDescBinding="HOST@MultiTargetResourceBundle"
            searchTextBinding="selectHostSearchCriteria@multiTargetBean@servletRequest">

          <uix:formValue
              name="<%= EmlConstants.PAGE_NAME_PAGE_PROPERTY %>"
              value="<%= PageNames.MULTI_TARGET_SELECT_HOST_PAGE %>"/>

          <uix:searchInstructions>
            <uix:styledText 
                styleClass="OraInstructionText"
                textBinding="SELECT_HOST_INSTR@MultiTargetResourceBundle"/>
          </uix:searchInstructions>

          <uix:contents>

            <uix:dataScope
                currentDataBinding="multiTargetHostsTable@multiTargetBean@servletRequest">

              <uix:table
                  id="Targets"
                  name="multiTargetHostsTable" 
                  formSubmitted="true"
                  partialRenderMode="self"
                  minValue="1"
                  showAll="yes"
                  width="100%"
                  summaryBinding="HOSTS@MultiTargetResourceBundle"
                  tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                  valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                  maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                  blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                  alternateTextBinding="NO_HOSTS@MultiTargetResourceBundle">

                <%-- Host column - always displayed --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader 
                        textBinding="HOST@MultiTargetResourceBundle"
                        sortableBinding="hostColumnSortable"/>
                    </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:messageStyledText
                      textBinding="hostColumn"
                      messageBinding="hostColumnMessage"
                      messageTypeBinding="hostColumnMessageType">
                  </uix:messageStyledText>
                </uix:column>

                <uix:tableSelection>
                  <uix:singleSelection
                      shortDescBinding="SELECT@MultiTargetResourceBundle"
                      selectedIndex="0"/>
                </uix:tableSelection>

              </uix:table>
            </uix:dataScope>

          </uix:contents>
        </uix:listOfValues>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
