<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       multiTargetLoadShowMore.jsp 
 *
 *      NOTES
 *       Execute Host Command/Execute SQL, Execution Results page.
 *
 * MODIFIED
 *    kmckeen    01/27/05 - Add separator between context info and results data.
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>

<%@ page import="oracle.sysman.eml.PageNames" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>

<jsp:useBean
    id="multiTargetBean"
    scope="request"
    type="oracle.sysman.eml.target.MultiTargetBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="SDKUIResourceBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="JobsResourceBundle" class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:bundle name="MntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="MultiTargetResourceBundle" class="oracle.sysman.eml.rsc.target.MultiTargetMsg"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:contents>
        <uix:form name="multiTargetShowMore" method="post">

          <uix:formValue
              name="<%= EmlConstants.PAGE_NAME_PAGE_PROPERTY %>"
              value="<%= PageNames.MULTI_TARGET_SHOW_MORE_PAGE %>"/>

          <uix:pageLayout titleBinding="title@multiTargetBean@servletRequest">

            <%@ include file="/enablePPR.jspf" %>
            <%@ include file="/oemGlobal.jspf" %>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="20%" columns="2" width="100%">
                <uix:messagePrompt
                    promptBinding="EXECUTION_STATUS@MultiTargetResourceBundle"/>
                <uix:flowLayout>
                  <uix:image
                      shortDescBinding="showMoreExeStatusText@multiTargetBean@servletRequest"
                      sourceBinding="showMoreExeStatusImage@multiTargetBean@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="showMoreExeStatusText@multiTargetBean@servletRequest"/>
                </uix:flowLayout>
                <uix:messageStyledText
                    contentStyleClass="OraDataText"
                    promptBinding="SUMMARY_STARTED@JobsResourceBundle"
                    textBinding="showMoreExecuteDateStart@multiTargetBean@servletRequest"/>
                <uix:messageStyledText
                    contentStyleClass="OraDataText"
                    promptBinding="EXEC_TABLE_RUNNING_TIME_COLUMN@JobsResourceBundle"
                    textBinding="showMoreExecuteElapsedTime@multiTargetBean@servletRequest"/>
                <uix:messageStyledText
                    contentStyleClass="OraDataText"
                    promptBinding="JOBS_TABLE_HEADER_ENDED@JobsResourceBundle"
                    textBinding="showMoreExecuteDateEnd@multiTargetBean@servletRequest"/>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:rawText text="<pre>"/>
            <uix:text
                textBinding="showMoreText@multiTargetBean@servletRequest"/>
            <uix:rawText text="</pre>"/>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    textBinding="RETURN_BUTTON@MntrResourceBundle"
                    name="event"
                    value="return"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
