<%@ include file="/oemNoscript.jspf" %>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<script>
function removeFunc(row)
{
  document.forms[0].rowId.value=row;
  document.forms[0].event.value='removeRow';
  document.forms[0].submit();
}
function changeServiceFunc(row)
{
  document.forms[0].rowId.value=row;
  document.forms[0].event.value='onChangeServiceName';
  document.forms[0].submit();
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
     <uix:bundle name="mntrResourceBundle"
                 class="oracle.sysman.resources.MntrResourceBundle"/>
     <uix:bundle name="sdkMsg"
                 class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
     <uix:bundle name="aggSvcMsg"
                 class="oracle.sysman.eml.target.svc.AggSvcMsg"/>
     <uix:bundle name="commonResourceBundle"
                 class="oracle.sysman.resources.CommonResourceBundle"/>
                 
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>

    <uix:body>
      <uix:form name="addMetricForm" method="POST">
      <uix:formValue name="rowId" value=""/>

      <uix:pageLayout titleBinding="pageHeader@aggSvcAddMetric@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
          <uix:messages>
            <%-- Warning/Error display --%>
            <uix:stackLayout>
            <uix:messageBox messageType="error"
                            rendered="false"
                            renderedBinding="errorOccurred@errors@servletRequest"
                            messageBinding="CORRECT_ERRORS_MSG@mntrResourceBundle">
              <uix:contents childDataBinding="errorList@errors@servletRequest">
                <uix:link textBinding="label"
                          longDescBinding="message"
                          destinationBinding="destination" />
              </uix:contents>
            </uix:messageBox>
            <uix:dataScope currentDataBinding="warningMsg@aggSvcAddMetric@servletRequest">
            <uix:messageBox messageType="warning"
                            rendered="false"
                            renderedBinding="warningOccurred@"
                            messageBinding="warningMessage@"/>
            </uix:dataScope>
            </uix:stackLayout>
          </uix:messages>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:submitButton name="event"
                                    textBinding="CANCEL@commonResourceBundle"
                                    shortDescBinding="CANCEL@commonResourceBundle"
                                    value="Cancel"
                                    unvalidated="true"/>
                  <uix:spacer width="4"/>
                  <uix:submitButton name="event"
                                    textBinding="CONTINUE@commonResourceBundle"
                                    shortDescBinding="CONTINUE@commonResourceBundle"
                                    value="Continue"/>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:tableLayout width="95%">
         <uix:header textBinding="METRIC_DEFINITION@aggSvcMsg">
           <uix:rowLayout width="100%">
             <uix:styledText textBinding="instructionText@aggSvcAddMetric@servletRequest"
                     styleClass="OraInstructionText"/>
            </uix:rowLayout>
            <uix:spacer width="15"/>
            <uix:rowLayout width="100%">
                <uix:radioButton 
                     name="selectedMetricType"
                     selectedValueBinding="addMetricType@aggSvcAddMetric@servletRequest"
                     value="singleSubsvc"
                     textBinding="ADD_METRIC_RADIO1@aggSvcMsg"
                     shortDescBinding="ADD_METRIC_RADIO1@aggSvcMsg"/>
            </uix:rowLayout>
            <uix:spacer width="5"/>
            <uix:rowLayout width="100%">
              <uix:labeledFieldLayout columns="2" labelWidth="10%" fieldWidth="90%">
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="SUBSERVICE@aggSvcMsg"/>
                <uix:choice id="listServices" name="serviceChoice" shortDescBinding="SUBSERVICE@aggSvcMsg"
                      selectedValueBinding="serviceChoice@aggSvcAddMetric@servletRequest"
                      primaryClientActionBinding="goAddMetricEvent@aggSvcAddMetric@servletRequest" >
                  <uix:contents childDataBinding="servicesList@aggSvcAddMetric@servletRequest">
                    <uix:option textBinding="targetName" valueBinding="serviceName"/>
                  </uix:contents>
                </uix:choice>
              </uix:labeledFieldLayout>
            </uix:rowLayout>
            <uix:spacer width="5"/>
            <uix:rowLayout width="100%">
              <uix:labeledFieldLayout columns="2" labelWidth="10%" fieldWidth="90%">
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="METRIC@aggSvcMsg"/>
                <uix:choice id="listMetrics" name="metricChoice"
                      selectedValueBinding="metricChoice@aggSvcAddMetric@servletRequest"
                      shortDescBinding="METRIC@aggSvcMsg">
                  <uix:contents childDataBinding="tableDataForSingleMetric@aggSvcAddMetric@servletRequest"> 
                    <uix:option textBinding="metricColumn" valueBinding="metricNameColumn"/>
                  </uix:contents>
                </uix:choice>
              </uix:labeledFieldLayout>
            </uix:rowLayout>
            <uix:spacer width="15"/>
            <uix:rowLayout width="100%">
                <uix:radioButton
                     name="selectedMetricType"
                     value="multiSubsvcs"
                     selectedValueBinding="addMetricType@aggSvcAddMetric@servletRequest"
                     textBinding="ADD_METRIC_RADIO2@aggSvcMsg" shortDescBinding="ADD_METRIC_RADIO2@aggSvcMsg"/>
            </uix:rowLayout>
            <uix:spacer width="5"/>
            <uix:rowLayout width="100%">
              <uix:labeledFieldLayout columns="2" labelWidth="10%" fieldWidth="90%">
               <uix:messageChoice name="function" 
                     promptBinding="FUNCTION@aggSvcMsg" 
                     shortDescBinding="FUNCTION@aggSvcMsg"
                     selectedValueBinding="statFunction@aggSvcAddMetric@servletRequest">
                 <uix:contents>
                   <uix:option textBinding="MIN@aggSvcMsg" value="MGMT_METRIC_HELPER.eval_min_value"/>
                   <uix:option textBinding="MAX@aggSvcMsg" value="MGMT_METRIC_HELPER.eval_max_value"/>
                   <uix:option textBinding="AVG@aggSvcMsg" value="MGMT_METRIC_HELPER.eval_avg_value"/>
                   <uix:option textBinding="SUM@aggSvcMsg" value="MGMT_METRIC_HELPER.eval_sum_value"/>
                   <uix:formValue name="function"/>
                 </uix:contents>
               </uix:messageChoice>
              </uix:labeledFieldLayout>
            </uix:rowLayout>
            <uix:spacer width="5"/>
            <uix:rowLayout width="100%">
              <uix:spacer width="15"/>
              <uix:tableLayout width="100%">
            <uix:rowLayout width="100%">
              <uix:styledText styleClass="OraInstructionText"
                                textBinding="instruction1Text@aggSvcAddMetric@servletRequest"/>
            </uix:rowLayout>
            <uix:rowLayout width="100%">
                  <uix:messagePrompt messageTypeBinding="statMsgType@errors@servletRequest"/>
                </uix:rowLayout>
                <uix:rowLayout width="100%">
                  <uix:table name="availableStatMetrics" 
                            id="availableStatMetrics" 
                            alternateTextBinding="NO_METRICS_SELECT@mntrResourceBundle" 
                            width="70%"
                            blockSize="10" 
                            valueBinding="value@aggSvcAddMetric@servletRequest" 
                            minValueBinding="minValue@aggSvcAddMetric@servletRequest" 
                            maxValueBinding="maxValue@aggSvcAddMetric@servletRequest" 
                            formSubmitted="true"
                            summaryBinding="METRIC_DEFINITION@aggSvcMsg"
                            tableDataBinding="statTableData@tableDataForStatistical@aggSvcAddMetric@servletRequest" 
                            columnHeaderDataBinding="columnHeaderDataForStatistical@aggSvcAddMetric@servletRequest">
                  <uix:tableFormat tableBanding="rowBanding"/>
                  <uix:columnHeaderStamp>
                    <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                  </uix:columnHeaderStamp>             
                  <uix:contents>
                    <uix:choice name="statavailServiceName" 
                               primaryClientActionBinding="onChangeServiceDest@aggSvcAddMetric@servletRequest" 
                               selectedValueBinding="statselectedServiceName" shortDescBinding="SUBSERVICE@aggSvcMsg">
                      <uix:contents childDataBinding="statservicesList"> 
                        <uix:option textBinding="targetName" 
                                    valueBinding="serviceName"/> 
                      </uix:contents>
                    </uix:choice>
                    <uix:choice name="statavailMetricName" 
                               shortDescBinding="METRIC@aggSvcMsg"  
                               selectedValueBinding="statselectedMetricName"> 
                      <uix:contents childDataBinding="statmetricsList"> 
                        <uix:option textBinding="metricColumn" 
                                    valueBinding="metricNameColumn"/> 
                      </uix:contents>
                    </uix:choice>
                    <uix:image sourceBinding="deleteSourceImage@aggSvcAddMetric@servletRequest"
                                    shortDescBinding="REMOVE@commonResourceBundle"
                                    onClickBinding="removeRow"/>
                  </uix:contents>
                  <uix:columnFooter>
                    <uix:addTableRow textBinding="ADD_FILTER_LABEL@mntrResourceBundle" 
                                    rows="1"/>
                  </uix:columnFooter>
               </uix:table>  
               </uix:rowLayout>
               <uix:rowLayout>
                   <uix:messageText messageTypeBinding="statMsgType@errors@servletRequest"
                                     messageBinding="statInlineMsg@errors@servletRequest"/>
               </uix:rowLayout>
               </uix:tableLayout>
               </uix:rowLayout>
         </uix:header>
               </uix:tableLayout>
       </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

