<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:buildTree nodeID="homePlugin">
  <uix:dataScope>
  <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
  <uix:bundle name="bam" class="oracle.sysman.resources.eml.bam.BamMsg" />
  <uix:bundle name="sdk" class="oracle.sysman.emSDK.eml.SDKUIMsg" />
  <uix:stackLayout>
    <uix:styledText textBinding="BUSINESS_PAGE_TEXT1@gensvc" styleClass="OraInstructionText"/>
    <uix:spacer height="10"/>
    
    <%-- business metric table --%>

      <uix:messagePrompt messageTypeBinding="metricMsgType@errors@servletRequest"
                anchorBinding="metricAnchor@errors@servletRequest"/>
      <uix:table name="availableBusinessMetrics" 
                id="availableBusinessMetrics" 
                partialRenderMode="self" 
                summaryBinding="AVAILABLE_TARGETS_HEADER@mntrResourceBundle" 
                alternateTextBinding="NO_METRICS_SELECT@mntrResourceBundle" 
                width="85%" 
                blockSize="25" 
                valueBinding="value@createBusiness@servletRequest" 
                minValueBinding="minValue@createBusiness@servletRequest" 
                maxValueBinding="maxValue@createBusiness@servletRequest" 
                formSubmitted="true" 
                tableDataBinding="tableData@createBusiness@servletRequest" 
                columnFormatsBinding="columnFormats@createBusiness@servletRequest" 
                columnHeaderDataBinding="columnHeaderData@createBusiness@servletRequest">
      <uix:tableFormat tableBanding="rowBanding"/>
      <uix:tableActions>
        <uix:submitButton textBinding="ADD@sdkMsg"
                shortDescBinding="ADD@sdkMsg"
                name="event"
                value="doAddBusinessMetric"/>
      </uix:tableActions>
      <uix:columnHeaderStamp>
        <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
      </uix:columnHeaderStamp>              
      <uix:tableSelection>
        <uix:singleSelection selectedIndexBinding="selection@createBusiness@servletRequest" 
                             shortDescBinding="SELECT@commonResourceBundle">
          <uix:submitButton textBinding="REMOVE@sdkMsg" name="event" value="doRemoveBusinessMetric"/>
          <uix:submitButton textBinding="EDIT@sdkMsg" name="event" value="doEditBusinessMetric"/>
        </uix:singleSelection>
      </uix:tableSelection>
      <uix:contents>
        <uix:messageTextInput
                name="sMetricName" 
                promptBinding="metricColumn"
                labeledNodeId="metricNameId"
                textBinding="metricColumn"
                onChange="submitForm(this.form,true,{'event':'update'})"
                readOnlyBinding="sMetricNameDisabled"
                shortDescBinding="NAME@commonResourceBundle"/>
        <uix:choice name="operatorChoice" selectedValueBinding="operator" shortDescBinding="COMPARISON_OPERATOR@mntrResourceBundle">
          <uix:contents childDataBinding="compOperatorData@createBusiness@servletRequest">
            <uix:option textBinding="text" valueBinding="value"/>
          </uix:contents>
        </uix:choice>
        <uix:textInput 
                     name="warningThreshold"
                     textBinding="warningThreshold" shortDescBinding="WARNING@mntrResourceBundle"
                     columns="15">
        </uix:textInput>
        <uix:textInput 
                     name="criticalThreshold"
                     textBinding="criticalThreshold" shortDescBinding="CRITICAL@mntrResourceBundle"
                     columns="15">
        </uix:textInput>
        <uix:formValue name="ID" valueBinding="ID"/>
      </uix:contents>
    </uix:table>
 <uix:messageText messageTypeBinding="metricMsgType@errors@servletRequest" 
         messageBinding="metricInlineMsg@errors@servletRequest"/>
    
  <uix:spacer height="5"/>  
  <uix:header textBinding="PROMO_PAGE_OTHER_HEADING@gensvc" renderedBinding="hasNonPromotedBusinessMetrics@createBusiness@servletRequest">
    <uix:stackLayout>
      <uix:contents>
        <uix:stackLayout > 
          <uix:contents childDataBinding="nonPromotedBusinessMetrics@createBusiness@servletRequest">
            <uix:styledText  textBinding="<%=UIConstants.TEXT_KEY%>" styleClass="OraDataText"/>
          </uix:contents>
        </uix:stackLayout>
        <uix:spacer height="5"/>
        <uix:styledText textBinding="promoInstText@createBusiness@servletRequest" styleClass="OraInstructionText"/>
        <uix:spacer height="5"/>
        <uix:link textBinding="DATA_EXCHANGE@bam"
                  destinationBinding="dataExchangeDest@createBusiness@servletRequest"/>
        <uix:link textBinding="MONITORING_SETTINGS@sdk"
                  destinationBinding="monitoringSettingsDest@createBusiness@servletRequest"/>
      </uix:contents>
    </uix:stackLayout>
  </uix:header>
  
  </uix:stackLayout>
  </uix:dataScope>
</uix:buildTree>
<%@ include file="aggSvcCreate.jspf" %>
