<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:buildTree nodeID="homePlugin">
  <uix:dataScope>
  <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
  <uix:bundle name="bam" class="oracle.sysman.resources.eml.bam.BamMsg" />
  <uix:bundle name="sdk" class="oracle.sysman.emSDK.eml.SDKUIMsg" />
  <uix:stackLayout>
    <uix:styledText textBinding="CREATE_PERF_INSTR@aggSvcMsg" styleClass="OraInstructionText"/>
    <uix:spacer height="10"/>
    
    <%-- performance metric table --%>
      <uix:messagePrompt messageTypeBinding="metricMsgType@errors@servletRequest"
                anchorBinding="metricAnchor@errors@servletRequest"/>
      <uix:table name="availablePerfMetrics" 
                id="availablePerfMetrics" 
                showAll="yes"
                partialRenderMode="self" 
                summaryBinding="AVAILABLE_TARGETS_HEADER@mntrResourceBundle" 
                alternateTextBinding="NO_METRICS_SELECT@mntrResourceBundle" 
                width="85%" 
                blockSize="25" 
                valueBinding="value@createPerf@servletRequest" 
                minValueBinding="minValue@createPerf@servletRequest" 
                maxValueBinding="maxValue@createPerf@servletRequest" 
                formSubmitted="true" 
                tableDataBinding="tableData@createPerf@servletRequest" 
                columnFormatsBinding="columnFormats@createPerf@servletRequest" 
                columnHeaderDataBinding="columnHeaderData@createPerf@servletRequest">
      <uix:tableFormat tableBanding="rowBanding"/>
      <uix:tableActions>
        <uix:submitButton textBinding="ADD@sdkMsg"
                shortDescBinding="ADD@sdkMsg"
                name="event"
                value="doAddPerfMetric"/>
      </uix:tableActions>
      <uix:columnHeaderStamp>
        <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
        <uix:columnFormat cellNoWrapFormat="true"/>
      </uix:columnHeaderStamp>              
      <uix:tableSelection>
        <uix:singleSelection selectedIndexBinding="selection@createPerf@servletRequest" 
                             shortDescBinding="SELECT@commonResourceBundle">
          <uix:submitButton textBinding="REMOVE@sdkMsg" name="event" value="doRemovePerfMetric"/>
          <uix:submitButton textBinding="EDIT@sdkMsg" name="event" value="doEditPerfMetric"/>
        </uix:singleSelection>
      </uix:tableSelection>
      <uix:contents>
        <uix:messageTextInput
                name="sMetricName"
                labeledNodeId="metricNameId"
                textBinding="metricColumn"
                promptBinding="metricColumn"
                readOnlyBinding="sMetricNameDisabled"
                onChange="submitForm(this.form,true,{'event':'update'})" 
                shortDescBinding="NAME@commonResourceBundle"/>
        <uix:choice name="operatorChoice" selectedValueBinding="operator" shortDescBinding="COMPARISON_OPERATOR@mntrResourceBundle"> 
          <uix:contents childDataBinding="compOperatorData@createPerf@servletRequest">
            <uix:option textBinding="text" valueBinding="value"/>
          </uix:contents>
        </uix:choice>
        <uix:textInput 
                name="warningThreshold"
                textBinding="warningThreshold" columns="15" shortDescBinding="WARNING@mntrResourceBundle">
        </uix:textInput>
        <uix:textInput 
                name="criticalThreshold"
                textBinding="criticalThreshold" columns="15" shortDescBinding="CRITICAL@mntrResourceBundle">
        </uix:textInput>
        <uix:formValue name="ID" valueBinding="ID"/>
      </uix:contents>
    </uix:table>
           <uix:messageText messageTypeBinding="metricMsgType@errors@servletRequest" messageBinding="metricInlineMsg@errors@servletRequest"/>

    <uix:spacer height="5"/>
    <uix:messageChoice rendered="false" renderedBinding="showHomeChartList@createPerf@servletRequest"
                       name="homeChart"                             
                       promptBinding="SHOW_IN_HOME_PAGE@aggSvcMsg"
                       shortDescBinding="SHOW_IN_HOME_PAGE@aggSvcMsg"
                       selectedValueBinding="homeChartValue@createPerf@servletRequest"> 
      <uix:contents childDataBinding="tableData@createPerf@servletRequest">
        <uix:option textBinding="metricColumn" valueBinding="metricName"/>
      </uix:contents>                            
    </uix:messageChoice>
    
  <uix:spacer height="5"/>  
  <uix:header textBinding="PROMO_PAGE_PERF_HEADING@gensvc" renderedBinding="hasNonPromotedPerfMetrics@createPerf@servletRequest">
    <uix:stackLayout>
      <uix:contents>
        <uix:stackLayout > 
          <uix:contents childDataBinding="nonPromotedPerfMetrics@createPerf@servletRequest">
            <uix:styledText  textBinding="<%=UIConstants.TEXT_KEY%>" styleClass="OraDataText"/>
          </uix:contents>
        </uix:stackLayout>
        <uix:spacer height="5"/>
        <uix:styledText textBinding="promoInstText@createPerf@servletRequest" styleClass="OraInstructionText"/>
        <uix:spacer height="5"/>
        <uix:link textBinding="DATA_EXCHANGE@bam"
                  destinationBinding="dataExchangeDest@createPerf@servletRequest"/>
        <uix:link textBinding="MONITORING_SETTINGS@sdk"
                  destinationBinding="monitoringSettingsDest@createPerf@servletRequest"/>
      </uix:contents>
    </uix:stackLayout>
  </uix:header>
                       
  </uix:stackLayout>
  </uix:dataScope>
</uix:buildTree>
<%@ include file="aggSvcCreate.jspf" %>

