<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:body> 
<uix:buildTree nodeID="homePlugin">


  <uix:stackLayout>

    <uix:spacer height="5"/>
      <uix:rowLayout width="100%">
          <uix:labeledFieldLayout columns="1" labelWidth="10%" fieldWidth="90%">
            <uix:contents>
              <uix:messageTextInput name="serviceName" promptBinding="NAME@sdkMsg" 
                          textBinding="serviceName@createSubsvcs@servletRequest" 
                          shortDescBinding="NAME@sdkMsg"
                          messageTypeBinding="nameMsgType@errors@servletRequest"
                          messageBinding="nameInlineMsg@errors@servletRequest"
                          readOnlyBinding="isEditMode@createSubsvcs@servletRequest"
                          styleClassBinding="serviceNameStyle@createSubsvcs@servletRequest"
                          required="uiOnly"
                          maximumLength="256"/>
              <uix:messageTextInput name="timezone" promptBinding="TIME_ZONE@commonResourceBundle" 
                          textBinding="timezoneSelectedLabel@createSubsvcs@servletRequest" 
                          shortDescBinding="TIME_ZONE@commonResourceBundle" 
                          readOnlyBinding="isEditMode@createSubsvcs@servletRequest"
                          renderedBinding="isEditMode@createSubsvcs@servletRequest"
                          styleClassBinding="serviceNameStyle@createSubsvcs@servletRequest" />
            </uix:contents>
          </uix:labeledFieldLayout>
      </uix:rowLayout>


    <uix:header textBinding="SUBSERVICES@aggSvcMsg">
      <uix:styledText styleClass="OraInstructionText"
                      textBinding="CREATE_SUBSVCS_INSTR@aggSvcMsg"/>

        <uix:tableLayout width="100%">
          <uix:rowLayout>
          <uix:messagePrompt messageTypeBinding="subsvcsMsgType@errors@servletRequest" 
                        anchorBinding="subsvcsListAnchor@errors@servletRequest"/>
            <uix:table name="availableTargets"
                       showAll="yes"
                       id="availableTargets" 
                       partialRenderMode="self" 
                       summaryBinding="AVAILABLE_TARGETS_HEADER@mntrResourceBundle" 
                       alternateTextBinding="NO_SUBSERVICES_SELECTED@aggSvcMsg" 
                       blockSize="10"
                       width="85%"
                       valueBinding="value@createSubsvcs@servletRequest" 
                       minValueBinding="minValue@createSubsvcs@servletRequest" 
                       maxValueBinding="maxValue@createSubsvcs@servletRequest" 
                       formSubmitted="true" 
                       tableDataBinding="tableData@createSubsvcs@servletRequest" 
                       columnFormatsBinding="columnFormats@createSubsvcs@servletRequest" 
                       columnHeaderDataBinding="columnHeaderData@createSubsvcs@servletRequest">
              <uix:tableFormat tableBanding="rowBanding"/>
              <uix:tableActions>
                <oem:targetSelection textBinding="ADD@sdkMsg" />
              </uix:tableActions>

              <uix:columnHeaderStamp>
                <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
              </uix:columnHeaderStamp>              
              <uix:tableSelection>
                <uix:multipleSelection selectionBinding="selection@createSubsvcs@servletRequest" 
                                       shortDescBinding="SELECT@commonResourceBundle" 
                                       selectedBinding="selectKey">
                  <uix:submitButton textBinding="REMOVE@sdkMsg"
                                    shortDescBinding="REMOVE@sdkMsg"
                                    name="event"
                                    value="doRemoveSubsvcs"/>
                </uix:multipleSelection>
              </uix:tableSelection>
              <uix:contents>
                <uix:styledText textBinding="targetName" shortDescBinding="NAME@commonResourceBundle@servletRequest" />
                <uix:styledText textBinding="dispType" />
                <uix:formValue name="targetName" valueBinding="targetName"/>
                <uix:formValue name="targetType" valueBinding="targetType"/>
              </uix:contents>
            </uix:table>
       </uix:rowLayout>
       <uix:rowLayout>
         <uix:cellFormat>
         </uix:cellFormat>
         <uix:cellFormat>
           <uix:messageText messageTypeBinding="subsvcsMsgType@errors@servletRequest" messageBinding="subsvcsInlineMsg@errors@servletRequest"/>
         </uix:cellFormat>
       </uix:rowLayout>
     </uix:tableLayout>
   </uix:header>
          <uix:switcher childNameBinding="isEditMode@createSubsvcs@servletRequest">
     <uix:case name="false">
       <uix:spacer height="5"/>
       <uix:header textBinding="TIME_ZONE@commonResourceBundle">
         <uix:tableLayout cellSpacing="5" width="100%">
           <uix:rowLayout width="100%">
             <uix:cellFormat width="100%" hAlign="left" vAlign="top" >
               <uix:labeledFieldLayout columns="2" labelWidth="10%" fieldWidth="90%">
                 <uix:contents>
                   <uix:messageChoice name="timezoneChoice"
                          promptBinding="TIME_ZONE@commonResourceBundle"
                          shortDescBinding="TIME_ZONE@commonResourceBundle"
                          selectedValueBinding="timezoneSelectedValue@createSubsvcs@servletRequest"
                          messageTypeBinding="timezoneMsgType@errors@servletRequest"
                          messageBinding="timezoneInlineMsg@errors@servletRequest"
                          required="uiOnly"
                          renderedBinding="renderTimezone@createSubsvcs@servletRequest">
                     <uix:contents childDataBinding="timezones@createSubsvcs@servletRequest">
                       <uix:option textBinding="timezoneDisplay" valueBinding="timezoneValue"/>
                     </uix:contents>
                   </uix:messageChoice>
                 </uix:contents>
               </uix:labeledFieldLayout>
             </uix:cellFormat>
           </uix:rowLayout>
         </uix:tableLayout>
       </uix:header>
     </uix:case>
    </uix:switcher>

    <uix:spacer height="5"/>
    <uix:header textBinding="AVAILABILITY@sdkMsg">
      <uix:stackLayout>
        <uix:styledText styleClass="OraInstructionText"
                        textBinding="CREATE_AVAIL_INSTR@aggSvcMsg"/> 
        <uix:spacer height="5"/>
        <uix:styledText styleClass="OraInstructionText"
                        textBinding="CREATE_AVAIL_INSTR2@aggSvcMsg"/>
        <uix:radioGroup name="availChoice" valueBinding="value"
                        shortDescBinding="CREATE_AVAIL_INSTR2@aggSvcMsg"
                        textBinding="text"
                        type="radio" childDataBinding="availSelection@createSubsvcs@servletRequest"
                        selectedValueBinding="selectIndex@createSubsvcs@servletRequest">
        </uix:radioGroup>
      </uix:stackLayout>                      
                      
    </uix:header>

  </uix:stackLayout>
    <uix:spacer height="5"/>

</uix:buildTree>
</uix:body>
<%@ include file="aggSvcCreate.jspf" %>

