<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:buildTree nodeID="homePlugin">
  <uix:dataScope>
  <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
  <uix:bundle name="bam" class="oracle.sysman.resources.eml.bam.BamMsg" />
  <uix:bundle name="sdk" class="oracle.sysman.emSDK.eml.SDKUIMsg" />
  <uix:stackLayout>
    <uix:styledText textBinding="CREATE_USAGE_INSTR@aggSvcMsg" styleClass="OraInstructionText"/>
    <uix:spacer height="10"/>
    
    <%-- usage metric table --%>

      <uix:messagePrompt messageTypeBinding="metricMsgType@errors@servletRequest"
                anchorBinding="metricAnchor@errors@servletRequest"/>
      <uix:table name="availableUsageMetrics" 
                id="availableUsageMetrics" 
                partialRenderMode="self" 
                summaryBinding="AVAILABLE_TARGETS_HEADER@mntrResourceBundle" 
                alternateTextBinding="NO_METRICS_SELECT@mntrResourceBundle" 
                width="85%" 
                blockSize="25" 
                valueBinding="value@createUsage@servletRequest" 
                minValueBinding="minValue@createUsage@servletRequest" 
                maxValueBinding="maxValue@createUsage@servletRequest" 
                formSubmitted="true" 
                tableDataBinding="tableData@createUsage@servletRequest" 
                columnFormatsBinding="columnFormats@createUsage@servletRequest" 
                columnHeaderDataBinding="columnHeaderData@createUsage@servletRequest">
      <uix:tableFormat tableBanding="rowBanding"/>
      <uix:tableActions>
        <uix:submitButton textBinding="ADD@sdkMsg"
                shortDescBinding="ADD@sdkMsg"
                name="event"
                value="doAddUsageMetric"/>
      </uix:tableActions>
      <uix:columnHeaderStamp>
        <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
      </uix:columnHeaderStamp>              
      <uix:tableSelection>
        <uix:singleSelection selectedIndexBinding="selection@createUsage@servletRequest" 
                             shortDescBinding="SELECT@commonResourceBundle">
          <uix:submitButton textBinding="REMOVE@sdkMsg" name="event" value="doRemoveUsageMetric"/>
          <uix:submitButton textBinding="EDIT@sdkMsg" name="event" value="doEditUsageMetric"/>
        </uix:singleSelection>
      </uix:tableSelection>
      <uix:contents>
        <uix:messageTextInput
                name="sMetricName" 
                promptBinding="metricColumn"
                labeledNodeId="metricNameId"
                textBinding="metricColumn"
                onChange="submitForm(this.form,true,{'event':'update'})"
                readOnlyBinding="sMetricNameDisabled"
                shortDescBinding="NAME@commonResourceBundle"/>
        <uix:choice name="operatorChoice" selectedValueBinding="operator" shortDescBinding="COMPARISON_OPERATOR@mntrResourceBundle">
          <uix:contents childDataBinding="compOperatorData@createUsage@servletRequest">
            <uix:option textBinding="text" valueBinding="value"/>
          </uix:contents>
        </uix:choice>
        <uix:textInput 
                     name="warningThreshold"
                     textBinding="warningThreshold" shortDescBinding="WARNING@mntrResourceBundle"
                     columns="15">
        </uix:textInput>
        <uix:textInput 
                     name="criticalThreshold"
                     textBinding="criticalThreshold" shortDescBinding="CRITICAL@mntrResourceBundle"
                     columns="15">
        </uix:textInput>
        <uix:formValue name="ID" valueBinding="ID"/>
      </uix:contents>
    </uix:table>
 <uix:messageText messageTypeBinding="metricMsgType@errors@servletRequest" 
         messageBinding="metricInlineMsg@errors@servletRequest"/>
    <uix:spacer height="5"/>
    <uix:messageChoice rendered="false" renderedBinding="showHomeChartList@createUsage@servletRequest"
                       name="homeChart"                             
                       promptBinding="SHOW_IN_HOME_PAGE@aggSvcMsg"
                       selectedValueBinding="homeChartValue@createUsage@servletRequest"> 
      <uix:contents childDataBinding="tableData@createUsage@servletRequest">
        <uix:option textBinding="metricColumn" valueBinding="metricName"/>
      </uix:contents>                            
    </uix:messageChoice>
    
  <uix:spacer height="5"/>  
  <uix:header textBinding="PROMO_PAGE_OTHER_HEADING@gensvc" renderedBinding="hasNonPromotedUsageMetrics@createUsage@servletRequest">
    <uix:stackLayout>
      <uix:contents>
        <uix:stackLayout > 
          <uix:contents childDataBinding="nonPromotedUsageMetrics@createUsage@servletRequest">
            <uix:styledText  textBinding="<%=UIConstants.TEXT_KEY%>" styleClass="OraDataText"/>
          </uix:contents>
        </uix:stackLayout>
        <uix:spacer height="5"/>
        <uix:styledText textBinding="promoInstText@createUsage@servletRequest" styleClass="OraInstructionText"/>
        <uix:spacer height="5"/>
        <uix:link textBinding="DATA_EXCHANGE@bam"
                  destinationBinding="dataExchangeDest@createUsage@servletRequest"/>
        <uix:link textBinding="MONITORING_SETTINGS@sdk"
                  destinationBinding="monitoringSettingsDest@createUsage@servletRequest"/>
      </uix:contents>
    </uix:stackLayout>
  </uix:header>

  </uix:stackLayout>
  </uix:dataScope>
</uix:buildTree>
<%@ include file="aggSvcCreate.jspf" %>
