<%-- * Copyright (c) 2003, 2004, Oracle. All rights reserved.  
 *
 *      NAME
 *       svcAvailHistoryHGridSegment.jsp
 *
 *      NOTES
 *       Service Home Page General segment
 *
 * MODIFIED
 *    jpyang   08/02/05 - 
 *    tzimmerm 03/01/05 - Get bean from pageSegmentContext 
 *    jpyang   02/17/05 - 
 *    dtsao    02/14/05 - Add legend 
 *    dtsao    02/09/05 - Bug 4128468 
 *    vagarwal 01/06/05 - add type column 
 *    vagarwal 12/28/04 - change width.; 
 *    vagarwal 12/23/04 - make tablewidth 100% 
 *    vagarwal 12/18/04 - fix timeline alignment 
 *    jpyang   10/28/04 - jpyang_aggsvc_stat_hist
 *    jpyang   10/18/04  - 
 *    jpyang   10/06/04  - jpyang_aggsvc_home_1
 *    jpyang   09/27/04  - creation
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import='oracle.sysman.eml.target.svc.SvcAvailHistoryHGridSegmentViewBean' %>
<%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext' %>
<oem:pageSegment>
  <uix:dataScope>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="gensvcBundle" 
              class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle" />
  <uix:bundle name="sdkMsg" 
              class="oracle.sysman.emSDK.eml.SDKUIMsg" />              


<uix:tableLayout>
  <%
      PageSegmentContext psc = (PageSegmentContext)request.getAttribute("pageSegmentContext"); 
      SvcAvailHistoryHGridSegmentViewBean bean = (SvcAvailHistoryHGridSegmentViewBean)psc.getPageSegmentBean();
      String psName = bean.getName();
  %> 
 <uix:rowLayout>
  <uix:hGrid id="<%= psName %>"
             width="950" 
             destinationBinding="destination@pageSegmentBean@" 
             summaryBinding="ALL_METRICS_SUMMARY@mntrResourceBundle" 
             columnFormatsBinding="columnFormats@pageSegmentBean@" 
             columnHeaderDataBinding="subservicesColumnHeaderData@pageSegmentBean@" 
             treeDataBinding="treeData@pageSegmentBean@" 
             proxied="true"
             formSubmitted="true"
             partialRenderMode="self" 
             proxyBinding="proxy@pageSegmentBean@"
             childBlockSize="25">
    <uix:nodeStamp>
      <uix:column>
      <uix:columnFormat width="250"/>
        <uix:columnHeader>
          <uix:styledText textBinding="NAME@mntrResourceBundle"/>
        </uix:columnHeader>
        <uix:styledText textBinding="text" destinationBinding="targetDest"/>
      </uix:column>
    </uix:nodeStamp>
      <uix:column>
      <uix:columnFormat width="200"/>
        <uix:columnHeader>
          <uix:styledText textBinding="TYPE@mntrResourceBundle"/>
        </uix:columnHeader>
        <uix:styledText textBinding="typeDisplay" />
      </uix:column>
    <uix:column>
      <uix:columnFormat width="50"/>
      <uix:columnHeader>
        <uix:styledText textBinding="STATUS@mntrResourceBundle"/>
      </uix:columnHeader>
      <uix:columnFormat columnDataFormat="iconButtonFormat" />
      <uix:image sourceBinding="currentStatusSrc"
                 destinationBinding="availDest"
                 shortDescBinding="statusShortDesc"
                 textBinding="statusText"/>
    </uix:column>
    <uix:column>
      <uix:columnFormat width="450"/>
      <uix:columnHeader>
       <uix:styledText textBinding="HISTORY@mntrResourceBundle"/>
      </uix:columnHeader>
      <uix:include nodeBinding="availBarKey" />
    </uix:column>
  </uix:hGrid>
  </uix:rowLayout>
  <uix:rowLayout hAlign="right">
    <uix:cellFormat hAlign="right">
      <uix:include nodeBinding="timeLine@pageSegmentBean@" />
    </uix:cellFormat>
  </uix:rowLayout>
  <uix:rowLayout hAlign="right">
    <uix:cellFormat hAlign="right">
      <uix:image sourceBinding="STATUS_UP" 
                 shortDescBinding="AVAIL_UP@sdkMsg"/>
      <uix:spacer width="2" />
      <uix:styledText textBinding="AVAIL_UP@sdkMsg" 
                 styleClass="OraInstructionText" />            
      <uix:spacer width="10" />
      <uix:image sourceBinding="STATUS_DOWN" 
                 shortDescBinding="AVAIL_DOWN@sdkMsg"/>
      <uix:spacer width="2" />
      <uix:styledText textBinding="AVAIL_DOWN@sdkMsg"
                      styleClass="OraInstructionText"/>
      <uix:spacer width="10" />
      <uix:image sourceBinding="STATUS_BLACKOUT" 
                 shortDescBinding="AVAIL_BLACKOUT@sdkMsg"/>
      <uix:spacer width="2" />
      <uix:styledText textBinding="AVAIL_BLACKOUT@sdkMsg"
                 styleClass="OraInstructionText" />
      <uix:spacer width="10" />
      <uix:image sourceBinding="STATUS_AGENT_DOWN" 
                 shortDescBinding="AVAIL_AGENT_DOWN@sdkMsg"/>
      <uix:spacer width="2" />
      <uix:styledText textBinding="AVAIL_AGENT_DOWN@sdkMsg"
                      styleClass="OraInstructionText"/>
      <uix:spacer width="10" />
      <uix:image sourceBinding="STATUS_ERROR" 
                 shortDescBinding="AVAIL_ERROR@sdkMsg"/>
      <uix:spacer width="2" />
      <uix:styledText textBinding="AVAIL_ERROR@sdkMsg"
                      styleClass="OraInstructionText"/>
      <uix:spacer width="10" />
      <uix:image sourceBinding="STATUS_UNKNOWN"
                 shortDescBinding="AVAIL_UNKNOWN@sdkMsg"/>
      <uix:spacer width="2" />
      <uix:styledText textBinding="AVAIL_UNKNOWN@sdkMsg"
                      styleClass="OraInstructionText" />
    </uix:cellFormat>
  </uix:rowLayout>
  </uix:tableLayout>
 </uix:dataScope>
</oem:pageSegment>
