<%-- * Copyright (c) 2003, 2006, Oracle. All rights reserved.  
 *
 *      NAME
 *       svcChartsSegment.jsp
 *
 *      NOTES
 *       Service Charts segment
 *
 * MODIFIED
 *    eporter  06/09/06 - Make the Business charts clickable 
 *    eporter  02/22/06 - Add Business alerts 
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext' %>
<oem:pageSegment>
 <uix:dataScope>
  <uix:bundle name="aggSvcMsg" class="oracle.sysman.eml.target.svc.AggSvcMsg"/>
   <uix:form name="chartsSegForm" method="POST">
    <uix:tableLayout width="100%">
     <uix:rowLayout hAlign="right" width="100%">
      <uix:cellFormat>
       <uix:styledText styleClass="OraPromptText" textBinding="VIEWDATA_TEXT@sdkMsg"/>
        <uix:spacer width="4"/>
        <uix:choice name="pageType" shortDescBinding="VIEWDATA_TEXT@sdkMsg" selectedValueBinding="selectedViewData@chartsSegBean@servletRequest" onChange="submitForm(this.form,0,{'event':'refToOpt'}, false); return false;">
         <uix:option textBinding="LAST_DAY@sdkMsg" value="byDay"/>
         <uix:option textBinding="LAST_WEEK@sdkMsg" value="byWeek"/>
         <uix:option textBinding="LAST_MONTH@sdkMsg" value="byMonth"/>
        </uix:choice>
       <uix:formValue name="event" value="refToOpt"/>
       </uix:cellFormat>
      </uix:rowLayout>
     </uix:tableLayout>
     <uix:stackLayout>
<%
 int numCharts=0;
 String sNumCharts = (String) (((PageSegmentContext) request.getAttribute("pageSegmentContext")).getAttribute("numCharts"));
 if (sNumCharts != null) { numCharts = (new Integer(sNumCharts)).intValue(); }
 else { numCharts = 0; }
 if (numCharts ==0) {
%>
  <uix:messageBox messageType="info" messageBinding="NO_CHARTS_DEFINED@aggSvcMsg" />
<% } %>
</uix:stackLayout>
 <uix:tableLayout width="100%"> <uix:contents>
   <uix:rowLayout vAlign="top" hAlign="left" width="100%">
    <uix:cellFormat hAlign="right" width="50%">
     <uix:rowLayout vAlign="top" hAlign="left" width="100%">
      <uix:cellFormat width="95%"> 
       <uix:header textBinding="PERFORMANCE@aggSvcMsg" id="chartsarea1">
<% 
 int numPerfCharts = 0;
 String pCharts = (String) (((PageSegmentContext) request.getAttribute("pageSegmentContext")).getAttribute("numPerfCharts"));
 if (pCharts != null) { numPerfCharts = (new Integer(pCharts)).intValue(); }
 for (int i=0; i < numPerfCharts; i++) { String chartKey = "chartKey_Performance" + i;
%>
<uix:rowLayout>
 <uix:dataScope currentDataBinding='<%= chartKey+"@servletRequest" %>'>
  <uix:header textBinding="title">
   <uix:stackLayout>
    <uix:link destinationBinding="link">
     <oem:chart titleBinding="title" titleVisible="false" chartType="timeSeriesChart" widthBinding="width" heightBinding="height" orientation="vertical" seriesColorsAutomatic="true" legendPosition="south" legendVisible="false" warningThresholdBinding="warning" criticalThresholdBinding="critical" shortDescBinding="imageName"> <uix:contents>
      <oem:boundChartDataSource chartDataSourceBinding="chartDataSource"/>
      <oem:chartColumn isTimeColumn="true" displayLabel="" sourceIndex="0"/>
      <oem:chartColumn displayLabel="" sourceIndex="1"/> </uix:contents>
     </oem:chart> 
    </uix:link> <uix:spacer height="5"/>
   </uix:stackLayout>
  </uix:header>
 </uix:dataScope>
</uix:rowLayout>
<% } %>
  </uix:header>
 </uix:cellFormat>
</uix:rowLayout>
</uix:cellFormat>
<uix:cellFormat hAlign="left" width="50%">
 <uix:header textBinding="USAGE@aggSvcMsg" id="chartsarea2">
<% 
  int numUsageCharts = 0;
  String uCharts = (String) (((PageSegmentContext) request.getAttribute("pageSegmentContext")).getAttribute("numUsageCharts"));
  if (uCharts != null) { numUsageCharts = (new Integer(uCharts)).intValue(); }
  for (int i=0; i < numUsageCharts; i++) { String key = "chartKey_Usage" + i;
%>
<uix:rowLayout>
 <uix:dataScope currentDataBinding='<%= key+"@servletRequest" %>'>
  <uix:header textBinding="title">
   <uix:stackLayout>
    <uix:link destinationBinding="link">
     <oem:chart titleBinding="title" titleVisible="false" chartType="timeSeriesChart" widthBinding="width" heightBinding="height" orientation="vertical" seriesColorsAutomatic="true" legendPosition="south" legendVisible="false" warningThresholdBinding="warning" criticalThresholdBinding="critical" shortDescBinding="imageName"> <uix:contents>
      <oem:boundChartDataSource chartDataSourceBinding="chartDataSource"/>
      <oem:chartColumn isTimeColumn="true" displayLabel="" sourceIndex="0"/>
      <oem:chartColumn displayLabel="" sourceIndex="1"/> </uix:contents>
     </oem:chart> 
    </uix:link> <uix:spacer height="5"/>
   </uix:stackLayout>
  </uix:header>
 </uix:dataScope>
</uix:rowLayout>
<% } %>
    </uix:header>
   </uix:cellFormat>
   </uix:rowLayout>
 </uix:contents> </uix:tableLayout>
 
 
 <uix:tableLayout width="100%"> <uix:contents>
   <uix:rowLayout renderedBinding="hasBusiness@servletRequest"> 
 <uix:header textBinding="BUSINESS@aggSvcMsg" id="chartsarea3">
<uix:cellFormat hAlign="left" width="50%">
<% 
  int numBusinessCharts = 0;
  String bCharts = (String) (((PageSegmentContext) request.getAttribute("pageSegmentContext")).getAttribute("numBusinessCharts"));
  if (bCharts != null) { numBusinessCharts = (new Integer(bCharts)).intValue(); }
  for (int i=0; i < numBusinessCharts; i+=2) { String key = "chartKey_Business" + i;
%>
<uix:rowLayout>
 <uix:dataScope currentDataBinding='<%= key+"@servletRequest" %>'>
  <uix:header textBinding="title">
   <uix:stackLayout>
    <uix:link destinationBinding="link">
     <oem:chart titleBinding="title" titleVisible="false" chartType="timeSeriesChart" widthBinding="width" heightBinding="height" orientation="vertical" seriesColorsAutomatic="true" legendPosition="south" legendVisible="false" warningThresholdBinding="warning" criticalThresholdBinding="critical" shortDescBinding="imageName"> <uix:contents>
      <oem:boundChartDataSource chartDataSourceBinding="chartDataSource"/>
      <oem:chartColumn isTimeColumn="true" displayLabel="" sourceIndex="0"/>
      <oem:chartColumn displayLabel="" sourceIndex="1"/> </uix:contents>
     </oem:chart> 
    </uix:link>
    <uix:spacer height="5"/>
   </uix:stackLayout>
  </uix:header>
 </uix:dataScope>
</uix:rowLayout>
<% } %>
   </uix:cellFormat>
<uix:cellFormat hAlign="left" vAlign="top" width="50%">
<% 
  int numBusinessCharts = 0;
  String bCharts = (String) (((PageSegmentContext) request.getAttribute("pageSegmentContext")).getAttribute("numBusinessCharts"));
  if (bCharts != null) { numBusinessCharts = (new Integer(bCharts)).intValue(); }
  for (int i=1; i < numBusinessCharts; i+=2) { String key = "chartKey_Business" + i;
%>
<uix:rowLayout>
 <uix:dataScope currentDataBinding='<%= key+"@servletRequest" %>'>
  <uix:header textBinding="title">
   <uix:stackLayout>
    <uix:link destinationBinding="link">
    <oem:chart titleBinding="title" titleVisible="false" chartType="timeSeriesChart" widthBinding="width" heightBinding="height" orientation="vertical" seriesColorsAutomatic="true" legendPosition="south" legendVisible="false" warningThresholdBinding="warning" criticalThresholdBinding="critical" shortDescBinding="imageName"> <uix:contents>
      <oem:boundChartDataSource chartDataSourceBinding="chartDataSource"/>
      <oem:chartColumn isTimeColumn="true" displayLabel="" sourceIndex="0"/>
      <oem:chartColumn displayLabel="" sourceIndex="1"/> </uix:contents>
    </oem:chart> 
    </uix:link>
    <uix:spacer height="5"/>
   </uix:stackLayout>
  </uix:header>
 </uix:dataScope>
</uix:rowLayout>
<% } %>
   </uix:cellFormat>
    </uix:header> 
  </uix:rowLayout>
 </uix:contents> </uix:tableLayout>
 
</uix:form>
</uix:dataScope>
</oem:pageSegment>
