<%-- * Copyright (c) 2003, 2004, Oracle. All rights reserved.  
 *
 *      NAME
 *       svcHomeGeneralSegment.jsp
 *
 *      NOTES
 *       Service Home Page General segment
 *
 * MODIFIED
 *    ssukavan 06/28/05 - ADA fix add tip 
 *    pratagar 06/20/05 - OnChange
 *    pratagar 05/20/05 - Ada Voilation 
 *    jpyang   05/05/05 - add metric errors
 *    jpyang   03/02/05 - fix no alerts message 
 *    jpyang   10/27/04 - 
 *    jpyang   10/18/04  - 
 *    jpyang   10/06/04  - jpyang_aggsvc_home_1
 *    jpyang   09/27/04  - creation
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<oem:pageSegment>
  <uix:dataScope>
  <uix:bundle name="sdkMsg"
                  class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="aggSvcMsg"
              class="oracle.sysman.eml.target.svc.AggSvcMsg"/>

    <uix:form name="alertsSegForm" method="POST">
    <uix:formValue name="eventName" valueBinding="event@alertsSegBean@servletRequest" />
    <uix:header textBinding="ALERTS@sdkMsg">
      <uix:rowLayout renderedBinding="showMetricErrors@alertsSegBean@servletRequest">
        <uix:styledText styleClass="OraPromptText" textBinding="METRIC_COLLECTION_ERRORS@sdkMsg"/>
        <uix:spacer width="5"/>
        <uix:image sourceBinding="errorImage@alertsSegBean@@servletRequest"
                   shortDescBinding="METRIC_COLLECTION_ERRORS@sdkMsg"/>
        <uix:spacer width="5"/>
        <uix:styledText styleClass="OraDataText" 
             textBinding="errorCount@alertsSegBean@servletRequest" 
             destinationBinding="errorCountDest@alertsSegBean@servletRequest"/>
      </uix:rowLayout>

      <uix:spacer height="7"/>

      <uix:messageChoice name="alertsChoice" 
                         onChange="submitForm('alertsSegForm', true, {'event':'alertsSegForm_alertsChoice'})"
                         promptBinding="VIEW@sdkMsg" 
                         selectedValueBinding="selectedAlertsChoice@alertsSegBean@servletRequest">
        <uix:contents childDataBinding="alertTypesList@alertsSegBean@servletRequest">
          <uix:option textBinding="text" valueBinding="value"/>
        </uix:contents>
      </uix:messageChoice>
    
      <uix:table name="alertsTable" 
                 id="alertsTable"
                 partialRenderMode="self"
                 alternateTextBinding="NO_ALERT_FOUND@mntrResourceBundle"
                 width="90%"
                 blockSize="25"
                 valueBinding="value@alertsSegBean@servletRequest"
                 summaryBinding="ALERTS@sdkMsg"
                 minValueBinding="minValue@alertsSegBean@servletRequest"
                 maxValueBinding="maxValue@alertsSegBean@servletRequest"
                 formSubmitted="true"
                 tableDataBinding="alertsTableData@alertsSegBean@servletRequest"
                 columnFormatsBinding="alertsColumnFormats@alertsSegBean@servletRequest"
                 columnHeaderDataBinding="alertsColumnHeaderData@alertsSegBean@servletRequest">
    
         <uix:tableFormat tableBanding="rowBanding"/>
    
         <uix:columnHeaderStamp>
           <uix:sortableHeader textBinding="text"
                               sortableBinding="sortable"/>
         </uix:columnHeaderStamp>
       <uix:contents>
         <uix:styledText textBinding="targetName" destinationBinding="targetDest"/> 
         <uix:styledText textBinding="targetType"/> 
         <uix:image shortDescBinding="severityDesc" sourceBinding="severity"/> 
         <uix:styledText textBinding="openSince"/> 
         <uix:styledText textBinding="message" destinationBinding="messageDest"/> 
       </uix:contents>
     </uix:table>
    </uix:header>
   </uix:form>
  </uix:dataScope>
</oem:pageSegment>
