<%-- * Copyright (c) 2003, 2004, Oracle. All rights reserved.  
 *
 *      NAME
 *       svcHomeGeneralSegment.jsp
 *
 *      NOTES
 *       Service Home Page General segment
 *
 * MODIFIED
 *    mfidanbo 04/12/07 - add avail delay
 *    eporter  02/22/06 - Add Business alerts 
 *    ssukavan 06/26/05  - ADA fix add tip 
 *    jriel    06/28/05  - add svc impact count 
 *    yxie     06/10/05  - fix bug 4418751 
 *    jpyang   05/02/05  - 
 *    yxie     03/17/05  - add pending changes
 *    mfidanbo 03/10/05  - fix RBs 
 *    yxie     03/02/05  - show blackout button
 *    jpyang   02/10/05  - show pol violation whe num > 0 
 *    jpyang   11/08/04  - fix tablelayout 
 *    jpyang   10/30/04  - commented out CSA links
 *    jpyang   10/21/04  - add resource bundles
 *    asaraswa 10/19/04  - adding CSA links to general page segment 
 *    jpyang   10/06/04  - jpyang_aggsvc_home_1
 *    jpyang   09/27/04  - creation
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<oem:pageSegment>
  <uix:dataScope>
  <uix:bundle name="sdkMsg"
                  class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="aggSvcMsg"
              class="oracle.sysman.eml.target.svc.AggSvcMsg"/>
  <uix:bundle name="slMsg"
              class="oracle.sysman.resources.eml.ip.emr.services.ServicesMsg"/>
  <uix:bundle name="gensvcMsg"
              class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle"/>
  <uix:header textBinding="GENERAL@sdkMsg" size="1">
    <uix:borderLayout>
      <uix:tableLayout>
        <uix:contents>
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:styledText 
                     textBinding="STATUS@sdkMsg"
                     styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText 
                     textBinding="currentStatus@genSegBean@servletRequest"
                     styleClass="OraDataText"/>
                  <uix:spacer width="10"/>
                  <!-- Begin Blackouts Links -->
                  <oem:license>
                  <uix:button textBinding="END_BLACKOUT@sdkMsg"
                              shortDescBinding="END_BLACKOUT@sdkMsg"
                              destinationBinding="blackoutsLinkDest@genSegBean@servletRequest"
                              renderedBinding="isStopBlackout@genSegBean@servletRequest"/>
                  </oem:license>
                  <oem:license>
                  <uix:button textBinding="CREATE_BLACKOUT@sdkMsg"
                              shortDescBinding="CREATE_BLACKOUT@sdkMsg"
                              destinationBinding="blackoutsLinkDest@genSegBean@servletRequest"
                              renderedBinding="isCreateBlackout@genSegBean@servletRequest"/>
                  </oem:license>
                  <!-- End Blackouts Links -->        
                </uix:cellFormat>        
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:spacer height="3"/>
              </uix:rowLayout>
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:styledText 
                     textBinding="sinceText@genSegBean@servletRequest"
                     styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText 
                     textBinding="statusSince@genSegBean@servletRequest"
                     styleClass="OraDataText"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:spacer height="3"/>
              </uix:rowLayout>
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:styledText 
                     textBinding="AVAIL_DELAY_LABEL@gensvcMsg"
                     styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText 
                     textBinding="availDelay@genSegBean@servletRequest"
                     styleClass="OraDataText"/>
                </uix:cellFormat>
              </uix:rowLayout>


              <uix:rowLayout width="100%" renderedBinding="showSvcsImpacted@svcsImpacted@servletRequest" >
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:styledText 
                     textBinding="label@svcsImpacted@servletRequest"
                     styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText 
                     textBinding="value@svcsImpacted@servletRequest"
                     destinationBinding="destination@svcsImpacted@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>              

              <uix:rowLayout>
                <uix:spacer height="3"/>
              </uix:rowLayout>
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:styledText 
                     textBinding="AVAILABILITY_PCT@sdkMsg"
                     styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText 
                     textBinding="availPct@genSegBean@servletRequest"
                     styleClassBinding="availPctStyle@genSegBean@servletRequest"
                     destinationBinding="availPctDestination@genSegBean@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:spacer height="3"/>
              </uix:rowLayout>
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:styledText 
                     text=""
                     styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                  <uix:rowLayout>
                  <uix:styledText 
                     textBinding="LAST_24_HINT@sdkMsg"
                     styleClass="OraInlineInfoText"/>
                  </uix:rowLayout>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout width="100%" renderedBinding="isTargetUp@genSegBean@servletRequest">
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:styledText 
                     textBinding="PERFORMANCE@aggSvcMsg"
                     styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                  <uix:image
                     sourceBinding="perfIcon@genSegBean@servletRequest"
                     destinationBinding="perfIconDest@genSegBean@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout renderedBinding="isTargetUp@genSegBean@servletRequest">
                <uix:spacer height="3"/>
              </uix:rowLayout>
              
              <uix:rowLayout width="100%" renderedBinding="isTargetUp@genSegBean@servletRequest">
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:styledText 
                     textBinding="USAGE@aggSvcMsg"
                     styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                  <uix:image
                     sourceBinding="usageIcon@genSegBean@servletRequest" 
                     destinationBinding="usageIconDest@genSegBean@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout renderedBinding="isTargetUp@genSegBean@servletRequest">
                <uix:spacer height="3"/>
              </uix:rowLayout>
              
              <uix:rowLayout width="100%" renderedBinding="showBusinessIcon@genSegBean@servletRequest">
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:styledText 
                     textBinding="BUSINESS@aggSvcMsg"
                     styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                  <uix:image
                     sourceBinding="businessIcon@genSegBean@servletRequest" 
                     destinationBinding="businessIconDest@genSegBean@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout renderedBinding="showBusinessIcon@genSegBean@servletRequest">
                <uix:spacer height="3"/>
              </uix:rowLayout>
              
              <uix:rowLayout width="100%" vAlign="top" renderedBinding="showPolCount@genSegBean@servletRequest">
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:styledText 
                     textBinding="POLICY_VIOLATIONS@mntrResourceBundle"
                     styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                  <uix:flowLayout>
                  <uix:image 
                     sourceBinding="critImage@genSegBean@servletRequest" />
                  <uix:spacer width="5"/>
                  <uix:styledText 
                     textBinding="polWarning@genSegBean@servletRequest"
                     styleClass="OraInstructionText"
                     destinationBinding="polWarningDest@genSegBean@servletRequest" />
                  <uix:spacer width="5"/>
                  <uix:image 
                     sourceBinding="warnImage@genSegBean@servletRequest" />
                  <uix:spacer width="5"/>
                  <uix:styledText 
                     textBinding="polCritical@genSegBean@servletRequest"
                     styleClass="OraInstructionText"
                     destinationBinding="polCriticalDest@genSegBean@servlerRequest" />

                  </uix:flowLayout>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:styledText 
                     textBinding="ACTUAL_SERVICE_LEVEL@slMsg"
                     styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText 
                     textBinding="actualSL@genSegBean@servletRequest"
                     styleClass="OraInstructionText"
                     destinationBinding="actualSLDest@genSegBean@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:spacer height="3"/>
              </uix:rowLayout>
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:styledText 
                     text=""
                     styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                  <uix:rowLayout>
                  <uix:styledText 
                     textBinding="LAST_24_HINT@sdkMsg"
                     styleClass="OraInlineInfoText"/>
                  </uix:rowLayout>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:styledText 
                     textBinding="EXPECTED_SERVICE_LEVEL@slMsg"
                     styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText 
                     textBinding="expectedSL@genSegBean@servletRequest"
                     styleClass="OraInstructionText" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout renderedBinding="showPendingChanges@genSegBean@servletRequest">>
                <uix:spacer height="3"/>
              </uix:rowLayout>
              <uix:rowLayout width="100%" renderedBinding="showPendingChanges@genSegBean@servletRequest">
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:styledText 
                     textBinding="PENDING_CHANGES@gensvcMsg"
                     styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText 
                     textBinding="pendingChangesNum@genSegBean@servletRequest"
                     styleClass="OraInstructionText"
                     destinationBinding="pendingChangesDest@genSegBean@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout width="100%" renderedBinding="renderCSALinks@genSegBean@servletRequest">
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:styledText
                     textBinding="NUM_COLLECTIONS@csaBundle"
                     styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                  <uix:link
                     textBinding="numClients@genSegBean@servletRequest"
                     destinationBinding="clientDest@genSegBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:spacer height="3"/>
              </uix:rowLayout>

        </uix:contents>
      </uix:tableLayout>
      <uix:left>
        <uix:image sourceBinding="trafficIconSource@genSegBean@servletRequest" 
                   destinationBinding="statusHistoryDest@aggSvcHome@servletRequest"
                   shortDescBinding="currentStatus@genSegBean@servletRequest" />
      </uix:left>
    </uix:borderLayout>
  </uix:header> 
  </uix:dataScope>
</oem:pageSegment>
