<%-- * Copyright (c) 2003, 2004, Oracle. All rights reserved.  
 *
 *      NAME
 *       svcHomeGeneralSegment.jsp
 *
 *      NOTES
 *       Service Home Page General segment
 *
 * MODIFIED
 *    jpyang   08/01/05 - 
 *    ssukavan 06/26/05 - ADA fix add tips  
 *    jpyang   02/28/05 - show critical alerts first 
 *    dtsao    01/04/05 - use own resource bundles 
 *    jpyang   12/07/04 - key component status drill down 
 *    jpyang   10/06/04  - jpyang_aggsvc_home_1
 *    jpyang   09/27/04  - creation
 *
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<oem:pageSegment>
    <uix:dataScope>
        <uix:bundle name="aggSvcMsg"
                      class="oracle.sysman.eml.target.svc.AggSvcMsg"/>
        <uix:bundle name="mntrResourceBundle"
                  class="oracle.sysman.resources.MntrResourceBundle"/>
        <uix:renderingContext id="renderingContext">
            <oem:setURLEncoder id="renderingContext" />
            <uix:header textBinding="SUBSERVICES@aggSvcMsg">
              <uix:hGrid id="metrics" width="100%" 
                         destinationBinding="destination@subsvcsSegBean@servletRequest" 
                         summaryBinding="ALL_METRICS_SUMMARY@mntrResourceBundle" 
                         columnFormatsBinding="columnFormats@subsvcsSegBean@servletRequest" 
                         columnHeaderDataBinding="subservicesColumnHeaderData@subsvcsSegBean@servletRequest" 
                         treeDataBinding="treeData@subsvcsSegBean@servletRequest" 
                         proxied="true"
                         formSubmitted="true"
                         proxyBinding="proxy@servletRequest">
                <uix:nodeStamp>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="NAME@mntrResourceBundle"/>
                    </uix:columnHeader>
                    <uix:styledText textBinding="text" destinationBinding="targetDest"/>
                  </uix:column>
                </uix:nodeStamp>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="TYPE@mntrResourceBundle"/>
                  </uix:columnHeader>
                  <uix:styledText textBinding="targetType"/>
                </uix:column>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="STATUS@mntrResourceBundle"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="iconButtonFormat" />
                  <uix:image sourceBinding="currentStatusSrc"
                             destinationBinding="availDest"
                             shortDescBinding="currentStatusShortDesc"/>
                </uix:column>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="PERF_ALERTS@mntrResourceBundle"/>
                  </uix:columnHeader>
                  <uix:dataScope>
                    <uix:styledText inlineStyleBinding="criticalStyle"
                                    textBinding="perfCriticalCountNameKey"
                                    destinationBinding="perfCriticalDestKey"
                                    shortDescBinding="perfCriticalShortDesc"/>
                    <uix:spacer width="10"/>
                    <uix:styledText inlineStyleBinding="warningStyle"
                                    textBinding="perfWarningCountNameKey"
                                    destinationBinding="perfWarningDestKey"
                                    shortDescBinding="perfWarningShortDesc"/>
                  </uix:dataScope>
                  <uix:columnFormat columnDataFormat="numberFormat" />
                </uix:column>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="USAGE_ALERTS@mntrResourceBundle"/>
                  </uix:columnHeader>
                  <uix:dataScope>
                    <uix:styledText inlineStyleBinding="criticalStyle" 
                                    textBinding="usageCriticalCountNameKey"
                                    destinationBinding="usageCriticalDestKey"
                                    shortDescBinding="usageCriticalShortDesc"/>
                    <uix:spacer width="10"/>
                    <uix:styledText inlineStyleBinding="warningStyle" 
                                    textBinding="usageWarningCountNameKey"
                                    destinationBinding="usageWarningDestKey"
                                    shortDescBinding="usageWarningShortDesc"/>
                  </uix:dataScope>
                  <uix:columnFormat columnDataFormat="numberFormat" />
                </uix:column>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="POLICY_VIOLATIONS@mntrResourceBundle"/>
                  </uix:columnHeader>
                  <uix:dataScope>
                    <uix:styledText inlineStyleBinding="criticalStyle" 
                                    textBinding="policyCriticalCountName"
                                    destinationBinding="policyCriticalDest"
                                    shortDescBinding="policyCriticalShortDesc"/>
                    <uix:spacer width="10"/>
                    <uix:styledText inlineStyleBinding="warningStyle" 
                                    textBinding="policyWarningCountName"
                                    destinationBinding="policyWarningDest"
                                    shortDescBinding="policyWarningShortDesc"/>
                    <uix:spacer width="10"/>
                    <uix:styledText inlineStyleBinding="policyInformationStyle" 
                                    textBinding="policyInformationCountName"
                                    destinationBinding="policyInformationDest"
                                    shortDescBinding="policyInformationShortDesc"/>
                  </uix:dataScope>
                  <uix:columnFormat columnDataFormat="numberFormat" />
                </uix:column>
            
                <uix:columnGroup>
                  <uix:columnHeader>
                    <uix:text textBinding="SYSTEM@mntrResourceBundle"/>
                  </uix:columnHeader>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="NAME@mntrResourceBundle"/>
                    </uix:columnHeader>
                    <uix:styledText textBinding="systemNameKey"
                                    destinationBinding="systemDest"/>
                  </uix:column>
                  <uix:columnGroup>
                    <uix:columnHeader>
                      <uix:text textBinding="KEY_COMPONENTS@mntrResourceBundle" />
                    </uix:columnHeader>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:text textBinding="STATUS@mntrResourceBundle" />
                      </uix:columnHeader>
                      <uix:dataScope>
                        <uix:image sourceBinding="systemDownImageKey"
                                   shortDescBinding="systemDownShortDesc"/>
                        <uix:link textBinding="systemDownNameKey"
                                  destinationBinding="systemDownDestKey"/>
                        <uix:spacer width="10"/>
                        <uix:image sourceBinding="systemUpImageKey"
                                   shortDescBinding="systemUpShortDesc"/>
                        <uix:link textBinding="systemUpNameKey"
                                  destinationBinding="systemUpDestKey"/> 
                      </uix:dataScope>
                    <uix:columnFormat columnDataFormat="numberFormat" />
                    </uix:column>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:text textBinding="ALERTS@mntrResourceBundle"/>
                      </uix:columnHeader>
                    <uix:dataScope>
                      <uix:styledText inlineStyleBinding="criticalStyle" 
                                      textBinding="systemCriticalNameKey"
                                      destinationBinding="systemCriticalDest"
                                      shortDescBinding="systemCriticalShortDesc"/>
                      <uix:spacer width="10"/>
                      <uix:styledText inlineStyleBinding="warningStyle" 
                                      textBinding="systemWarningNameKey"
                                      destinationBinding="systemWarningDest"
                                      shortDescBinding="systemWarningShortDesc"/>
                      <uix:styledText textBinding="noData"/>
                    </uix:dataScope>
                    <uix:columnFormat columnDataFormat="numberFormat" />
                    </uix:column>
                  </uix:columnGroup>
                </uix:columnGroup>
              </uix:hGrid>
            </uix:header>
        </uix:renderingContext>
    </uix:dataScope>
</oem:pageSegment>
