<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext' %>

<oem:pageSegment>
    <uix:renderingContext id="renderingContext">
        <oem:setURLEncoder id="renderingContext" />
        <uix:messageBox
            messageBinding="servicesTableMessage@"
            messageTypeBinding="servicesTableMessageType@" 
            renderedBinding = "renderMessage@"
        />
          <uix:header textBinding="header@">
          <uix:table name="svcTable"
                     tableDataBinding="svcList"
                     blockSizeBinding="blockSize"
                     valueBinding="value"
                     showAll="yes"
                     summaryBinding="header@"		     
                     minValue="1"
                     maxValueBinding="listMaxSize"
                     tableFormatBinding="tableFormat"
                     alternateTextBinding="alter"
                     columnHeaderDataBinding="columnHeader"
                     columnFormatsBinding="columnFormats"
                     width="100%"
                     formSubmitted="true"
                     >
              <uix:columnHeaderStamp>
                  <uix:sortableHeader textBinding="text"
                                      sortableBinding="sortable"/>
              </uix:columnHeaderStamp>
              <uix:column id="nameColumn">
                <uix:columnHeader>
                  <uix:sortableHeader textBinding="text"
                                      sortableBinding="sortable"/>
                </uix:columnHeader>
                <uix:link textBinding="targetName"
                          destinationBinding="targetNamedestination"
                          shortDescBinding="targetName"/>
              </uix:column>
              <uix:column id="typeColumn">
                <uix:styledText textBinding="typeName"
                                shortDescBinding="typeName"/>
              </uix:column>
              <uix:column id="statusColumn">
                <uix:image sourceBinding="currentStatusSrc"
                           destinationBinding="availDest"
                           shortDescBinding="availShortDesc" />
              </uix:column>
              <uix:column id="performanceColumn">
                <uix:rowLayout>
                  <uix:link textBinding="perfCriticalCountNameKey"
                            shortDescBinding="perfCriticalCountNameKey"
                            destinationBinding="perfCriticalDestKey"
                            inlineStyleBinding="criticalStyle"/>
                  <uix:spacer width="10" />
                  <uix:link textBinding="perfWarningCountNameKey"
                            shortDescBinding="perfWarningCountNameKey"
                            destinationBinding="perfWarningDestKey"
                            inlineStyleBinding="warningStyle" />
                </uix:rowLayout>
              </uix:column>
              <uix:column id="alertColumn">
                <uix:rowLayout >
                  <uix:link textBinding="usageCriticalCountNameKey"
                            shortDescBinding="usageCriticalCountNameKey"
                            destinationBinding="usageCriticalDestKey"
                            inlineStyleBinding="criticalStyle" />
                  <uix:spacer width="10" />
                  <uix:link textBinding="usageWarningCountNameKey"
                            shortDescBinding="usageWarningCountNameKey"
                            destinationBinding="usageWarningDestKey"
                            inlineStyleBinding="warningStyle" />
                </uix:rowLayout>
              </uix:column>
              <uix:column id="policyColumn">
                <uix:rowLayout>
                  <uix:link textBinding="policyCriticalCountName"
                            shortDescBinding="policyCriticalCountName"
                            destinationBinding="policyCriticalDest"
                            inlineStyleBinding="criticalStyle" />
                  <uix:spacer width="10" />
                  <uix:link textBinding="policyWarningCountName"
                            shortDescBinding="policyWarningCountName"
                            destinationBinding="policyWarningDest"
                            inlineStyleBinding="warningStyle" />
                  <uix:spacer width="10" />
                  <uix:link textBinding="policyInformationCountName"
                            shortDescBinding="policyInformationCountName"
                            destinationBinding="policyInformationDest"
                            inlineStyleBinding="informationStyle" />
                </uix:rowLayout>
              </uix:column>
            </uix:table>
          </uix:header>
    </uix:renderingContext>
</oem:pageSegment>
