<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<%@ include file="/oemNoscript.jspf" %>
<script language="javascript">
    window.focus();
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="TrackResourceBundle" class="oracle.sysman.eml.ecm.resources.TrackResourceBundle"/>
  <uix:bundle name="EcmResourceBundle" class="oracle.sysman.eml.ecm.util.EcmResourceBundle"/>
  <uix:bundle name="sdkUIBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="systemdashboardrb" class="oracle.sysman.eml.rsc.target.sys.SystemDashboardMsg"/>
  <uix:document>
    <uix:head titleBinding="header@iconlegendbean@servletRequest"/>
    <uix:body>
      <uix:form name="iconLegendForm" method="POST">
        <%@ include file=" /oemGlobal.jspf"%>
        <uix:contents>
          <uix:stackLayout>
            <uix:tableLayout width="100%">
             
             <uix:rowLayout styleClass="OraEmDashboardGroupHeaderNormalLine">
              <uix:cellFormat height="1">
                <uix:styledText text=" " />
                </uix:cellFormat>
              </uix:rowLayout> 
             
             <uix:rowLayout styleClass="OraEmDashboardGroupHeaderNormal" hAlign="left" width="100%">
                <uix:cellFormat height="20">
                <uix:spacer width="5"/>
                <uix:link styleClass="OraEmDashboardGroupHeaderNormal" 
                textBinding="LEGEND_HEADER@systemdashboardrb"/>
                </uix:cellFormat>
              </uix:rowLayout>
              
             <uix:rowLayout styleClass="OraEmDashboardGroupHeaderNormalLine">
              <uix:cellFormat height="1">
                <uix:styledText text=" " />
                </uix:cellFormat>
              </uix:rowLayout> 
              
              <uix:rowLayout width="100%">
                <uix:spacer height="10"/>
              </uix:rowLayout>
             
             <uix:rowLayout styleClass="OraEmDashboardTargetColumnHeader" hAlign="left" width="100%">
                <uix:cellFormat height="20" vAlign="middle">
                <uix:spacer width="5"/>
                <uix:link  styleClass="OraEmDashboardTargetColumnHeader" 
                textBinding="TARGET_STATUS@systemdashboardrb"/>
                </uix:cellFormat>
              </uix:rowLayout>
              
              <uix:rowLayout width="100%">
                <uix:spacer height="10"/>
              </uix:rowLayout>

              <uix:rowLayout hAlign="center" width="100%">
                  <uix:table name="TargetStatusTable" id="TargetStatusTable" 
                    width="100%"  
                    formSubmitted="true" 
                    summaryBinding="TARGET_LEGEND@systemdashboardrb"
                    tableDataBinding="tableDataKey@targetStatusTableData@iconlegendbean@servletRequest" 
                    columnFormatsBinding="targetStatusColumnFormats@iconlegendbean@servletRequest" 
                    columnHeaderDataBinding="columnHeaderDataTargetStatus@iconlegendbean@servletRequest"> 
                    <uix:tableFormat tableBanding="rowBanding"/>
                    <uix:columnHeaderStamp>
                     <uix:sortableHeader styleClass="OraEmDashboardLegendColumnHeader" 
                        textBinding="text"/>
                    </uix:columnHeaderStamp>
                    <uix:contents>
                      <uix:image sourceBinding="status" />
                      <uix:link styleClass="OraEmDashboardNonCompactTableCellStyle" 
                        textBinding="name" />
                      <uix:link styleClass="OraEmDashboardNonCompactTableSpaceStyle" 
                        textBinding="description" />
                    </uix:contents>
                  </uix:table>
                </uix:rowLayout>
                 
                 <uix:rowLayout hAlign="center" width="100%">
                <uix:spacer height="20"/>
                </uix:rowLayout>
                 
                 <uix:rowLayout styleClass="OraEmDashboardTargetColumnHeader" hAlign="left" width="100%">
                <uix:cellFormat height="20" vAlign="middle">
                <uix:spacer width="5"/>
                <uix:link  styleClass="OraEmDashboardTargetColumnHeader" 
                textBinding="METRIC_STATUS@systemdashboardrb"/>
                </uix:cellFormat>
                </uix:rowLayout>
                
              <uix:rowLayout width="100%">
                <uix:spacer height="10"/>
              </uix:rowLayout>

                <uix:rowLayout>
                  <uix:table name="MetricStatusTable" id="MetricStatusTable" 
                    width="100%"  
                    formSubmitted="true" 
                    summaryBinding="METRIC_LEGEND@systemdashboardrb"
                    tableDataBinding="tableDataKey@metricStatusTableData@iconlegendbean@servletRequest" 
                    columnFormatsBinding="metricStatusColumnFormats@iconlegendbean@servletRequest" 
                    columnHeaderDataBinding="columnHeaderDataMetricStatus@iconlegendbean@servletRequest"> 
                    <uix:tableFormat tableBanding="rowBanding"/>
                    <uix:columnHeaderStamp>
                     <uix:sortableHeader styleClass="OraEmDashboardLegendColumnHeader" 
                        textBinding="text"/>
                    </uix:columnHeaderStamp>
                    <uix:contents>
                      <uix:image sourceBinding="status" />
                      <uix:link styleClass="OraEmDashboardNonCompactTableCellStyle" 
                        textBinding="name" />
                      <uix:link styleClass="OraEmDashboardNonCompactTableSpaceStyle" 
                        textBinding="description" />
                    </uix:contents>
                  </uix:table>
                  
                </uix:rowLayout>
                
                <uix:rowLayout>
                <uix:spacer height="10"/>
                </uix:rowLayout>
                
                <uix:rowLayout hAlign="right" width="100%">
                <uix:pageButtonBar >
              <uix:button textBinding="CLOSE_LEGEND@systemdashboardrb" 
                          shortDescBinding="CLOSE_LEGEND@systemdashboardrb"
                          name="close" onClick="window.close()"/>
            </uix:pageButtonBar>
                </uix:rowLayout>
              </uix:tableLayout>
          </uix:stackLayout>
        </uix:contents>
      </uix:form>
      
    </uix:body>
  </uix:document>
</uix:renderingContext>
