<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<%@ include file=" /oemNoscript.jspf" %>
<%      
  oracle.sysman.eml.ip.render.elem.system.SysDashRenderBean sdb = 
    ((oracle.sysman.eml.ip.render.elem.system.SysDashRenderBean)
  request.getAttribute("systemdashboardbean"));
  String refFreq = sdb.getrefFreq();
  try
  {
    refFreq =  "" + Integer.parseInt(refFreq)*1000;
  }
  catch (Exception e)
  {
    refFreq = "180000";
  }
%>

<script language="javaScript">
function doAutoRefresh()
{
  submitForm('viewForm',1,{'event':'Refresh'});return false;
}
setInterval(doAutoRefresh, "<%=refFreq%>");
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="TrackResourceBundle" class="oracle.sysman.eml.ecm.resources.TrackResourceBundle"/>
  <uix:bundle name="EcmResourceBundle" class="oracle.sysman.eml.ecm.util.EcmResourceBundle"/>
  <uix:bundle name="sdkUIBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="systemdashboardrb" class="oracle.sysman.eml.rsc.target.sys.SystemDashboardMsg"/>

  <uix:document>

    <uix:head titleBinding="header@systemdashboardbean@servletRequest"/>

    <%@ include file=" /enablePPR.jspf"%>

    <uix:body>

      <uix:form name="viewForm" method="POST">
      <%@ include file=" /oemGlobal.jspf"%>

      <uix:contents>

      <%-- error to be reported to end user if applicable --%>
        <uix:stackLayout rendered="false"
                         renderedBinding="showError@systemdashboardbean@servletRequest">
          <uix:contents>
            <uix:messageBox messageBinding="errorMessage@systemdashboardbean@servletRequest"
                            messageTypeBinding="messageType@systemdashboardbean@servletRequest"
                            textBinding="errorMessageTitle@systemdashboardbean@servletRequest"/>
          </uix:contents>
        </uix:stackLayout>
        
      <%-- No error to be reported to end user --%>
        <uix:stackLayout rendered="true" renderedBinding="showContent@systemdashboardbean@servletRequest">
          
          <%-- In this tableLayout, show the icon and customize and help links too --%>
          <uix:tableLayout width="100%">
            <uix:rowLayout  width="100%" >
              <uix:cellFormat hAlign="left" vAlign="middle">
                <%--<uix:image source="/em/images/sysdash_Oracle.gif"/>
                <uix:spacer width="1"/>
                <uix:styledText textBinding="SYSTEM_DASHBOARD@systemdashboardrb" 
                                styleClass="OraEmDashboardPageHeader"/>--%>
                <uix:image source="/em/images/bannerOemLight.gif"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="right">
                <uix:styledText textBinding="CUSTOMIZE@systemdashboardrb" 
                                shortDescBinding="CUSTOMIZE@systemdashboardrb"
                                styleClass="OraGlobalLinks"
                                destinationBinding="customize@systemdashboardbean@servletRequest"/>
                <uix:spacer width="3"/>
                <uix:styledText text = " | "
                                styleClass="OraGloballinks"/>
                <uix:spacer width="3"/>
                <uix:styledText textBinding="HELP@commonResourceBundle" 
                                shortDescBinding="HELP@commonResourceBundle"
                                styleClass="OraGlobalLinks"
                                destinationBinding="helpLink@systemdashboardbean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
          
          <%-- In this tableLayout, show the GroupName, refresh time and Full/Rollup View table --%>
          <uix:tableLayout width="100%" >
            
            <%-- In this rowLayout show the Line on the top--%>
            <uix:rowLayout styleClass="OraEmDashboardGroupHeaderLine">
              <uix:cellFormat height="2">
                <uix:styledText text=" " />
              </uix:cellFormat>
            </uix:rowLayout>
            
            <%-- In this rowLayout show the name and refresh,etc--%>
            <uix:rowLayout styleClassBinding="targetHeaderBackground@systemdashboardbean@servletRequest">
              <uix:rowLayout width="100%">

                <uix:cellFormat height="22" vAlign="middle" hAlign="left" width="50%">
                  <uix:spacer width="10"/> 
                  <uix:styledText styleClassBinding="targetHeaderBackground@systemdashboardbean@servletRequest" 
                              textBinding="targetHeader@systemdashboardbean@servletRequest" 
                              destinationBinding="targetHomePage@systemdashboardbean@servletRequest"/>
                  <uix:styledText styleClassBinding="targetHeaderBackground@systemdashboardbean@servletRequest"
                              textBinding="targetHeaderAddition@systemdashboardbean@servletRequest"/>
                </uix:cellFormat>

                <uix:cellFormat hAlign="right" height="22" vAlign="middle" width="50%">
                  <uix:styledText styleClass="OraEmDashboardPageRefresh" 
                                  textBinding="PAGE_REFRESHED_TIME@sdkUIBundle"/>
                  <uix:spacer width="5"/>
                  <uix:styledText styleClass="OraEmDashboardTimeDate" 
                                  textBinding="timestamp@systemdashboardbean@servletRequest"/>
                  <uix:spacer width="5"/>  
                  <uix:submitButton styleClass="OraInstructionText" 
                                    textBinding="REFRESH_BUTTON@mntrResourceBundle" 
                                    shortDescBinding="REFRESH_BUTTON@mntrResourceBundle"
                                    name="event" value="REFRESH"/>  
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:rowLayout>
            
            <%-- In this rowLayout show the Line at the bottom--%>
            <uix:rowLayout styleClass="OraEmDashboardGroupHeaderNormalLine">
              <uix:cellFormat height="1">
                <uix:styledText text= " "/>
              </uix:cellFormat>
            </uix:rowLayout>
            
            <uix:rowLayout>
              <uix:spacer height="4"/>
            </uix:rowLayout>
            
            <%-- In this rowLayout show the Targets or Rollup table--%>
            <uix:rowLayout hAlign="center" width="100%">
              <uix:cellFormat>
                <uix:switcher childNameBinding="selectedView@systemdashboardbean@servletRequest">

                  <uix:case name="Full">
                    <uix:stackLayout >
                      <uix:contents>
                        <uix:rowLayout width="100%">
                          <uix:include nodeBinding="targetTable@systemdashboardbean@servletRequest"/>
                        </uix:rowLayout> 
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:case> 

                  <uix:case name="Rollup">
                    <uix:stackLayout >
                      <uix:contents>
                        <uix:rowLayout width="100%">
                          <uix:include nodeBinding="rollupTable@systemdashboardbean@servletRequest"/>
                        </uix:rowLayout> 
                      </uix:contents>
                    </uix:stackLayout>  
                  </uix:case>
              </uix:switcher>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
       
        <uix:tableLayout width="100%" >
          <uix:rowLayout>
            <uix:spacer height="6"/>
          </uix:rowLayout>
          
          <uix:rowLayout styleClass="OraEmDashboardGroupHeaderLine">
            <uix:cellFormat height="2">
              <uix:styledText text=" " />
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>

        <%-- In this tableLayout show the Alerts header and down/critical/warning info--%>
        <uix:tableLayout width="100%" >
          <uix:rowLayout styleClass="OraEmDashboardAlertHeader" hAlign="center" width="97%" 
                         renderedBinding="showAlertsTable@systemdashboardbean@servletRequest">
            <uix:rowLayout >
              <uix:spacer width="5"/>
              <uix:cellFormat hAlign="left" height="22">
                <uix:styledText styleClass="OraEmDashboardAlertHeader" 
                                textBinding="alertHeader@systemdashboardbean@servletRequest"/>
              </uix:cellFormat> 
              <uix:spacer width="8"/>
              <uix:image source="/em/images/sysdash_down.gif" 
                         shortDescBinding="DOWN@sdkUIBundle" 
                         destinationBinding="downDest@systemdashboardbean@servletRequest"/>
              <uix:spacer width="2"/>  
              <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraEmDashboardNonCompactTableCellStyle" 
                                shortDescBinding="DOWN@sdkUIBundle" 
                                textBinding="down@systemdashboardbean@servletRequest" 
                                destinationBinding="downDest@systemdashboardbean@servletRequest"/>
              </uix:cellFormat>
              <uix:spacer width="8"/>
              <uix:image source="/em/images/sysdash_critical.gif" 
                         shortDescBinding="CRITICAL@sdkUIBundle" 
                         destinationBinding="criticalDest@systemdashboardbean@servletRequest"/>
              <uix:spacer width="2"/>  
              <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraEmDashboardNonCompactTableCellStyle" 
                                shortDescBinding="CRITICAL@sdkUIBundle" 
                                textBinding="critical@systemdashboardbean@servletRequest" 
                                destinationBinding="criticalDest@systemdashboardbean@servletRequest"/>
              </uix:cellFormat>
              <uix:spacer width="8"/>
              <uix:image source="/em/images/sysdash_warning.gif" 
                         shortDescBinding="WARNING@sdkUIBundle" 
                         destinationBinding="warningDest@systemdashboardbean@servletRequest"/>
              <uix:spacer width="2"/>  
              <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraEmDashboardNonCompactTableCellStyle" 
                                shortDescBinding="WARNING@sdkUIBundle" 
                                textBinding="warning@systemdashboardbean@servletRequest" 
                                destinationBinding="warningDest@systemdashboardbean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
 
            <uix:rowLayout styleClass="OraEmDashboardGroupHeaderNormalLine">
              <uix:cellFormat height="2">
                <uix:styledText text= " " />
              </uix:cellFormat>
            </uix:rowLayout>

          </uix:rowLayout>

          <uix:rowLayout renderedBinding="showAlertsTable@systemdashboardbean@servletRequest">
            <uix:spacer height="2"/>
          </uix:rowLayout>

          <%-- In this rowLayout show the Alerts exceeded header and info--%>
          <uix:rowLayout width="100%" renderedBinding="showAlertsTable@systemdashboardbean@servletRequest">
            <uix:rowLayout hAlign="left">
              <uix:spacer width="8"/>
              <uix:image source="/em/cabo/images/info.gif" 
                         renderedBinding="showAlertInfo@systemdashboardbean@servletRequest"
                         shortDescBinding="INFORMATION@sdkUIBundle" />
              <uix:spacer width="2"/>
              <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraEmDashboardNonCompactTableSpaceStyle" 
                                renderedBinding="showAlertInfo@systemdashboardbean@servletRequest"
                                shortDescBinding="rowsExceededMsg@systemdashboardbean@servletRequest" 
                                textBinding="rowsExceededMsg@systemdashboardbean@servletRequest" />
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:rowLayout>

          <%-- In this rowLayout show the Alerts table--%>
          <uix:rowLayout hAlign="center" width="100%" renderedBinding="showAlertsTable@systemdashboardbean@servletRequest">
            <uix:cellFormat wrappingDisabled="false">
              <uix:table name="AlertTable" id="AlertTable" 
                         partialRenderMode="self" 
                         summaryBinding="ALERTS_TABLE_DESC@systemdashboardrb"
                         alternateTextBinding="NO_ALERT_FOUND@mntrResourceBundle" 
                         width="100%" blockSize="10" 
                         valueBinding="valueAlert@systemdashboardbean@servletRequest" 
                         minValueBinding="minValue@systemdashboardbean@servletRequest" 
                         maxValueBinding="maxAlertValue@systemdashboardbean@servletRequest" 
                         formSubmitted="true" 
                         tableDataBinding="tableDataKey@alertTableData@systemdashboardbean@servletRequest" 
                         columnFormatsBinding="alertColumnFormats@systemdashboardbean@servletRequest" 
                         columnHeaderDataBinding="columnHeaderDataAlert@systemdashboardbean@servletRequest" 
                         destinationBinding="destination2@systemdashboardbean@servletRequest"
                         showAll="yes">
                <uix:tableFormat tableBanding="rowBanding"/>
                <uix:columnHeaderStamp>
                  <uix:sortableHeader styleClass="OraEmDashboardCompactTableColumnHeadertoo" 
                                      textBinding="text" sortableBinding="sortable"/>
                </uix:columnHeaderStamp>
                <uix:contents>
                  <uix:image sourceBinding="severity" 
                             shortDescBinding="srtDesc" hAlign="center"/>
                  <uix:link styleClass="OraEmDashboardNonCompactTableCellStyle" 
                            textBinding="targetName" destinationBinding="targetdestination1"/>
                  <uix:link styleClass="OraEmDashboardNonCompactTableSpaceStyle" 
                            textBinding="date" destinationBinding="datedestination"/>
                  <uix:link styleClass="OraEmDashboardNonCompactTableCellStyle" 
                            textBinding="message" destinationBinding="messagedestination"/>
                  <uix:formattedText styleClass="OraEmDashboardNonCompactTableSpaceStyle" 
                            textBinding="comment"/>
                </uix:contents>
              </uix:table>
            </uix:cellFormat>
          </uix:rowLayout>
   
          <uix:rowLayout>
            <uix:spacer height="1"/>
          </uix:rowLayout>
 
          <%-- In this rowLayout show the Legend link--%>
          <uix:rowLayout hAlign="right">
            <uix:link textBinding="LEGEND@sdkUIBundle" 
                      shortDescBinding="LEGEND@sdkUIBundle"
                      styleClass="OraEmDashboardNonCompactTableLink" 
                      onClickBinding="legendLink@systemdashboardbean@servletRequest"/>
          </uix:rowLayout>

          <uix:rowLayout>
            <uix:spacer height="3"/>
          </uix:rowLayout>

          <%-- In this rowLayout show the Copyright--%>
          <uix:rowLayout hAlign="left" width="100%" styleClass="OraEmDashboardDateBackGround">
            <uix:cellFormat height="26" vAlign="bottom">
              <uix:formattedText textBinding="copyright@servletRequest" 
                                 styleClass="OraEmDashboardNonCompactTableSpaceStyle"/>
             </uix:cellFormat>
          </uix:rowLayout>

        </uix:tableLayout>
      </uix:stackLayout>
    </uix:contents>
  </uix:form>
</uix:body>
</uix:document>
</uix:renderingContext>
