<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2003, 2004, Oracle. All rights reserved.  
 *
 *      NAME
 *       targetSelection.jsp
 *
 *
 * MODIFIED
 *    rpatti     08/09/04 - remove dummy binding 
 *    jmcclung   11/06/03 - ADA fixes
 *    rdabbott   10/18/03 - move strings to jobs resource 
 *    xshen      10/13/03 - 
 *    xshen      10/13/03 - ui review changes 
 *    xshen      10/09/03 - Modify additional search criteria fields 
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import='java.util.ArrayList'%>
<%@ page import='java.util.HashMap'%>
<%@ page import='java.lang.Boolean'%>
<%@ page import='oracle.cabo.ui.data.DictionaryData'%>

<jsp:useBean
    id="defaultBean"
    scope="request"
    type="oracle.sysman.eml.target.TargetSelectionData"/>


<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="jobsResource"
              class="oracle.sysman.resources.eml.jobs.JobsResource"/>

  <uix:document>

   <%@ include file="/enablePPR.jspf" %>
   <%@ include file="/oemTitle.jspf" %>              

    <uix:body>
     <uix:form name="targetSelectionForm" method="POST">
      <uix:pageLayout titleBinding="CREATE_JOB_ADD_TARGETS@jobsResource">
       <%@ include file="/oemGlobal.jspf" %>

       <%-- Wizard train --%>
       <%
        if (defaultBean.getShowTrainData())
        {
       %>
        <uix:location>
           <uix:train selectedIndexBinding="trainIndex@trainData@defaultBean@servletRequest">
             <uix:contents childDataBinding="trainLegend@trainData@defaultBean@servletRequest">
               <uix:link textBinding="text"/>
             </uix:contents>
           </uix:train>
       </uix:location>
       <%
        }
       %>

       <uix:pageButtons>
         <uix:pageButtonBar>
           <uix:rowLayout rendered="true"
                          renderedBinding="showContents@cacheLossData@defaultBean@servletRequest">
             <uix:submitButton textBinding="CANCEL@commonResourceBundle" 
                               name="event" 
                               value="<%=Constants.CANCEL_EVENT%>"/>
             <uix:spacer height="3"/>                  
             <uix:submitButton textBinding="ADD@commonResourceBundle" 
                               name="event" 
                               value="<%=Constants.ADD_EVENT%>"/>
           </uix:rowLayout>                 
         </uix:pageButtonBar>
       </uix:pageButtons>
        
       <uix:contents>
         <%-- cache loss --%>
         <uix:stackLayout rendered="false"
                          renderedBinding="showCacheLoss@cacheLossData@defaultBean@servletRequest">
           <uix:contents>
             <uix:messageBox messageBinding="CACHE_LOSS_ERROR_MSG@mntrResourceBundle"
                             messageType="error"
                             textBinding="CACHE_LOSS_ERROR_HEADER_MSG@mntrResourceBundle"/>
             <uix:spacer height="10"/>
             <uix:styledText textBinding="CACHE_LOSS_ERROR_CONTINUE_MSG@mntrResourceBundle"
                             destinationBinding="restartDest@cacheLossData@defaultBean@servletRequest"/>
           </uix:contents>
         </uix:stackLayout>
         <% 
             DictionaryData ht = (DictionaryData)defaultBean.getCacheLossData();
             Boolean showContents = (Boolean)ht.selectValue(null, "showContents");
             if (showContents.booleanValue())
             {
         %>
            <uix:header textBinding="SEARCH@sdkUIMsg" >

             <uix:contents>
<%-- 
               <uix:header textBinding="5@sdkUIMsg"> 
                 <uix:stackLayout>
--%>
                   <uix:labeledFieldLayout labelWidth="20%" fieldWidth="80%" > 
                     <%
                      if (defaultBean.getTargetTypes().size() > 1)
                      {
                     %>

                     <uix:messageChoice name="targetType"
                                        promptBinding="TYPE@sdkUIMsg"
                                      	onChange="submitForm('targetSelectionForm', true, 
                                                            {'event':'onChangeTargetType'})"
                                        tipBinding="TYPE_LIMITTED_TIP@jobsResource">
                       <uix:contents childDataBinding="targetTypes@defaultBean@servletRequest">
                         <uix:option textBinding="text"
                                     valueBinding="value"
                                     selectedBinding="selected"
                                     renderedBinding="rendered"/>
                       </uix:contents>
                     </uix:messageChoice>
                     <%
                      } 
                      else if (defaultBean.getTargetTypes().size() == 1)
                      {
                         ArrayList list = defaultBean.getTargetTypes();
                         HashMap map = (HashMap) list.get(0);
                         String text = (String)map.get("text");
                         String val = (String)map.get("value");
                     %>
                     <uix:messageStyledText promptBinding="TYPE@sdkUIMsg"
                                            styleClass="OraDataText"
                                            tipBinding="TGT_SEL_TIP@mntrResourceBundle">
                         <uix:option text="<%=text%>"
                                     value="<%=val%>"
                                     selected="false"/>
                     </uix:messageStyledText>
                     <uix:formValue name="targetType" value="<%=val%>"/>
                     <%
                      } 
                     %>
                     <uix:messageTextInput name="targetName"
                                           promptBinding="NAME@sdkUIMsg"
                                           columns="30"
                                           textBinding="targetName@defaultBean@servletRequest"/>
                   </uix:labeledFieldLayout>
<%--
                   <uix:spacer height="5"/>
                   <uix:submitButton textBinding="SEARCH@sdkUIMsg"
                                     name="event"
                                     shortDescBinding="SEARCH@sdkUIMsg"
                                     value="<%=Constants.SEARCH_EVENT%>"
                                     renderedBinding="showTopButton@searchCriteria@defaultBean@servletRequest"/>

                   <uix:styledText styleClass="OraTipText"
                                   textBinding="searchTipText@defaultBean@servletRequest"
                                   renderedBinding="showTopButton@searchCriteria@defaultBean@servletRequest"/>
                 </uix:stackLayout>
               </uix:header>

               <uix:header textBinding="ADDITIONAL_SEARCH_CRITERIA@sdkUIMsg"
                           renderedBinding="showAllCriteria@searchCriteria@defaultBean@servletRequest">
                 <uix:stackLayout> 

                   <uix:tableLayout renderedBinding="showAllCriteria@searchCriteria@defaultBean@servletRequest">
                     <uix:rowLayout renderedBinding="showNone@searchCriteria@defaultBean@servletRequest">
                       <uix:radioButton name="criteriaSel" 
                                        textBinding="NONE@sdkUIMsg"
                                        selectedValueBinding="criteriaSel@defaultBean@servletRequest"
                                        value="NONE"/>
                     </uix:rowLayout>
--%>
                     <%-- BY MEMBERSHIP --%>
<%--
                     <uix:rowLayout renderedBinding="showMembership@searchCriteria@defaultBean@servletRequest">
                       <uix:radioButton name="criteriaSel"
                                        textBinding="BY_MEMBERSHIP@sdkUIMsg"
                                        selectedValueBinding="criteriaSel@defaultBean@servletRequest"
                                        value="BY_MEMBERSHIP"/>
                     </uix:rowLayout>
                     <uix:rowLayout vAlign="top"
                                    renderedBinding="showMembership@searchCriteria@defaultBean@servletRequest">
                       <uix:cellFormat hAlign="right">
                         <uix:styledText styleClass="OraPromptText"
                                         textBinding="PARENT_TYPE@sdkUIMsg"/>
                       </uix:cellFormat>
                       <uix:spacer width="8"/>
                       <uix:cellFormat hAlign="left">
                       <%
                        if (defaultBean.getParentTypes().size() > 1)
                        {
                       %>
                         <uix:choice name="parentType">
                           <uix:contents childDataBinding="parentTypes@defaultBean@servletRequest">
                             <uix:option textBinding="text"
                                         valueBinding="value"
                                         selectedBinding="selected"
                                         renderedBinding="rendered"/>
                           </uix:contents>
                         </uix:choice>
                       <%
                        } else if (defaultBean.getParentTypes().size() == 1)
                        {
                          ArrayList list = defaultBean.getParentTypes();
                          HashMap map = (HashMap)list.get(0);
                          String text = (String)map.get("text");
                          String val = (String)map.get("value");
                       %>
                         <uix:styledText styleClass="OraDataText">
                             <uix:option text="<%=text%>"
                                         value="<%=val%>"
                                         selected="false"/>
                           </uix:contents>
                         </uix:styledText> 
                         <uix:formValue name="parentType" value="<%=val%>"/>
                       <%
                        }
                       %>
                       </uix:cellFormat>
                     </uix:rowLayout>
                     <uix:rowLayout vAlign="top"
                                    renderedBinding="showMembership@searchCriteria@defaultBean@servletRequest">
                       <uix:cellFormat hAlign="right">
                       </uix:cellFormat>
                       <uix:spacer width="8"/>
                       <uix:cellFormat hAlign="left">
                         <uix:styledText text="Shows all possible parent types you have access to"
                                     styleClass="OraInlineInfoText"/> 
                       </uix:cellFormat>
                     </uix:rowLayout>

                     <uix:rowLayout vAlign="top"
                                    renderedBinding="showMembership@searchCriteria@defaultBean@servletRequest">
                       <uix:cellFormat hAlign="right">
                         <uix:styledText styleClass="OraPromptText"
                                         textBinding="PARENT_NAME@sdkUIMsg"/>
                       </uix:cellFormat>
                       <uix:spacer width="8"/>
                       <uix:cellFormat vAlign="left">
                         <uix:textInput columns="30" name="parentName"
                                        textBinding="parentName@defaultBean@servletRequest"/>

                       </uix:cellFormat>
                     </uix:rowLayout>
--%>

                     <%-- BY MEMBERS --%>
<%--
                     <uix:rowLayout renderedBinding="showMembers@searchCriteria@defaultBean@servletRequest">
                       <uix:radioButton name="criteriaSel"
                                        textBinding="BY_MEMBERS@sdkUIMsg"
                                        selectedValueBinding="criteriaSel@defaultBean@servletRequest"
                                        value="BY_MEMBERS"/>
                     </uix:rowLayout>
--%>
                   <uix:labeledFieldLayout labelWidth="20%" fieldWidth="80%" 
                        renderedBinding="showMembers@searchCriteria@defaultBean@servletRequest"> 
                         <uix:messageChoice name="childType" 
                                            promptBinding="MEMBER_TYPE@jobsResource"
                                            tipBinding="MEMBER_TYPE_TIP@jobsResource">
                           <uix:contents childDataBinding="childTypes@defaultBean@servletRequest">
                             <uix:option textBinding="text"
                                         valueBinding="value"
                                         selectedBinding="selected"
                                         renderedBinding="rendered"/>
                           </uix:contents>
                         </uix:messageChoice>
                         <uix:messageTextInput name="childName"
                                           promptBinding="MEMBER_NAME@jobsResource"
                                           columns="30"
                                           textBinding="childName@defaultBean@servletRequest"
                                           tipBinding="MEMBER_NAME_TIP@jobsResource"/>
                     </uix:labeledFieldLayout>

                     <uix:labeledFieldLayout labelWidth="20%" fieldWidth="80%"> 
                         <uix:spacer width="1"/>
                         <uix:submitButton textBinding="SEARCH@sdkUIMsg"
                                     name="event"
                                     value="<%=Constants.SEARCH_EVENT%>"/>
                     </uix:labeledFieldLayout>

<%--
                     <uix:rowLayout vAlign="top"
                                    renderedBinding="showMember@searchCriteria@defaultBean@servletRequest">
                       <uix:cellFormat hAlign="right">
                       </uix:cellFormat>
                       <uix:spacer width="8"/>
                       <uix:cellFormat hAlign="left">
                         <uix:styledText text="Shows all possible child types you have access to"
                                     styleClass="OraInlineInfoText"/>
                       </uix:cellFormat>
                     </uix:rowLayout>
--%>

                     <%-- BY HOST --%>
<%--
                     <uix:rowLayout renderedBinding="showHosts@searchCriteria@defaultBean@servletRequest">
                       <uix:radioButton name="criteriaSel"
                                        textBinding="BY_HOSTS@sdkUIMsg"
                                        selectedValueBinding="criteriaSel@defaultBean@servletRequest"
                                        value="BY_HOSTS"/>
                     </uix:rowLayout>
                     <uix:rowLayout vAlign="top"
                                    renderedBinding="showHosts@searchCriteria@defaultBean@servletRequest">
                       <uix:cellFormat hAlign="right">
                         <uix:styledText styleClass="OraPromptText"
                                         textBinding="HOST_NAME@sdkUIMsg"/>
                       </uix:cellFormat>
                       <uix:spacer width="8"/>
                       <uix:cellFormat vAlign="left">
                         <uix:textInput columns="30" name="hostName"
                                        textBinding="hostName@defaultBean@servletRequest"/>
                       </uix:cellFormat>
                     </uix:rowLayout>
                   </uix:tableLayout>
                 </uix:stackLayout>
               </uix:header>
--%>
             </uix:contents>
            </uix:header>

            <%-- uix:spacer height="5"/ --%>

            <uix:header textBinding="RESULTS@sdkUIMsg" >
             <uix:contents>

               <uix:rowLayout>
                 <uix:styledText styleClass="OraInstructionText"
                                 textBinding="searchTipText@defaultBean@servletRequest"/>
               </uix:rowLayout>  

               <uix:rowLayout renderedBinding="showMessage@messageBox@defaultBean@servletRequest">
                 <uix:messageBox messageBinding="message@messageBox@defaultBean@servletRequest"
                                 messageTypeBinding="messageType@messageBox@defaultBean@servletRequest">
                 </uix:messageBox>
               </uix:rowLayout>

               <uix:table name="availableTargetsTable" 
                          id="availableTargetsTable"
                          partialRenderMode="self"
                          alternateTextBinding="SEARCH_NAME_NOT_FOUND@mntrResourceBundle"
                          width="90%"
                          blockSize="25"
                          valueBinding="value@defaultBean@servletRequest"
                          minValueBinding="minValue@defaultBean@servletRequest"
                          maxValueBinding="maxValue@defaultBean@servletRequest"
                          formSubmitted="true"
                          tableDataBinding="tableDataKey@tableData@defaultBean@servletRequest"
                          columnFormatsBinding="columnFormats@defaultBean@servletRequest"
                          columnHeaderDataBinding="columnHeaderData@defaultBean@servletRequest">

                  <uix:tableFormat tableBanding="rowBanding"/>

                  <uix:columnHeaderStamp>
                    <uix:sortableHeader textBinding="text"
                                        sortableBinding="sortable"/>
                  </uix:columnHeaderStamp>

                  <uix:tableSelection>

                    <uix:switcher childNameBinding="tableSelection@defaultBean@servletRequest">
                      <uix:case name="multSel">
                          <uix:multipleSelection selectionBinding="selection@defaultBean@servletRequest"
                                                 shortDescBinding="<%=Constants.TARGET_NAME_KEY%>"
                                                 selectedBinding="<%=Constants.SELECTED_KEY%>"/>
                      </uix:case>
                      <uix:case name="singSel">
                          <uix:singleSelection selectedIndexBinding="singSelection@defaultBean@servletRequest"
                                               shortDescBinding="<%=Constants.TARGET_NAME_KEY%>" />
                      </uix:case>
                    </uix:switcher>
                  </uix:tableSelection>


                <uix:contents>
                  <uix:styledText textBinding="<%=Constants.TARGET_NAME_KEY%>"/> 
                  <uix:styledText textBinding="<%=Constants.T_TARGET_TYPE_KEY%>"/>
                  <uix:styledText textBinding="<%=Constants.HOST_NAME_KEY%>" 
                                  renderedBinding="showHost@columnHeaderByCriteria@defaultBean@servletRequest"/>
                  <uix:styledText textBinding="<%=Constants.PARENT_TYPE%>"
                                  renderedBinding="showParentType@columnHeaderByCriteria@defaultBean@servletRequest"/>
                  <uix:image sourceBinding="<%=Constants.CURRENT_STATUS_SRC_KEY%>"/>
                </uix:contents> 
              </uix:table>

             </uix:contents>
            </uix:header>
          <%
           }
          %>
        </uix:contents>

       </uix:pageLayout>
      </uix:form>
    </uix:body>

   </uix:document>
</uix:renderingContext>
