<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oemjsp" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>

<uix:renderingContext id="renderingContext">
<oemjsp:setURLEncoder id="renderingContext"/>
<uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg" />
<uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
	<uix:document>
  	<%@ include file="/oemTitle.jspf"%>
  	<uix:body>
  		<uix:styleSheet/>
			<uix:form name="confirmRemoveTarget" method="POST">
				<uix:dataScope currentDataBinding="webappRemoveData@servletRequest" >
   				<uix:pageLayout>
     				<%@ include file="/oemGlobal.jspf"%>
							<uix:contentFooter>
								<uix:switcher childNameBinding="errorType">
									<uix:case name="nonCollectionError">
										<uix:submitButton name="event" value="OK" textBinding="OK@commonResourceBundle" />
									</uix:case>
									<uix:default>
										<uix:pageButtonBar>
											<uix:submitButton name="event" value="cancelRemove" textBinding="CANCEL@commonResourceBundle" />
											<uix:submitButton name="event" value="doRemove" textBinding="CONTINUE@commonResourceBundle" />
										</uix:pageButtonBar>
									</uix:default>
								</uix:switcher>
							</uix:contentFooter>

								  <uix:switcher childNameBinding="hasError">
						  			<uix:case name="<%=Boolean.TRUE%>">
				  						<uix:switcher childNameBinding="errorType">
												<uix:case name="collectionError">
											 		<uix:messageBox messageBinding="errorMsg" messageType="error"/>
												</uix:case>											
											</uix:switcher>
										</uix:case>
					  			</uix:switcher>

							<uix:switcher childNameBinding="errorType">
								<uix:case name="nonCollectionError">
									<uix:header messageType="error">
										<uix:stackLayout>
										<uix:styledText textBinding="errorMsg" styleClass="OraInstructionTextStrong" />
										<uix:spacer height="8"/>
										<uix:switcher childNameBinding="collectionDisabled">
											<uix:case name="<%=Boolean.TRUE%>">
												<uix:styledText textBinding="COLLECTIONS_DISABLED_CONFIRM_MSG@webappMsg" styleClass="OraInstructionTextStrong"/>
											</uix:case>
										</uix:switcher>
										</uix:stackLayout>
									</uix:header>
								</uix:case>		
								<uix:default>

							<uix:header  textBinding="DISABLE_COLLECTIONS_HDR@webappMsg">
								<uix:stackLayout>
									<uix:styledText textBinding="confirmationMsg" styleClass="OraDataText" />
										<uix:spacer height="8"/>

											<uix:spacer height="5"/>
											<uix:switcher childNameBinding="collectionEnabled" >
												<uix:case name="<%=Boolean.TRUE%>">
													<uix:stackLayout>
													<uix:messageStyledText textBinding="COLLECTION_ON_WARNING@webappMsg" styleClass="OraInstructionText"/>
													<uix:spacer height="5"/>
													<uix:table name="collectionTable" 
										  							 width="70%"
																		 tableDataBinding="collectionTableData"
                                     blockSizeBinding="tableDataBlockSize"
                                     maxValueBinding="tableDataSize"
                                     valueBinding="tableDataCurPos"
																		 columnHeaderDataBinding="collectionTableHeader"
																		 columnFormatsBinding="collectionTableFormats"
																		 formSubmitted="true"
                                     summaryBinding="DISABLE_COLLECTIONS_HDR@webappMsg">
														<uix:tableFormat tableBanding="rowBanding"/>
									          <uix:columnHeaderStamp>
                              <uix:sortableHeader textBinding="text"
                                                  sortableBinding="sortable"/>
               							</uix:columnHeaderStamp>
    	                  		<uix:contents>
															<uix:switcher childNameBinding="compConfigurable">
																<uix:case name="<%=Boolean.TRUE%>">						
		                          		<uix:checkBox name="disableCollection"
																								value="1"
        		                        	      		checkedBinding="disabledCollection"
                                                shortDescBinding="compTargetName"/>
																</uix:case>
																<uix:default>
																	<uix:image sourceBinding="nonconfigurableImage@webappRemoveData@servletRequest"
                                             shortDescBinding="CANNOT_DISABLE@webappMsg"/>
																</uix:default>
															</uix:switcher>
															<uix:styledText textBinding="compTargetName" /> 
															<uix:styledText textBinding="compTargetTypeDisplay"/> 
														</uix:contents>
													</uix:table>
													<uix:spacer height="5" />
													</uix:stackLayout>
												</uix:case>
											</uix:switcher>
										</uix:stackLayout>
									</uix:header>
								</uix:default>
							</uix:switcher>
						</uix:pageLayout>
						<uix:formValue name="returnUrl" valueBinding="returnUrl"/>
						<uix:formValue name="collectionError" valueBinding="collectionError"/>
					</uix:dataScope>
				</uix:form>
			</uix:body>
		</uix:document>
</uix:renderingContext>
