<%--

/* $Header: analyzeReports.jsp 07-jun-2005.14:42:48 eporter Exp $ */
/* Copyright (c) 2001, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      eporter   06/07/05 - Bug 4415243: ADA compliance 
      eporter   03/03/05 - Bug 4079930 - Add double header 
      eporter   02/16/05 - Change Available Data message 
      eporter   02/02/05 - Fix sample column formats 
      eporter   12/22/04 - Fix UI bugs 
      adosani   10/13/04 - Additions for Oracle Forms Webapp Target Type 
      eporter   10/12/04 - Complete new UI for advanced analysis 
      jsamal    07/27/04 - 
      snakhoda  10/17/03 - bug 3167273 - bring back commented out messages 
      rmarripa  09/18/03 - add tip text 
      rmarripa  09/17/03 - add search 
      rmarripa  09/12/03 - change previous selections 
      rmarripa  09/08/03 - add UI review feedback 
      rmarripa  08/27/03 - add default selection to the single select table 
      snakhoda  08/20/03 - snakhoda_bug-3081195_main 
 */

/**
 *  @version $Header: analyzeReports.jsp 07-jun-2005.14:42:48 eporter Exp $
 *  @author  rmarripa
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oemjsp"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ page import='oracle.sysman.eml.webapp.e2e.data.TraceConstants'%>
<%@ page import="oracle.sysman.eml.mntr.util.GenDataObjectList"%>
<%@ page import="oracle.cabo.ui.data.DictionaryData"%>
<%@ page import="oracle.cabo.ui.UIConstants"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import="java.text.DecimalFormat"%>
<%@ page import="oracle.sysman.eml.webapp.eum.data.EUMAnalyzeReportsUIData"%>
<%@ page import="oracle.sysman.eml.webapp.eum.data.EUMConstants"%>
<%@ page import="oracle.cabo.ui.data.DataObject"%>
<jsp:useBean id="eumAnalyzeUIData" scope="request"
             type="oracle.sysman.eml.webapp.eum.data.EUMAnalyzeReportsUIData"/>
<uix:renderingContext id="renderingContext">
 <oemjsp:setURLEncoder id="renderingContext"/>
 <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
 <uix:bundle name="sdkUIMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
 <uix:bundle name="userMntrMsg"
             class="oracle.sysman.eml.mntr.user.UserMntrMsg"/>
 <uix:document>
  <%@ include file="/oemTitle.jspf"%>
  <%@ include file="/oemNoscript.jspf" %>
  <uix:styleSheet/>
  <uix:body>
   <uix:pageLayout>
    <%@ include file="/oemGlobal.jspf"%>
    <uix:dataScope currentDataBinding="eumAnalyzeUIData@servletRequest">
     <uix:stackLayout>
      <uix:contents>
       <uix:switcher childNameBinding="nodeValue@servletRequest"
                     defaultCase="okNode">
        <uix:case name="errNode">
         <uix:messageBox messageType="error"
                         messageBinding="errorMessage@servletRequest"/>
        </uix:case>
       </uix:switcher>
       <uix:switcher childNameBinding="isLargeResultSet"
                     defaultCase="<%=EUMConstants.NOT_LARGE%>">
        <uix:case name="<%=EUMConstants.LARGE%>">
         <uix:messageBox messageType="info" messageBinding="largeResultSetMsg"/>
        </uix:case>
       </uix:switcher>
       <uix:header textBinding="header@servletRequest">
        <%@ include file="eum/customTimeChoice.jspf"%>
        <uix:form name="analyzeReportsForm" method="post"
                  destinationBinding="formDest@eumAnalyzeUIData@servletRequest">
         <uix:stackLayout>
          <%-- 
           ******Axis 1 section start ******
          --%>
          <uix:formValue name="compAxis1" valueBinding="compAxis1"/>
          <uix:formValue name="comp1" valueBinding="comp1"/>
          <uix:formValue name="reportingLevel" valueBinding="reportingLevel"/>
          <uix:formValue name="returnURL" value="returnURL"/>
          <uix:header textBinding="ANALYSIS_PATH@webappMsg">
           <uix:table id="analyzeReportsTb2"
                      alternateTextBinding="NO_END_USER_DATA@webappMsg"
                      width="100%" formSubmitted="true"
                      tableDataBinding="analysisPathData@"
                      columnHeaderDataBinding="axisPathHeader@"
                      summaryBinding="ANALYSIS_PATH@webappMsg">
            <uix:tableFormat tableBanding="rowBanding"/>
            <uix:columnHeaderStamp>
             <uix:sortableHeader textBinding="text"/>
            </uix:columnHeaderStamp>
            <uix:contents>
             <uix:styledText textBinding="order@"/>
             <uix:styledText textBinding="axisName@"/>
             <uix:styledText textBinding="axisValue@"/>
            </uix:contents>
           </uix:table>
          </uix:header>
          <uix:header textBinding="ANALYSIS_RESULTS@webappMsg">
           <uix:stackLayout>
            <uix:styledText textBinding="ANALYSIS_RESULTS_DESC@webappMsg"
                            styleClass="OraPromptText"/>
            <uix:header textBinding="TRACE_SUMMARY_HEADER@webappMsg">
             <uix:stackLayout>
              <uix:rowLayout width="100%">
               <uix:table id="analyzeReportsTblAnalysisResult"
                          alternateTextBinding="NO_END_USER_DATA@webappMsg"
                          width="100%" formSubmitted="true"
                          tableDataBinding="summaryTableData@"
                          summaryBinding="TRACE_SUMMARY_HEADER@webappMsg">
                <uix:contents>
                 <uix:column>
                  <uix:columnFormat columnDataFormat="numberFormat"/>
                  <uix:columnHeader>
                   <uix:sortableHeader textBinding="OVERALL_HITS_COL@userMntrMsg"
                                       sortable="no"/>
                  </uix:columnHeader>
                  <uix:contents>
                   <uix:styledText textBinding="samples@"/>
                  </uix:contents>
                 </uix:column>
                 <uix:columnGroup>
                  <uix:columnHeader>
                   <uix:text textBinding="RESPONSE_TIME@userMntrMsg"/>
                  </uix:columnHeader>
                  <uix:column>
                   <uix:columnFormat columnDataFormat="numberFormat"/>
                   <uix:columnHeader>
                    <uix:sortableHeader textBinding="AVG@userMntrMsg"
                                        sortable="no"/>
                   </uix:columnHeader>
                   <uix:contents>
                    <uix:styledText textBinding="avgRespTime@"/>
                   </uix:contents>
                  </uix:column>
                  <uix:column>
                   <uix:columnFormat columnDataFormat="numberFormat"/>
                   <uix:columnHeader>
                    <uix:sortableHeader textBinding="MAX@userMntrMsg"
                                        sortable="no"/>
                   </uix:columnHeader>
                   <uix:contents>
                    <uix:styledText textBinding="maxRespTime@"/>
                   </uix:contents>
                  </uix:column>
                  <uix:column>
                   <uix:columnFormat columnDataFormat="numberFormat"/>
                   <uix:columnHeader>
                    <uix:sortableHeader textBinding="STDDEV_SEC_COL@userMntrMsg"
                                        sortable="no"/>
                   </uix:columnHeader>
                   <uix:contents>
                    <uix:styledText textBinding="stdDev@"/>
                   </uix:contents>
                  </uix:column>
                 </uix:columnGroup>
                 <uix:columnGroup>
                  <uix:columnHeader>
                   <uix:text textBinding="SERVER_TIME_HDR@userMntrMsg"/>
                  </uix:columnHeader>
                  <uix:column>
                   <uix:columnFormat columnDataFormat="numberFormat"/>
                   <uix:columnHeader>
                    <uix:sortableHeader textBinding="AVG@userMntrMsg"
                                        sortable="no"/>
                   </uix:columnHeader>
                   <uix:contents>
                    <uix:styledText textBinding="avgSrvRespTime@"/>
                   </uix:contents>
                  </uix:column>
                  <uix:column>
                   <uix:columnFormat columnDataFormat="numberFormat"/>
                   <uix:columnHeader>
                    <uix:sortableHeader textBinding="MAX@userMntrMsg"
                                        sortable="no"/>
                   </uix:columnHeader>
                   <uix:contents>
                    <uix:styledText textBinding="maxSrvRespTime@"/>
                   </uix:contents>
                  </uix:column>
                  <uix:column>
                   <uix:columnFormat columnDataFormat="numberFormat"/>
                   <uix:columnHeader>
                    <uix:sortableHeader textBinding="STDDEV_SEC_COL@userMntrMsg"
                                        sortable="no"/>
                   </uix:columnHeader>
                   <uix:contents>
                    <uix:styledText textBinding="stdDevSrvTime@"/>
                   </uix:contents>
                  </uix:column>
                 </uix:columnGroup>
                 <% if ( eumAnalyzeUIData.getIsFormType() ) { %>
                 <uix:columnGroup>
                  <uix:columnHeader>
                   <uix:text textBinding="DATABASE_TIME@userMntrMsg"/>
                  </uix:columnHeader>
                  <uix:column>
                   <uix:columnFormat columnDataFormat="numberFormat"/>
                   <uix:columnHeader>
                    <uix:sortableHeader textBinding="AVG@userMntrMsg"
                                        sortable="no"/>
                   </uix:columnHeader>
                   <uix:contents>
                    <uix:styledText textBinding="avgDBRespTime@"/>
                   </uix:contents>
                  </uix:column>
                  <uix:column>
                   <uix:columnFormat columnDataFormat="numberFormat"/>
                   <uix:columnHeader>
                    <uix:sortableHeader textBinding="MAX@userMntrMsg"
                                        sortable="no"/>
                   </uix:columnHeader>
                   <uix:contents>
                    <uix:styledText textBinding="maxDBRespTime@"/>
                   </uix:contents>
                  </uix:column>
                  <uix:column>
                   <uix:columnFormat columnDataFormat="numberFormat"/>
                   <uix:columnHeader>
                    <uix:sortableHeader textBinding="STDDEV_SEC_COL@userMntrMsg"
                                        sortable="no"/>
                   </uix:columnHeader>
                   <uix:contents>
                    <uix:styledText textBinding="stdDevDBTime@"/>
                   </uix:contents>
                  </uix:column>
                 </uix:columnGroup>
                 <% } %>
                </uix:contents>
               </uix:table>
              </uix:rowLayout>
             </uix:stackLayout>
            </uix:header>
            <uix:switcher childNameBinding="isSample">
             <uix:case name="false">
              <uix:header textBinding="DETAILS_HDR@webappMsg">
               <uix:stackLayout>
                <uix:contents>
                 <uix:formValue name="reportsBy" valueBinding="reportAxis"/>
                 <uix:formValue name="perfDetailReportType"
                                valueBinding="perfDetailReportType"/>
                </uix:contents>
               </uix:stackLayout>
               <uix:stackLayout>
                <uix:contents>
                 <uix:tableLayout>
                  <uix:messageChoice promptBinding="VIEW_BY@webappMsg"
                                     selectedValueBinding="analyzeMore@eumAnalyzeUIData@servletRequest"
                                     name="newAxis">
                    <uix:contents childDataBinding="newReportsChoiceList@eumAnalyzeUIData@servletRequest">
                     <uix:option textBinding="text" valueBinding="value"
                                 renderedBinding="rendered"/>
                    </uix:contents>
                  </uix:messageChoice>
                  <uix:rowLayout>
                   <uix:spacer height="5"/>
                  </uix:rowLayout>
                  
                  <uix:messageTextInput promptBinding="SEARCH@webappMsg"
                                        name="searchString" 
                                        textBinding="searchString">
                    <uix:end>
                      <uix:submitButton textBinding="GO@webappMsg" name="event"
                                        value="<%=EUMConstants.SEARCH%>"/>
                    </uix:end>
                  </uix:messageTextInput>
                  
                  <uix:rowLayout>
                   <uix:spacer height="5"/>
                  </uix:rowLayout>
                 </uix:tableLayout>
                 <uix:rowLayout width="100%">
                  <uix:formValue name="selTableType"
                                 value="tableMultiSelTypeReport"/>
                  <uix:table id="analyzeReportsTblDetails"
                             alternateTextBinding="noDataMsg" width="100%"
                             formSubmitted="true"
                             blockSizeBinding="tableDataBlockSize"
                             tableDataBinding="tableData@"
                             maxValueBinding="tableDataSize"
                             valueBinding="tableDataCurPos"
                             summaryBinding="DETAILS_HDR@webappMsg">
                   <uix:tableFormat tableBanding="rowBanding"/>
                   <%
                EUMAnalyzeReportsUIData uiData = (EUMAnalyzeReportsUIData)request.getAttribute("eumAnalyzeUIData");
               String level = (uiData == null) ? null :  uiData.getReportLevel();
               if ( ( level != null ) && (! level.equals("5" ) ) )
               {
               %>
                   <uix:tableSelection>
                    <uix:multipleSelection selectedBinding="selected@"
                                           shortDescBinding="itemName@">
                     <uix:spacer width="10"/>
                     <uix:submitButton textBinding="ANALYZE_HDR@webappMsg"
                                       name="event" value="analyzeAgain"/>
                    </uix:multipleSelection>
                   </uix:tableSelection>
                   <%
               }
               %>
                   <uix:contents>
                    <uix:formValue name="id" valueBinding="itemName@"/>
                    <uix:column>
                     <uix:columnFormat columnDataFormat="textFormat"/>
                     <uix:columnHeader>
                      <uix:sortableHeader textBinding="detailsAxisDisplay"
                                          sortableBinding="itemName@detailSortStates@" 
                                          value="0"/>
                     </uix:columnHeader>
                     <uix:contents>
                      <uix:styledText textBinding="shortDesc@" shortDescBinding="itemName@"/>
                     </uix:contents>
                    </uix:column>
                    <uix:column>
                     <uix:columnFormat columnDataFormat="numberFormat"/>
                     <uix:columnHeader>
                      <uix:sortableHeader textBinding="OVERALL_HITS_COL@userMntrMsg"
                                          sortableBinding="samples@detailSortStates@" 
                                          value="1"/>
                     </uix:columnHeader>
                     <uix:contents>
                      <uix:styledText textBinding="samples@"
                                      destinationBinding="urldestination@"/>
                     </uix:contents>
                    </uix:column>
                    <uix:columnGroup>
                     <uix:columnHeader>
                      <uix:text textBinding="RESPONSE_TIME@userMntrMsg"/>
                     </uix:columnHeader>
                     <uix:column>
                      <uix:columnFormat columnDataFormat="numberFormat"/>
                      <uix:columnHeader>
                       <uix:sortableHeader textBinding="AVG@userMntrMsg"
                                           sortableBinding="avgRespTime@detailSortStates@" 
                                           value="2"/>
                      </uix:columnHeader>
                      <uix:contents>
                       <uix:styledText textBinding="avgRespTime@"/>
                      </uix:contents>
                     </uix:column>
                     <uix:column>
                      <uix:columnFormat columnDataFormat="numberFormat"/>
                      <uix:columnHeader>
                       <uix:sortableHeader textBinding="MAX@userMntrMsg"
                                           sortableBinding="maxRespTime@detailSortStates@" 
                                           value="3"/>
                      </uix:columnHeader>
                      <uix:contents>
                       <uix:styledText textBinding="maxRespTime@"/>
                      </uix:contents>
                     </uix:column>
                     <uix:column>
                      <uix:columnFormat columnDataFormat="numberFormat"/>
                      <uix:columnHeader>
                       <uix:sortableHeader textBinding="STDDEV_SEC_COL@userMntrMsg"
                                           sortableBinding="stdDev@detailSortStates@" 
                                           value="4"/>
                      </uix:columnHeader>
                      <uix:contents>
                       <uix:styledText textBinding="stdDev@"/>
                      </uix:contents>
                     </uix:column>
                    </uix:columnGroup>
                    <uix:columnGroup>
                     <uix:columnHeader>
                      <uix:text textBinding="SERVER_TIME_HDR@userMntrMsg"/>
                     </uix:columnHeader>
                     <uix:column>
                      <uix:columnFormat columnDataFormat="numberFormat"/>
                      <uix:columnHeader>
                       <uix:sortableHeader textBinding="AVG@userMntrMsg"
                                           sortableBinding="avgSrvRespTime@detailSortStates@" 
                                           value="5"/>
                      </uix:columnHeader>
                      <uix:contents>
                       <uix:styledText textBinding="avgSrvRespTime@"/>
                      </uix:contents>
                     </uix:column>
                     <uix:column>
                      <uix:columnFormat columnDataFormat="numberFormat"/>
                      <uix:columnHeader>
                       <uix:sortableHeader textBinding="MAX@userMntrMsg"
                                           sortableBinding="maxSrvRespTime@detailSortStates@" 
                                           value="6"/>
                      </uix:columnHeader>
                      <uix:contents>
                       <uix:styledText textBinding="maxSrvRespTime@"/>
                      </uix:contents>
                     </uix:column>
                     <uix:column>
                      <uix:columnFormat columnDataFormat="numberFormat"/>
                      <uix:columnHeader>
                       <uix:sortableHeader textBinding="STDDEV_SEC_COL@userMntrMsg"
                                           sortableBinding="stdDevSrvTime@detailSortStates@" 
                                           value="7"/>
                      </uix:columnHeader>
                      <uix:contents>
                       <uix:styledText textBinding="stdDevSrvTime@"/>
                      </uix:contents>
                     </uix:column>
                    </uix:columnGroup>
                    <% if ( eumAnalyzeUIData.getIsFormType() ) { %>
                    <uix:columnGroup>
                     <uix:columnHeader>
                      <uix:text textBinding="DATABASE_TIME@userMntrMsg"/>
                     </uix:columnHeader>
                     <uix:column>
                      <uix:columnFormat columnDataFormat="numberFormat"/>
                      <uix:columnHeader>
                       <uix:sortableHeader textBinding="AVG@userMntrMsg"
                                           sortableBinding="avgDBRespTime@detailSortStates@" value="8"/>
                      </uix:columnHeader>
                      <uix:contents>
                       <uix:styledText textBinding="avgDBRespTime@"/>
                      </uix:contents>
                     </uix:column>
                     <uix:column>
                      <uix:columnFormat columnDataFormat="numberFormat"/>
                      <uix:columnHeader>
                       <uix:sortableHeader textBinding="MAX@userMntrMsg"
                                           sortableBinding="maxDBRespTime@detailSortStates@" value="9"/>
                      </uix:columnHeader>
                      <uix:contents>
                       <uix:styledText textBinding="maxDBRespTime@"/>
                      </uix:contents>
                     </uix:column>
                     <uix:column>
                      <uix:columnFormat columnDataFormat="numberFormat"/>
                      <uix:columnHeader>
                       <uix:sortableHeader textBinding="STDDEV_SEC_COL@userMntrMsg"
                                           sortableBinding="stdDevDBTime@detailSortStates@" value="10"/>
                      </uix:columnHeader>
                      <uix:contents>
                       <uix:styledText textBinding="stdDevDBTime@"/>
                      </uix:contents>
                     </uix:column>
                    </uix:columnGroup>
                    <% } %>
                   </uix:contents>
                  </uix:table>
                  <uix:formValue name="newAxis1" valueBinding="analyzeMore@"/>
                 </uix:rowLayout>
                </uix:contents>
               </uix:stackLayout>
              </uix:header>
             </uix:case>
             <uix:case name="true">
              <uix:header textBinding="SAMPLES@webappMsg">
               <uix:stackLayout>
                <uix:contents>
                 <uix:formValue name="reportsBy" valueBinding="reportAxis"/>
                 <uix:formValue name="perfDetailReportType"
                                valueBinding="perfDetailReportType"/>
                 <uix:formValue name="axis" valueBinding="sampleAxis"/>
                 <uix:formValue name="axisValue"
                                valueBinding="sampleAxisValue"/>
                </uix:contents>
               </uix:stackLayout>
               <uix:stackLayout>
                <uix:contents>
                 <uix:tableLayout>
                  <uix:messageTextInput promptBinding="SEARCH@webappMsg"
                                        name="searchString"
                                        textBinding="searchString">
                    <uix:end>
                    <uix:flowLayout>
                    <uix:choice selectedValueBinding="analyzeMore@eumAnalyzeUIData@servletRequest"
                               name="newAxis"
                               shortDescBinding="SEARCH_AXIS@webappMsg">
                    <uix:contents childDataBinding="sampleChoiceList@eumAnalyzeUIData@servletRequest">
                     <uix:option textBinding="text" valueBinding="value"
                                 renderedBinding="rendered"/>
                    </uix:contents>
                   </uix:choice>
                   <uix:spacer width="5"/>
                   <uix:submitButton textBinding="GO@webappMsg" name="event"
                                     value="<%=EUMConstants.SEARCH%>"/>
                    </uix:flowLayout>
                    </uix:end>
                  </uix:messageTextInput>
                  <uix:rowLayout>
                   <uix:spacer height="5"/>
                  </uix:rowLayout>
                 </uix:tableLayout>
                 <uix:table id="analyzeReportsTbl"
                            alternateTextBinding="NO_END_USER_DATA@webappMsg"
                            width="100%" formSubmitted="true"
                            blockSizeBinding="tableDataBlockSize"
                            tableDataBinding="tableData@"
                            maxValueBinding="tableDataSize"
                            valueBinding="tableDataCurPos"
                            columnFormatsBinding="sampleColFormats@"
                            columnHeaderDataBinding="reportTableColHeaders@"
                            summaryBinding="SAMPLES@webappMsg">
                  <uix:tableFormat tableBanding="rowBanding"/>
                  <uix:columnHeaderStamp>
                   <uix:sortableHeader textBinding="text"
                                       sortableBinding="sortable"/>
                  </uix:columnHeaderStamp>
                  <uix:contents>
                   <uix:styledText textBinding="url@" shortDescBinding="shortDesc@"/>
                   <uix:styledText textBinding="visitor@"/>
                   <uix:styledText textBinding="analyze_collection_timestamp@"/>
                   <uix:styledText textBinding="avgRespTime@"/>
                   <uix:styledText textBinding="avgSrvRespTime@"/>
                   <uix:styledText textBinding="avgDBRespTime@"
                                   renderedBinding="isFormType@eumAnalyzeUIData@servletRequest"/>
                   <uix:styledText textBinding="browserOS@"/>
                   <uix:styledText textBinding="browser@"/>
                  </uix:contents>
                 </uix:table>
                </uix:contents>
               </uix:stackLayout>
              </uix:header>
             </uix:case>
            </uix:switcher>
           </uix:stackLayout>
          </uix:header>
          <uix:switcher childNameBinding="isDataAvailable" defaultCase="false">
           <uix:case name="true">
            <uix:header textBinding="AVAILABLE_DATA@webappMsg">
             <uix:stackLayout>
              <uix:contents>
               <uix:styledText textBinding="EUM_ACTIVITY_TXT@webappMsg"
                               styleClass="OraPromptText"/>
               <uix:tableLayout>
                <uix:messageLayout promptBinding="START_TIME@sdkUIMsg">
                 <uix:styledText textBinding="dataStartTimeMsg"
                                 styleClass="OraPromptText"/>
                </uix:messageLayout>
                <uix:messageLayout promptBinding="END_TIME@sdkUIMsg">
                 <uix:styledText textBinding="dataEndTimeMsg"
                                 styleClass="OraPromptText"/>
                </uix:messageLayout>
               </uix:tableLayout>
              </uix:contents>
             </uix:stackLayout>
            </uix:header>
           </uix:case>
          </uix:switcher>
         </uix:stackLayout>
        </uix:form>
       </uix:header>
      </uix:contents>
     </uix:stackLayout>
     <uix:spacer height="10"/>
     <uix:tip textBinding="ANALYZE_DATA_PERF_TIP_TEXT@webappMsg"/>
    </uix:dataScope>
   </uix:pageLayout>
  </uix:body>
 </uix:document>
</uix:renderingContext>