<%--

/* $Header: analyzeReportsAdvanced.jsp 06-sep-2006.14:54:55 yxie Exp $ */
/* Copyright (c) 2004, 2006, Oracle. All rights reserved.  */

/*
   DESCRIPTION

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      yxie      09/06/06 - XbranchMerge yxie_tnslatefix from main
      yxie      09/06/06 - Use Forms specific UI labels
      eporter   06/07/05 - Bug 4415243: ADA compliance 
      eporter   03/03/05 - Bug 4079930 - Add double header 
      eporter   02/10/05 - Completely Overhaul UI
      eporter   02/02/05 - Rework UI 
      eporter   01/12/05 - Change custom time implementation 
      adosani   10/13/04 - Additions for Oracle Forms Webapp Target Type. 
      eporter   10/08/04 - eporter_adv_analyze
      eporter   10/01/04 - creation
 */

/**
 *  @version analyzeReportsAdvanced.jsp 01-oct-2004.13:08:22 eporter Exp $
 *  @author  eporter
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oemjsp"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ page import="oracle.sysman.eml.webapp.e2e.data.TraceConstants"%>
<%@ page import="oracle.sysman.eml.mntr.util.GenDataObjectList"%>
<%@ page import="oracle.cabo.ui.data.DictionaryData"%>
<%@ page import="oracle.cabo.ui.UIConstants"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import="java.text.DecimalFormat"%>
<%@ page import="oracle.sysman.eml.webapp.eum.data.EUMAnalyzeReportsUIData"%>
<%@ page import="oracle.sysman.eml.webapp.eum.data.EUMConstants"%>
<%@ page import="oracle.cabo.ui.data.DataObject"%>
<jsp:useBean id="eumAnalyzeUIData" scope="request"
             type="oracle.sysman.eml.webapp.eum.data.EUMAdvAnalyzeReportsUIData"/>
<uix:renderingContext id="renderingContext">
  <oemjsp:setURLEncoder id="renderingContext"/>
  <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
  <uix:bundle name="sdkUIMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="userMntrMsg"
              class="oracle.sysman.eml.mntr.user.UserMntrMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <%@ include file="/oemNoscript.jspf" %>
    <uix:styleSheet/>
  </uix:document>
  <uix:body>
    <script language="JavaScript">

 function myCallBack()
 {
   var value = window.mySelectedIndexes;
   if(value != null)
   {
     if (curAxis == 'urls')
     {
       document.searchForm.urls.value = window.mySelectedIndexes;
     }else if(curAxis == 'visitors')
     {
       document.searchForm.visitors.value = window.mySelectedIndexes;
     }else if(curAxis == 'domains')
     {
       document.searchForm.domains.value = window.mySelectedIndexes;
     }else if(curAxis == 'webservers')
     {
       document.searchForm.webservers.value = window.mySelectedIndexes;
     }else if(curAxis == 'regions')
     {
       document.searchForm.regions.value = window.mySelectedIndexes;
     }
   }
 }

 var curAxis;
 
 function launchRfs(axis)
 {
   window.mySelectedIndexes = null;
   curAxis = axis;
   openWindow(window, 'analyzeReportsSelect?target='+document.targetForm.target.value+
     '&type='+document.targetForm.type.value+'&axis='+axis, 
     'lovWindow', {width:550, height:550}, true, 'dialog', null);
 }
 
 function clearForm()
 {
   document.searchForm.urls.value = '';
   document.searchForm.visitors.value = '';
   document.searchForm.domains.value = '';
   document.searchForm.webservers.value = '';
   document.searchForm.regions.value = '';
   for(i=0; i<document.searchForm.browser.length; i++)
     document.searchForm.browser.options[i].selected = null;
   for(i=0; i<document.searchForm.browserOS.length; i++)
     document.searchForm.browserOS.options[i].selected = null;
 }
 </script>
    <uix:pageLayout>
      <%@ include file="/oemGlobal.jspf"%>
      <uix:dataScope currentDataBinding="eumAnalyzeUIData@servletRequest">
        <uix:stackLayout>
          <uix:contents>
            <uix:switcher childNameBinding="nodeValue@servletRequest"
                          defaultCase="okNode">
              <uix:case name="errNode">
                <uix:messageBox messageType="error"
                                messageBinding="errorMessage@servletRequest"/>
              </uix:case>
            </uix:switcher>
            <uix:switcher childNameBinding="isLargeResultSet"
                          defaultCase="<%=EUMConstants.NOT_LARGE%>">
              <uix:case name="<%=EUMConstants.LARGE%>">
                <uix:messageBox messageType="info"
                                messageBinding="largeResultSetMsg"/>
              </uix:case>
            </uix:switcher>
            <uix:header textBinding="header@servletRequest">
              <%@ include file="eum/customTimeChoice.jspf"%>
              <uix:spacer height="5"/>
              <%-- 
                This form helps the javascript build a url with the target name
                and type
              --%>
              <uix:form name="targetForm"/>
              <uix:form name="searchForm" method="post">
                <uix:formValue name="numSearchesRun"
                               valueBinding="<%=EUMConstants.NUM_SEARCHES_RUN%>"/>
                <%-- 
                  Only show search fields if it is not a samples view.
                --%>
                <uix:switcher childNameBinding="showSamples">
                  <uix:case name="<%=EUMConstants.HIDE%>">
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:rowLayout vAlign="top">
                          <uix:tableLayout>
                            <uix:contents>
                              <uix:messageLovField promptBinding="urlHeader"
                                              id="<%=EUMConstants.URLS%>"
                                              name="<%=EUMConstants.URLS%>"
                                              columns="40"
                                              onClick="launchRfs('urls');"
                                              textBinding="<%=EUMConstants.URLS%>"
                                              searchDescBinding="urlTipMsg"/>
                              <uix:messageLovField promptBinding="VISITORS@webappMsg"
                                              id="<%=EUMConstants.VISITORS%>"
                                              name="<%=EUMConstants.VISITORS%>"
                                              columns="40"
                                              onClick="launchRfs('visitors');"
                                              textBinding="<%=EUMConstants.VISITORS%>"
                                              searchDescBinding="visitorTipMsg"/>
                              <uix:messageLovField promptBinding="DOMAINS@webappMsg"
                                              id="<%=EUMConstants.DOMAINS%>"
                                              name="<%=EUMConstants.DOMAINS%>"
                                              columns="40"
                                              onClick="launchRfs('domains');"
                                              textBinding="<%=EUMConstants.DOMAINS%>"
                                              searchDescBinding="domainTipMsg"/>
                              <uix:messageLovField promptBinding="WEBSERVERS@webappMsg"
                                              id="<%=EUMConstants.WEBSERVERS%>"
                                              name="<%=EUMConstants.WEBSERVERS%>"
                                              columns="40"
                                              onClick="launchRfs('webservers');"
                                              textBinding="<%=EUMConstants.WEBSERVERS%>"
                                              searchDescBinding="webServerTipMsg"/>
                              <uix:messageLovField promptBinding="REGIONS@webappMsg"
                                              id="<%=EUMConstants.REGIONS%>"
                                              name="<%=EUMConstants.REGIONS%>"
                                              columns="40"
                                              onClick="launchRfs('regions');"
                                              textBinding="<%=EUMConstants.REGIONS%>"
                                              searchDescBinding="regionTipMsg"/>
                              <uix:messageChoice name="timeByPost"
                                                 promptBinding="VIEW_DATA@webappMsg"
                                                 selectedValueBinding="selectedContext@customTimeContextData@servletRequest"
                                                 onChange="submitForm(searchForm, false, {event:'timeByPost'})">
                                <uix:contents childDataBinding="contextChoices@customTimeContextData@servletRequest">
                                  <uix:option textBinding="textKey"
                                              valueBinding="valueKey"/>
                                </uix:contents>
                              </uix:messageChoice>
                              <uix:rowLayout>
                                <uix:spacer width="1"/>
                                <uix:spacer width="1"/>
                                <uix:cellFormat hAlign="left">
                                  <uix:rowLayout>
                                    <uix:submitButton textBinding="ANALYZE_HDR@webappMsg"
                                                      name="event"
                                                      value="<%=EUMConstants.START_ANALYZE_EVENT%>"/>
                                    <uix:spacer width="5"/>
                                    <uix:button textBinding="SEV_CLEAR@sdkUIMsg"
                                                onClick="clearForm()"/>
                                  </uix:rowLayout>
                                </uix:cellFormat>
                              </uix:rowLayout>
                            </uix:contents>
                          </uix:tableLayout>
                          <uix:spacer width="20"/>
                          <uix:cellFormat hAlign="left" vAlign="top">
                            <uix:tableLayout>
                              <uix:contents>
                                <uix:messageList promptBinding="BROWSER_SOFTWARE@webappMsg"
                                                 name="browser" multiple="true"
                                                 size="3">
                                    <uix:contents childDataBinding="browserChoices">
                                      <uix:option textBinding="text"
                                                  valueBinding="value"
                                                  selectedBinding="selected"/>
                                    </uix:contents>
                                </uix:messageList>
                                <uix:messageList promptBinding="BROWSER_OS@webappMsg"
                                                 name="browserOS" multiple="true"
                                                 size="3">
                                    <uix:contents childDataBinding="browserOSChoices">
                                      <uix:option textBinding="text"
                                                  valueBinding="value"
                                                  selectedBinding="selected"/>
                                    </uix:contents>
                                </uix:messageList>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:separator/>
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:case>
                </uix:switcher>
                <uix:switcher childNameBinding="nodeValue@servletRequest">
                  <uix:case name="okNode">
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:tableLayout width="60%">
                          <uix:rowLayout vAlign="top">
                            <uix:switcher childNameBinding="showSamples">
                              <uix:case name="<%=EUMConstants.SHOW%>">
                                <uix:messageStyledText promptBinding="sampleHeader"
                                                       textBinding="sampleBy"
                                                       styleClass="OraInstructionTextStrong"/>
                              </uix:case>
                            </uix:switcher>
                          </uix:rowLayout>
                        </uix:tableLayout>
                        <uix:switcher childNameBinding="wasSearchRun"
                                      defaultCase="false">
                          <uix:case name="true">
                            <uix:header textBinding="ANALYSIS_RESULTS@webappMsg">
                              <uix:stackLayout>
                                <uix:header textBinding="TRACE_SUMMARY_HEADER@webappMsg">
                                  <uix:stackLayout>
                                    <uix:rowLayout width="100%">
                                      <uix:table id="analyzeReportsTblAnalysisResult"
                                                 alternateTextBinding="NO_END_USER_DATA@webappMsg"
                                                 width="100%"
                                                 formSubmitted="true"
                                                 tableDataBinding="summaryTableData@"
                                                 summaryBinding="TRACE_SUMMARY_HEADER@webappMsg">
                                        <uix:contents>
                                          <uix:column>
                                            <uix:columnFormat columnDataFormat="numberFormat"/>
                                            <uix:columnHeader>
                                              <uix:sortableHeader textBinding="OVERALL_HITS_COL@userMntrMsg"
                                                                  sortable="no"/>
                                            </uix:columnHeader>
                                            <uix:contents>
                                              <uix:styledText textBinding="samples@"/>
                                            </uix:contents>
                                          </uix:column>
                                          <uix:columnGroup>
                                            <uix:columnHeader>
                                              <uix:text textBinding="RESPONSE_TIME@userMntrMsg"/>
                                            </uix:columnHeader>
                                            <uix:column>
                                              <uix:columnFormat columnDataFormat="numberFormat"/>
                                              <uix:columnHeader>
                                                <uix:sortableHeader textBinding="AVG@userMntrMsg"
                                                                    sortable="no"/>
                                              </uix:columnHeader>
                                              <uix:contents>
                                                <uix:styledText textBinding="avgRespTime@"/>
                                              </uix:contents>
                                            </uix:column>
                                            <uix:column>
                                              <uix:columnFormat columnDataFormat="numberFormat"/>
                                              <uix:columnHeader>
                                                <uix:sortableHeader textBinding="MAX@userMntrMsg"
                                                                    sortable="no"/>
                                              </uix:columnHeader>
                                              <uix:contents>
                                                <uix:styledText textBinding="maxRespTime@"/>
                                              </uix:contents>
                                            </uix:column>
                                            <uix:column>
                                              <uix:columnFormat columnDataFormat="numberFormat"/>
                                              <uix:columnHeader>
                                                <uix:sortableHeader textBinding="STDDEV_SEC_COL@userMntrMsg"
                                                                    sortable="no"/>
                                              </uix:columnHeader>
                                              <uix:contents>
                                                <uix:styledText textBinding="stdDev@"/>
                                              </uix:contents>
                                            </uix:column>
                                          </uix:columnGroup>
                                          <uix:columnGroup>
                                            <uix:columnHeader>
                                              <uix:text textBinding="SERVER_TIME_HDR@userMntrMsg"/>
                                            </uix:columnHeader>
                                            <uix:column>
                                              <uix:columnFormat columnDataFormat="numberFormat"/>
                                              <uix:columnHeader>
                                                <uix:sortableHeader textBinding="AVG@userMntrMsg"
                                                                    sortable="no"/>
                                              </uix:columnHeader>
                                              <uix:contents>
                                                <uix:styledText textBinding="avgSrvRespTime@"/>
                                              </uix:contents>
                                            </uix:column>
                                            <uix:column>
                                              <uix:columnFormat columnDataFormat="numberFormat"/>
                                              <uix:columnHeader>
                                                <uix:sortableHeader textBinding="MAX@userMntrMsg"
                                                                    sortable="no"/>
                                              </uix:columnHeader>
                                              <uix:contents>
                                                <uix:styledText textBinding="maxSrvRespTime@"/>
                                              </uix:contents>
                                            </uix:column>
                                            <uix:column>
                                              <uix:columnFormat columnDataFormat="numberFormat"/>
                                              <uix:columnHeader>
                                                <uix:sortableHeader textBinding="STDDEV_SEC_COL@userMntrMsg"
                                                                    sortable="no"/>
                                              </uix:columnHeader>
                                              <uix:contents>
                                                <uix:styledText textBinding="stdDevSrvTime@"/>
                                              </uix:contents>
                                            </uix:column>
                                          </uix:columnGroup>
                                          <% if ( eumAnalyzeUIData.getIsFormType() ) { %>
                                          <uix:columnGroup>
                                            <uix:columnHeader>
                                              <uix:text textBinding="DATABASE_TIME@userMntrMsg"/>
                                            </uix:columnHeader>
                                            <uix:column>
                                              <uix:columnFormat columnDataFormat="numberFormat"/>
                                              <uix:columnHeader>
                                                <uix:sortableHeader textBinding="AVG@userMntrMsg"
                                                                    sortable="no"/>
                                              </uix:columnHeader>
                                              <uix:contents>
                                                <uix:styledText textBinding="avgDBRespTime@"/>
                                              </uix:contents>
                                            </uix:column>
                                            <uix:column>
                                              <uix:columnFormat columnDataFormat="numberFormat"/>
                                              <uix:columnHeader>
                                                <uix:sortableHeader textBinding="MAX@userMntrMsg"
                                                                    sortable="no"/>
                                              </uix:columnHeader>
                                              <uix:contents>
                                                <uix:styledText textBinding="maxDBRespTime@"/>
                                              </uix:contents>
                                            </uix:column>
                                            <uix:column>
                                              <uix:columnFormat columnDataFormat="numberFormat"/>
                                              <uix:columnHeader>
                                                <uix:sortableHeader textBinding="STDDEV_SEC_COL@userMntrMsg"
                                                                    sortable="no"/>
                                              </uix:columnHeader>
                                              <uix:contents>
                                                <uix:styledText textBinding="stdDevDBTime@"/>
                                              </uix:contents>
                                            </uix:column>
                                          </uix:columnGroup>
                                          <% } %>
                                        </uix:contents>
                                      </uix:table>
                                    </uix:rowLayout>
                                  </uix:stackLayout>
                                </uix:header>
                                <uix:switcher childNameBinding="showSamples">
                                  <uix:case name="<%=EUMConstants.HIDE%>">
                                    <uix:header textBinding="DETAILS_HDR@webappMsg">
                                      <uix:tableLayout>
                                        <uix:messageChoice promptBinding="VIEW_BY@webappMsg"
                                                      name="viewBy"
                                                      selectedValueBinding="selectedViewBy"
                                                      required="yes">
                                            <uix:contents childDataBinding="viewByChoices">
                                              <uix:option textBinding="text"
                                                          valueBinding="value"/>
                                            </uix:contents>
                                        </uix:messageChoice>
                                        <uix:messageTextInput promptBinding="SEARCH@webappMsg"
                                                         name="<%=EUMConstants.SEARCH_STRING%>"
                                                         textBinding="<%=EUMConstants.SEARCH_STRING%>">
                                          <uix:end>
                                            <uix:submitButton textBinding="GO@webappMsg"
                                                              name="event"
                                                              value="<%=EUMConstants.SEARCH%>"/>
                                          </uix:end>
                                        </uix:messageTextInput>
                                        <uix:rowLayout>
                                          <uix:spacer height="5"/>
                                        </uix:rowLayout>
                                      </uix:tableLayout>
                                      <uix:rowLayout width="100%">
                                        <uix:table id="analyzeReportsTblDetails"
                                                   alternateTextBinding="noDataMsg"
                                                   width="100%"
                                                   formSubmitted="true"
                                                   blockSizeBinding="tableDataBlockSize"
                                                   tableDataBinding="tableData@"
                                                   maxValueBinding="tableDataSize"
                                                   valueBinding="tableDataCurPos"
                                                   summaryBinding="DETAILS_HDR@webappMsg">
                                          <uix:tableFormat tableBanding="rowBanding"/>
                                          <uix:contents>
                                            <uix:column>
                                              <uix:columnFormat columnDataFormat="textFormat"/>
                                              <uix:columnHeader>
                                                <uix:sortableHeader textBinding="detailsAxisDisplay"
                                                                    sortableBinding="itemName@detailSortStates@"
                                                                    value="0"/>
                                              </uix:columnHeader>
                                              <uix:contents>
                                                <uix:styledText textBinding="shortDesc@"
                                                                shortDescBinding="itemName@"/>
                                              </uix:contents>
                                            </uix:column>
                                            <uix:column>
                                              <uix:columnFormat columnDataFormat="numberFormat"/>
                                              <uix:columnHeader>
                                                <uix:sortableHeader textBinding="OVERALL_HITS_COL@userMntrMsg"
                                                                    sortableBinding="samples@detailSortStates@"
                                                                    value="1"/>
                                              </uix:columnHeader>
                                              <uix:contents>
                                                <uix:styledText textBinding="samples@"
                                                                destinationBinding="urldestination@"/>
                                              </uix:contents>
                                            </uix:column>
                                            <uix:columnGroup>
                                              <uix:columnHeader>
                                                <uix:text textBinding="RESPONSE_TIME@userMntrMsg"/>
                                              </uix:columnHeader>
                                              <uix:column>
                                                <uix:columnFormat columnDataFormat="numberFormat"/>
                                                <uix:columnHeader>
                                                  <uix:sortableHeader textBinding="AVG@userMntrMsg"
                                                                      sortableBinding="avgRespTime@detailSortStates@"
                                                                      value="2"/>
                                                </uix:columnHeader>
                                                <uix:contents>
                                                  <uix:styledText textBinding="avgRespTime@"/>
                                                </uix:contents>
                                              </uix:column>
                                              <uix:column>
                                                <uix:columnFormat columnDataFormat="numberFormat"/>
                                                <uix:columnHeader>
                                                  <uix:sortableHeader textBinding="MAX@userMntrMsg"
                                                                      sortableBinding="maxRespTime@detailSortStates@"
                                                                      value="3"/>
                                                </uix:columnHeader>
                                                <uix:contents>
                                                  <uix:styledText textBinding="maxRespTime@"/>
                                                </uix:contents>
                                              </uix:column>
                                              <uix:column>
                                                <uix:columnFormat columnDataFormat="numberFormat"/>
                                                <uix:columnHeader>
                                                  <uix:sortableHeader textBinding="STDDEV_SEC_COL@userMntrMsg"
                                                                      sortableBinding="stdDev@detailSortStates@"
                                                                      value="4"/>
                                                </uix:columnHeader>
                                                <uix:contents>
                                                  <uix:styledText textBinding="stdDev@"/>
                                                </uix:contents>
                                              </uix:column>
                                            </uix:columnGroup>
                                            <uix:columnGroup>
                                              <uix:columnHeader>
                                                <uix:text textBinding="SERVER_TIME_HDR@userMntrMsg"/>
                                              </uix:columnHeader>
                                              <uix:column>
                                                <uix:columnFormat columnDataFormat="numberFormat"/>
                                                <uix:columnHeader>
                                                  <uix:sortableHeader textBinding="AVG@userMntrMsg"
                                                                      sortableBinding="avgSrvRespTime@detailSortStates@"
                                                                      value="5"/>
                                                </uix:columnHeader>
                                                <uix:contents>
                                                  <uix:styledText textBinding="avgSrvRespTime@"/>
                                                </uix:contents>
                                              </uix:column>
                                              <uix:column>
                                                <uix:columnFormat columnDataFormat="numberFormat"/>
                                                <uix:columnHeader>
                                                  <uix:sortableHeader textBinding="MAX@userMntrMsg"
                                                                      sortableBinding="maxSrvRespTime@detailSortStates@"
                                                                      value="6"/>
                                                </uix:columnHeader>
                                                <uix:contents>
                                                  <uix:styledText textBinding="maxSrvRespTime@"/>
                                                </uix:contents>
                                              </uix:column>
                                              <uix:column>
                                                <uix:columnFormat columnDataFormat="numberFormat"/>
                                                <uix:columnHeader>
                                                  <uix:sortableHeader textBinding="STDDEV_SEC_COL@userMntrMsg"
                                                                      sortableBinding="stdDevSrvTime@detailSortStates@"
                                                                      value="7"/>
                                                </uix:columnHeader>
                                                <uix:contents>
                                                  <uix:styledText textBinding="stdDevSrvTime@"/>
                                                </uix:contents>
                                              </uix:column>
                                            </uix:columnGroup>
                                            <% if ( eumAnalyzeUIData.getIsFormType() ) { %>
                                            <uix:columnGroup>
                                              <uix:columnHeader>
                                                <uix:text textBinding="DATABASE_TIME@userMntrMsg"/>
                                              </uix:columnHeader>
                                              <uix:column>
                                                <uix:columnFormat columnDataFormat="numberFormat"/>
                                                <uix:columnHeader>
                                                  <uix:sortableHeader textBinding="AVG@userMntrMsg"
                                                                      sortableBinding="avgDBRespTime@detailSortStates@"
                                                                      value="8"/>
                                                </uix:columnHeader>
                                                <uix:contents>
                                                  <uix:styledText textBinding="avgDBRespTime@"/>
                                                </uix:contents>
                                              </uix:column>
                                              <uix:column>
                                                <uix:columnFormat columnDataFormat="numberFormat"/>
                                                <uix:columnHeader>
                                                  <uix:sortableHeader textBinding="MAX@userMntrMsg"
                                                                      sortableBinding="maxDBRespTime@detailSortStates@"
                                                                      value="9"/>
                                                </uix:columnHeader>
                                                <uix:contents>
                                                  <uix:styledText textBinding="maxDBRespTime@"/>
                                                </uix:contents>
                                              </uix:column>
                                              <uix:column>
                                                <uix:columnFormat columnDataFormat="numberFormat"/>
                                                <uix:columnHeader>
                                                  <uix:sortableHeader textBinding="STDDEV_SEC_COL@userMntrMsg"
                                                                      sortableBinding="stdDevDBTime@detailSortStates@"
                                                                      value="10"/>
                                                </uix:columnHeader>
                                                <uix:contents>
                                                  <uix:styledText textBinding="stdDevDBTime@"/>
                                                </uix:contents>
                                              </uix:column>
                                            </uix:columnGroup>
                                            <% } %>
                                          </uix:contents>
                                        </uix:table>
                                      </uix:rowLayout>
                                      <%-- 
                                        columnStatus
                                      --%>
                                    </uix:header>
                                  </uix:case>
                                  <uix:case name="<%=EUMConstants.SHOW%>">
                                    <uix:header textBinding="SAMPLES@webappMsg">
                                      <uix:tableLayout>
                                        <uix:formValue name="axis"
                                                       valueBinding="axis"/>
                                        <uix:formValue name="axisValue"
                                                       valueBinding="axisValue"/>
                  <uix:messageTextInput promptBinding="SEARCH@webappMsg"
                                        name="<%=EUMConstants.SEARCH_STRING%>"
                                        textBinding="<%=EUMConstants.SEARCH_STRING%>">
                    <uix:end>
                    <uix:flowLayout>
                    <uix:choice name="viewBy"
                                                      selectedValueBinding="selectedViewBy"
                                                      required="yes"
                               shortDescBinding="SEARCH_AXIS@webappMsg">
                                            <uix:contents childDataBinding="viewBySampleChoices">
                                              <uix:option textBinding="text"
                                                          valueBinding="value"/>
                                            </uix:contents>
                                          </uix:choice>
                   <uix:spacer width="5"/>
                   <uix:submitButton textBinding="GO@webappMsg" name="event"
                                     value="<%=EUMConstants.SEARCH%>"/>
                    </uix:flowLayout>
                    </uix:end>
                  </uix:messageTextInput>
                                        <uix:rowLayout>
                                          <uix:spacer height="5"/>
                                        </uix:rowLayout>
                                      </uix:tableLayout>
                                      <uix:table id="analyzeReportsTbl"
                                                 alternateTextBinding="NO_END_USER_DATA@webappMsg"
                                                 width="100%"
                                                 formSubmitted="true"
                                                 blockSizeBinding="tableDataBlockSize"
                                                 tableDataBinding="tableData@"
                                                 maxValueBinding="tableDataSize"
                                                 valueBinding="tableDataCurPos"
                                                 columnFormatsBinding="reportTableColFormats"
                                                 columnHeaderDataBinding="reportTableColHeaders@"
                                                 summaryBinding="SAMPLES@webappMsg">
                                        <uix:tableFormat tableBanding="rowBanding"/>
                                        <uix:columnHeaderStamp>
                                          <uix:sortableHeader textBinding="text"
                                                              sortableBinding="sortable"/>
                                        </uix:columnHeaderStamp>
                                        <uix:contents>
                                          <uix:styledText textBinding="url@"
                                                          shortDescBinding="shortDesc@"/>
                                          <uix:styledText textBinding="visitor@"/>
                                          <uix:styledText textBinding="analyze_collection_timestamp@"/>
                                          <uix:styledText textBinding="avgRespTime@"/>
                                          <uix:styledText textBinding="avgSrvRespTime@"/>
                                          <uix:styledText textBinding="avgDBRespTime@"
                                                          renderedBinding="isFormType@eumAnalyzeUIData@servletRequest"/>
                                          <uix:styledText textBinding="browserOS@"/>
                                          <uix:styledText textBinding="browser@"/>
                                        </uix:contents>
                                      </uix:table>
                                    </uix:header>
                                  </uix:case>
                                </uix:switcher>
                              </uix:stackLayout>
                            </uix:header>
                          </uix:case>
                        </uix:switcher>
                        <%-- 
                          wasSearchRun
                        --%>
                        <uix:switcher childNameBinding="isDataAvailable"
                                      defaultCase="false">
                          <uix:case name="true">
                            <uix:header textBinding="AVAILABLE_DATA@webappMsg">
                              <uix:stackLayout>
                                <uix:contents>
                                  <uix:styledText textBinding="EUM_ACTIVITY_TXT@webappMsg"
                                                  styleClass="OraPromptText"/>
                                  <uix:tableLayout>
                                    <uix:messageStyledText promptBinding="START_TIME@sdkUIMsg"
                                                           textBinding="dataStartTimeMsg"
                                                           styleClass="OraPromptText"/>
                                    <uix:messageStyledText promptBinding="END_TIME@sdkUIMsg"
                                                           textBinding="dataEndTimeMsg"
                                                           styleClass="OraPromptText"/>
                                  </uix:tableLayout>
                                </uix:contents>
                              </uix:stackLayout>
                            </uix:header>
                          </uix:case>
                        </uix:switcher>
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:case>
                </uix:switcher>
                <uix:spacer height="10"/>
                <uix:tip textBinding="ANALYZE_DATA_PERF_TIP_TEXT@webappMsg"/>
              </uix:form>
            </uix:header>
          </uix:contents>
        </uix:stackLayout>
      </uix:dataScope>
    </uix:pageLayout>
  </uix:body>
</uix:renderingContext>
