<%--

/* $Header: analyzeReportsSelect.jsp 07-jun-2005.14:43:50 eporter Exp $ */
/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      eporter   06/07/05 - Bug 4415243: ADA compliance 
      eporter   05/23/05 - Bug 4387076: Two word regions/webservers don't work
      eporter   02/01/05 - creation
 */

/**
 *  @version analyzeReportsSelect.jsp 01-feb-2005.13:08:22 eporter Exp $
 *  @author  eporter
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.webapp.eum.data.EUMConstants"%>
<script language="JavaScript" src="/em/cabo/jsLibs/TableProxy.js"></script>
<script language="JavaScript">
function returnSelect()
{
  var proxy = new TableProxy("resultTable");
  var indexes = "";

  if (proxy.isMultiSelect())
  {
    var selectedItems = proxy.getSelectedRows();
    if (selectedItems != null)
    { 
      indexes = proxy.getFormElement("item", selectedItems[0]).value;
      for(var i = 1; i < selectedItems.length; i++)
      {
        indexes += ", " + proxy.getFormElement("item", selectedItems[i]).value;
      }
    }
  }
  else
  {
    var selectedIndex = proxy.getSelectedRow();
    if (selectedIndex != null)
    {
      indexes = proxy.getFormElement("item", selectedIndex).value;
    }
  }
  
  var invisibleItems = document.selectKeyValues.invisibleItems.value;
  window.opener.mySelectedIndexes = indexes + invisibleItems;
  window.opener.myCallBack();
  
  top.close();
}
</script>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="notifResourceBundle"
              class="oracle.sysman.resources.NotifMsg"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"%>
    <%@ include file="/oemNoscript.jspf" %>
    <uix:body>
      <uix:switcher childNameBinding="nodeValue@servletRequest">
        <uix:case name="okNode">
          <uix:form name="selectKeyValues" method="POST">
            <uix:pageLayout>
              <uix:contentFooter>
                <uix:pageButtonBar>
                  <uix:button textBinding="CANCEL_BUTTON@commonResourceBundle"
                              onClick="top.close();"/>
                  <uix:button textBinding="SELECT@commonResourceBundle"
                              onClick="returnSelect();"/>
                </uix:pageButtonBar>
              </uix:contentFooter>
              <uix:dataScope currentDataBinding="lovData@servletRequest">
                <uix:formValue name="axis" valueBinding="axis"/>
                <uix:formValue name="invisibleItems" valueBinding="invisibleItems"/>
                <uix:stackLayout>
                  <uix:switcher childNameBinding="isLargeResultSet"
                                defaultCase="<%=EUMConstants.NOT_LARGE%>">
                    <uix:case name="<%=EUMConstants.LARGE%>">
                      <uix:messageBox messageType="info"
                                      messageBinding="largeResultSetMsg"/>
                    </uix:case>
                  </uix:switcher>
                  <uix:header textBinding="header@servletRequest">
                    <uix:spacer height="5"/>
                    <uix:stackLayout>
                      <uix:spacer width="20"/>
                      <uix:stackLayout>
                        <uix:header textBinding="SEARCH@commonResourceBundle">
                          <uix:styledText textBinding="invisibleItems"/>
                          <uix:rowLayout>
                            <uix:messageTextInput name="searchName"
                                                  promptBinding="SEARCH@commonResourceBundle"
                                                  columns="40"
                                                  textBinding="searchName"/>
                            <uix:spacer width="8"/>
                            <uix:submitButton textBinding="GO@notifResourceBundle"
                                              name="event" value="search"/>
                          </uix:rowLayout>
                        </uix:header>
                        <uix:header textBinding="RESULTS@commonResourceBundle">
                          <uix:rowLayout hAlign="right">
                            <uix:button textBinding="CANCEL_BUTTON@commonResourceBundle"
                                        onClick="top.close();"/>
                            <uix:spacer width="10"/>
                            <uix:button textBinding="SELECT@commonResourceBundle"
                                        onClick="returnSelect();"/>
                          </uix:rowLayout>
                          <uix:spacer height="25"/>
                          <uix:table id="resultTable" name="resultTable"
                                     formSubmitted="true"
                                     width="100%" tableDataBinding="tableData"
                                     blockSizeBinding="tableDataBlockSize"
                                     maxValueBinding="tableDataSize"
                                     valueBinding="tableDataCurPos"
                                     alternateTextBinding="noDataMsg"
                                     columnFormatsBinding="tableColFormats"
                                     columnHeaderDataBinding="tableColHeaders@"
                                     summaryBinding="RESULTS@commonResourceBundle">
                            <uix:tableFormat tableBanding="rowBanding"/>
                            <uix:columnHeaderStamp>
                              <uix:sortableHeader textBinding="text"
                                                  sortableBinding="sortable"/>
                            </uix:columnHeaderStamp>
                            <uix:contents>
                              <uix:styledText textBinding="item@"/>
                              <uix:formValue name="item" valueBinding="item@"/>
                            </uix:contents>
                            <uix:tableSelection>
                              <uix:multipleSelection selectedBinding="selected@"
                                                     shortDescBinding="item@"/>
                            </uix:tableSelection>
                          </uix:table>
                          <uix:spacer height="10"/>
                        </uix:header>
                      </uix:stackLayout>
                    </uix:stackLayout>
                  </uix:header>
                </uix:stackLayout>
              </uix:dataScope>
            </uix:pageLayout>
          </uix:form>
        </uix:case>
        <uix:case name="errNode">
          <uix:messageBox messageBinding="errorMessage@servletRequest"
                          messageType="error"
                          shortDescBinding="ERR_OCCUR@mntrResourceBundle"
                          textBinding="ERR_OCCUR@mntrResourceBundle"/>
        </uix:case>
      </uix:switcher>
    </uix:body>
  </uix:document>
</uix:renderingContext>