<%--

/* $Header: apacheConfig.jsp 10-aug-2005.12:54:38 andyao Exp $ */
/* Copyright (c) 2001, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
     End User Monitoring Apache Configuration Page.

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED (MM/DD/YY)
   andyao    08/10/05 - fix header 
   yxie      07/15/05 - add short description to image
   eporter   06/08/05 - Bug 4415243: ADA compliance 
   yxie      04/20/05 - 
   yxie      04/07/05 - add apache type
   yxie      03/09/05 - add table sorting and navigation
   yxie      02/07/05 - redesign apache configuration page with apache installed
   yxie      12/21/04 - fix more apache config ui issues
   yxie      11/13/04 - yxie_apacheui
   yxie      10/18/04 - Creation.
 */

/**
 *  @version $Header: apacheConfig.jsp 10-aug-2005.12:54:38 andyao Exp $
 *  @author  yxie
 *  @since   release specific (what release of product did this appear in)
 */

--%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.sysman.eml.webapp.WebappConstants'%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
  <uix:bundle name="cmnMsg" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrMsg" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>  
    <%@ include file="/oemNoscript.jspf" %>  
    <uix:body>
      <uix:dataScope currentDataBinding="apacheConfigData@servletRequest" >
        <uix:form name="ApacheSetup" method="post">
          <uix:pageLayout>
            <%@ include file="/oemGlobal.jspf" %>
            <uix:contentFooter>
              <uix:pageButtonBar>
                <uix:submitButton name="event" value="cancelConfig" textBinding="CANCEL@cmnMsg"/> 
                <uix:submitButton name="event" value="applyConfig" textBinding="OK@cmnMsg"/>
              </uix:pageButtonBar>
            </uix:contentFooter>

            <uix:switcher childNameBinding="hasError">
              <uix:case name="<%=Boolean.TRUE%>">
                <uix:messageBox messageBinding="errorMsg" messageType="error"/>
              </uix:case>
            </uix:switcher>

            <uix:header textBinding="configApacheHeader" >
              <uix:tableLayout width="100%">
                <uix:contents>
                  <uix:rowLayout hAlign="right" width="100%">

                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraInstructionText" 
                                      textBinding="APACHE_MODULE_CONFIGURATION_TXT@webappMsg"/>
                    </uix:cellFormat>

                    <uix:spacer width="5"/>

                    <uix:cellFormat hAlign="right" vAlign="top">
                      <uix:submitButton name="event" value="cancelConfig" textBinding="CANCEL@cmnMsg"/> 
                      <uix:spacer width="10"/>
                      <uix:submitButton name="event" value="applyConfig" textBinding="OK@cmnMsg"/>
                    </uix:cellFormat>

                  </uix:rowLayout>

                  <uix:rowLayout width="100%">
                    <uix:stackLayout>
                      <uix:spacer height="10"/>
                    </uix:stackLayout>
                  </uix:rowLayout>

                  <uix:rowLayout hAlign="center">
                    <uix:contents>
                      <uix:tableLayout hAlign="center" cellSpacing="2">
                        <uix:contents>
                          <uix:messageStyledText promptBinding="HOST_VALUE_LABEL@webappMsg" 
                                                 textBinding="host" 
                                                 styleClass="oraDataText"/>
                          <uix:rowLayout>
                            <uix:stackLayout>
                              <uix:spacer height="4"/>
                            </uix:stackLayout>
                          </uix:rowLayout>
                          <uix:messageStyledText promptBinding="USERNAME_HDR@webappMsg" 
                                                   textBinding="userName" 
                                                   styleClass="oraDataText"/>
                        </uix:contents>
                      </uix:tableLayout>        
                    </uix:contents>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:stackLayout>
                      <uix:header textBinding="SITE_MONITORING@webappMsg">
                        <uix:contents>
                          <uix:stackLayout>
                            <%--uix:styledText styleClass="OraInstructionText" textBinding="SITE_CONFIGURATION_MESSAGE@webappMsg"/> 
                            <uix:spacer width="5" height="10"/--%>
                            <uix:header textBinding="configTableHeader" >
                              <uix:spacer height="5"/>
                              <uix:table  name="siteConfigTable"
                                          alternateTextBinding="NO_SITE_CONFIGURATION_AVAILABLE@webappMsg"
                                          showAll="yes"
                                          width="100%"
                                          tableDataBinding="siteConfigTableData"
                                          columnHeaderDataBinding="siteConfigTableHeaderData"
                                          formSubmitted="true"
                                          maxValueBinding="siteConfigTableMaxValue"
                                          valueBinding="siteConfigTableValue"
                                          blockSizeBinding="siteConfigTableBlockSize"
                                          summaryBinding="configTableHeader">
                                <uix:columnHeaderStamp>
                                  <uix:text textBinding="text"/>
                                </uix:columnHeaderStamp>

                                <uix:tableActions>
                                  <uix:flowLayout>
                                    <uix:contents>
                                      <uix:submitButton name="event" value="enableAll" textBinding="ENABLE_ALL@webappMsg"/>
                                      <uix:submitButton name="event" value="disableAll" textBinding="DISABLE_ALL@webappMsg"/>                             
                                    </uix:contents>
                                  </uix:flowLayout>
                                </uix:tableActions>

                                <uix:tableSelection>
                                  <uix:singleSelection selectedIndex="0" shortDescBinding="site">
                                    <uix:submitButton textBinding="SET_URLS@webappMsg" name="event" value="setUrlsToMonitor"/>
                                  </uix:singleSelection>
                                </uix:tableSelection> 
 
                                <uix:contents>
                                  <uix:messageStyledText textBinding="site"/> 
                                  <uix:column>
                                    <uix:columnFormat columnDataFormat="iconButtonFormat" width="5"/>
                                    <uix:rowLayout hAlign="center">
                                      <uix:image sourceBinding="chronosStatIcon"
                                                  shortDescBinding="chronosStatDesc"/>
                                   </uix:rowLayout>
                                 </uix:column>

                                 <uix:column>
                                   <uix:rowLayout hAlign="center">
                                     <uix:checkBox name="enableEum"
                                                   value="1"
                                                   checkedBinding="enabledEum"
                                                   disabledBinding="agentDown@apacheConfigData@servletRequest"
                                                   shortDescBinding="ENABLE_MONITORING@webappMsg"/>
                                   </uix:rowLayout>
                                 </uix:column>

                                 <uix:column>
                                   <uix:messageTextInput name="logFile" textBinding="logFileName" shortDescBinding="LOG_FILE_NAME@webappMsg"/>
                                 </uix:column>
                               </uix:contents>
                             </uix:table>
 
                             <uix:spacer width="1" height="5"/>
                             <uix:tip>
                               <uix:contents>
                                <uix:text textBinding="APACHE_SAME_LOG_TIP@webappMsg"/>
                               </uix:contents>
                             </uix:tip>
                              
                             <uix:spacer height="10"/>

                             <uix:rowLayout hAlign="left">
                               <uix:styledText textBinding="RELATED_LINK@webappMsg" styleClass="OraDataText" />
                               <uix:spacer width="10" />
                               <uix:link textBinding="monitorConfigLinkText"
                                         destinationBinding="monitorConfigURL"/>
                             </uix:rowLayout>
                           </uix:header>
                         </uix:stackLayout>
                       </uix:contents>
                     </uix:header>



                 <uix:switcher childNameBinding="installedNotRestarted">
                   <uix:case name="<%=Boolean.FALSE%>">
                     <uix:header textBinding="APACHE_MODULE_INSTALLATION_HDR@webappMsg">
                       <uix:contents>
                         <uix:rowLayout width="100%">
                           <uix:cellFormat hAlign="left" width="60%">
                             <uix:contents>
                               <uix:styledText textBinding="UNINSTALL_APACHE_MODULE_MSG@webappMsg" styleClass="OraInstructiontext" />
                             </uix:contents>
                           </uix:cellFormat>
                           <uix:cellFormat hAlign="right" width="40%">
                             <uix:contents>
                               <uix:submitButton name="event" value="uninstallApache" textBinding="UNINSTALL_APACHE_MODULE@webappMsg"/>
                             </uix:contents>
                           </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:contents>
                    </uix:header>
                   </uix:case>
                 </uix:switcher>

                    <uix:spacer width="10" />
                  </uix:stackLayout>
                </uix:rowLayout>
              </uix:contents>
            </uix:tableLayout>
          </uix:header>
        </uix:pageLayout>
        <uix:formValue name="<%=WebappConstants.APACHE_NAME%>"
                       valueBinding="apacheName"/>
        <uix:formValue name="<%=WebappConstants.APACHE_TYPE%>"
                       valueBinding="apacheType"/>
      </uix:form>
    </uix:dataScope>    
  </uix:body>
  </uix:document>
</uix:renderingContext> 
